/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Messages {
    private static final String BUNDLE_NAME = "messages.Bundle";
    private static final String BUNDLE_NAME_SUFFIX = ".messages.Bundle";
    private final ResourceBundle bundle;

    private Messages(Class clazz, Locale locale) {
        this.bundle = ResourceBundle.getBundle(Messages.getBundleName(clazz), locale, clazz.getClassLoader());
    }

    public static Messages getMessages(Class clazz) {
        return new Messages(clazz, Locale.getDefault());
    }

    public static Messages getMessages(Class clazz, Locale locale) {
        if (locale == null) {
            return new Messages(clazz, Locale.getDefault());
        }
        return new Messages(clazz, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, Object ... args) {
        String rawValue;
        try {
            ResourceBundle resourceBundle = this.bundle;
            synchronized (resourceBundle) {
                rawValue = this.bundle.getString(key);
            }
        }
        catch (MissingResourceException e) {
            return key;
        }
        try {
            return MessageFormat.format(rawValue, args);
        }
        catch (IllegalArgumentException e) {
            return rawValue;
        }
    }

    private static String getBundleName(Class clazz) {
        String packageName = Messages.getPackageName(clazz);
        if (packageName.length() == 0) {
            return BUNDLE_NAME;
        }
        return packageName.concat(BUNDLE_NAME_SUFFIX);
    }

    private static String getPackageName(Class clazz) {
        Package pack = clazz.getPackage();
        if (pack != null) {
            return pack.getName();
        }
        String className = clazz.isArray() ? clazz.getComponentType().getName() : clazz.getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex > 0) {
            return className.substring(0, lastDotIndex);
        }
        return "";
    }
}

