/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jca;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jca.CommareaRecord;
import it.imolinfo.jbi4cics.connection.jca.JCAAbstractConnectionManager;
import it.imolinfo.jbi4cics.exception.ConnectionException;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.service.ServiceContext;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public abstract class JCACommareaBasedConnectionManager
extends JCAAbstractConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JCACommareaBasedConnectionManager.class);

    protected Object createOutputMessage(ServiceContext serviceContext, Record outputRecord) throws ConnectionException {
        if (!(outputRecord instanceof CommareaRecord)) {
            throw new ConnectionException("CIC000310_Expected_commarea_record", new Object[]{outputRecord.getClass()});
        }
        return ((CommareaRecord)outputRecord).getCommarea();
    }

    protected Record createOutputRecord(ServiceContext serviceContext) throws ConnectionException {
        CommareaRecord outputRecord = new CommareaRecord();
        if (!(serviceContext.getOutputMappingDescriptor() instanceof CommareaBeanMappingDescriptor)) {
            throw new ConnectionException("CIC000311_Expected_commarea_bean_mapping_descriptor", new Object[]{serviceContext.getOutputMappingDescriptor().getClass()});
        }
        CommareaBeanMappingDescriptor outputMappingDescriptor = (CommareaBeanMappingDescriptor)serviceContext.getOutputMappingDescriptor();
        try {
            outputRecord.setCommareaLength(outputMappingDescriptor.getBufferedLength());
        }
        catch (FormatException e) {
            LOG.error("CIC000312_Error_setting_commarea_lengths", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000312_Error_setting_commarea_lengths", new Object[]{e.getMessage()}, e);
        }
        return outputRecord;
    }

    protected Record createInputRecord(ServiceContext serviceContext) throws ConnectionException {
        CommareaRecord inputRecord = new CommareaRecord();
        Object inputMessage = serviceContext.getInputMessage();
        if (!(inputMessage instanceof byte[])) {
            throw new ConnectionException("CIC000313_Expected_byte[]_input_message", new Object[]{inputMessage.getClass()});
        }
        inputRecord.setCommarea((byte[])inputMessage);
        return inputRecord;
    }

    protected abstract InteractionSpec createInteractionSpec(ServiceContext var1) throws ConnectionException;

    protected abstract ConnectionSpec createConnectionSpec(ServiceContext var1) throws ConnectionException;
}

