/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.hl7.validator;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import junit.framework.TestCase;
import org.netbeans.modules.wsdlextensions.hl7.validator.HL7BCValidatorSchemaFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaTest
extends TestCase {
    private Exception mLastError;
    private URL schemaUrl = SchemaTest.class.getResource("/org/netbeans/modules/wsdlextensions/hl7/resources/hl7-ext.xsd");

    public SchemaTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testSchema() throws Exception {
        MyErrorHandler errorHandler = new MyErrorHandler();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setErrorHandler(errorHandler);
        HL7BCValidatorSchemaFactory fac = new HL7BCValidatorSchemaFactory();
        Source s = fac.getSchemaSource();
        Schema schema = sf.newSchema(s);
        SchemaTest.assertNotNull((String)"schema should not be null", (Object)schema);
        SchemaTest.assertNull((String)"No exception should occur in schema parsing", (Object)this.mLastError);
    }

    class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            SchemaTest.this.mLastError = exception;
            exception.printStackTrace();
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            SchemaTest.this.mLastError = exception;
            exception.printStackTrace();
        }

        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }
}

