/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.xsdbuilder;

import com.sun.encoder.codegen.Emit;
import com.sun.encoder.hl7.xsdbuilder.BaseGenerator;
import com.sun.encoder.hl7.xsdbuilder.GeneratorException;
import com.sun.encoder.hl7.xsdbuilder.NameGenerator;
import com.sun.encoder.hl7.xsdbuilder.XSDGenerator;
import com.sun.encoder.util.UnicodeFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesGenerator
extends BaseGenerator
implements XSDGenerator {
    public static final String SNDMSGEVENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/sndmsgevents.sql";
    public static final String RETMSGEVENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/retmsgevents.sql";
    public static final String MSGEVENTSEGMENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/msgeventsegments.sql";
    public static final String MSGSTRUCTS_SQL = "com/sun/encoder/hl7/xsdbuilder/msgstructs.sql";
    public static final String MSGSTRUCTSEGMENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/msgstructsegments.sql";
    private final NameGenerator mNameGen;

    MessagesGenerator(Connection conn, String version, File targetLocation, NameGenerator nameGen) {
        super(conn, version, targetLocation);
        this.mNameGen = nameGen;
    }

    /*
     * Loose catch block
     */
    @Override
    public void generate() throws GeneratorException {
        HashSet<String> generatedMsgs;
        block46: {
            SQLException e2222;
            SQLException expRet;
            ResultSet rsOneMsg;
            ResultSet rsMsgs;
            Statement pstmtMsgEvtSegs;
            PreparedStatement pstmtMsgStructSegs;
            Statement pstmtMsgs;
            block41: {
                Message message;
                String evtCode;
                String msgType;
                String msgStruct;
                HashSet<String> processedMsgs = new HashSet<String>();
                generatedMsgs = new HashSet<String>();
                pstmtMsgs = null;
                pstmtMsgStructSegs = null;
                pstmtMsgEvtSegs = null;
                rsMsgs = null;
                rsOneMsg = null;
                String sqlOneMsg = this.getSQLStmt(MSGSTRUCTSEGMENTS_SQL);
                pstmtMsgStructSegs = this.mConn.prepareStatement(sqlOneMsg, 1004, 1007);
                sqlOneMsg = this.getSQLStmt(MSGEVENTSEGMENTS_SQL);
                pstmtMsgEvtSegs = this.mConn.prepareStatement(sqlOneMsg, 1004, 1007);
                String sqlMsgs = this.getSQLStmt(SNDMSGEVENTS_SQL);
                pstmtMsgs = this.mConn.prepareStatement(sqlMsgs, 1004, 1007);
                pstmtMsgs.setString(1, this.mHL7Version);
                rsMsgs = pstmtMsgs.executeQuery();
                rsMsgs.beforeFirst();
                while (rsMsgs.next()) {
                    msgStruct = rsMsgs.getString("msg_struct");
                    msgType = rsMsgs.getString("msg_type");
                    evtCode = rsMsgs.getString("evt_code");
                    if (msgStruct == null || msgStruct.equals("?") || msgStruct.equals("NUL")) {
                        msgStruct = msgType + "_" + evtCode;
                    }
                    if (processedMsgs.contains(msgStruct)) continue;
                    pstmtMsgStructSegs.setString(1, this.mHL7Version);
                    pstmtMsgStructSegs.setString(2, msgStruct);
                    rsOneMsg = pstmtMsgStructSegs.executeQuery();
                    message = new Message(msgStruct, this.mNameGen);
                    if (!this.loadMessage(rsOneMsg, message)) {
                        rsOneMsg.close();
                        rsOneMsg = null;
                        pstmtMsgEvtSegs.setString(1, this.mHL7Version);
                        pstmtMsgEvtSegs.setString(2, msgType);
                        pstmtMsgEvtSegs.setString(3, evtCode);
                        rsOneMsg = pstmtMsgEvtSegs.executeQuery();
                        if (!this.loadMessage(rsOneMsg, message)) {
                            rsOneMsg.close();
                            rsOneMsg = null;
                            processedMsgs.add(msgStruct);
                            continue;
                        }
                    }
                    rsOneMsg.close();
                    rsOneMsg = null;
                    System.out.println(msgStruct);
                    this.generateOneMessage(message);
                    processedMsgs.add(msgStruct);
                    generatedMsgs.add(msgStruct);
                }
                rsMsgs.close();
                rsMsgs = null;
                pstmtMsgs.close();
                pstmtMsgs = null;
                sqlMsgs = this.getSQLStmt(RETMSGEVENTS_SQL);
                pstmtMsgs = this.mConn.prepareStatement(sqlMsgs, 1004, 1007);
                pstmtMsgs.setString(1, this.mHL7Version);
                rsMsgs = pstmtMsgs.executeQuery();
                rsMsgs.beforeFirst();
                while (rsMsgs.next()) {
                    msgStruct = rsMsgs.getString("msg_struct");
                    msgType = rsMsgs.getString("msg_type");
                    evtCode = rsMsgs.getString("evt_code");
                    if (msgStruct == null || msgStruct.equals("?") || msgStruct.equals("NUL")) {
                        msgStruct = msgType + "_" + evtCode;
                    }
                    if (processedMsgs.contains(msgStruct)) continue;
                    pstmtMsgStructSegs.setString(1, this.mHL7Version);
                    pstmtMsgStructSegs.setString(2, msgStruct);
                    rsOneMsg = pstmtMsgStructSegs.executeQuery();
                    message = new Message(msgStruct, this.mNameGen);
                    if (!this.loadMessage(rsOneMsg, message)) {
                        rsOneMsg.close();
                        rsOneMsg = null;
                        pstmtMsgEvtSegs.setString(1, this.mHL7Version);
                        pstmtMsgEvtSegs.setString(2, msgType);
                        pstmtMsgEvtSegs.setString(3, evtCode);
                        rsOneMsg = pstmtMsgEvtSegs.executeQuery();
                        if (!this.loadMessage(rsOneMsg, message)) {
                            rsOneMsg.close();
                            rsOneMsg = null;
                            processedMsgs.add(msgStruct);
                            continue;
                        }
                    }
                    rsOneMsg.close();
                    rsOneMsg = null;
                    System.out.println(msgStruct);
                    this.generateOneMessage(message);
                    processedMsgs.add(msgStruct);
                    generatedMsgs.add(msgStruct);
                }
                rsMsgs.close();
                rsMsgs = null;
                pstmtMsgs.close();
                pstmtMsgs = null;
                sqlMsgs = this.getSQLStmt(MSGSTRUCTS_SQL);
                pstmtMsgs = this.mConn.prepareStatement(sqlMsgs, 1004, 1007);
                pstmtMsgs.setString(1, this.mHL7Version);
                rsMsgs = pstmtMsgs.executeQuery();
                rsMsgs.beforeFirst();
                while (rsMsgs.next()) {
                    msgStruct = rsMsgs.getString("msg_struct");
                    if (msgStruct == null || msgStruct.equals("?") || msgStruct.equals("NUL") || processedMsgs.contains(msgStruct)) continue;
                    pstmtMsgStructSegs.setString(1, this.mHL7Version);
                    pstmtMsgStructSegs.setString(2, msgStruct);
                    rsOneMsg = pstmtMsgStructSegs.executeQuery();
                    Message message2 = new Message(msgStruct, this.mNameGen);
                    if (!this.loadMessage(rsOneMsg, message2)) {
                        rsOneMsg.close();
                        rsOneMsg = null;
                        processedMsgs.add(msgStruct);
                        continue;
                    }
                    rsOneMsg.close();
                    rsOneMsg = null;
                    System.out.println(msgStruct);
                    this.generateOneMessage(message2);
                    processedMsgs.add(msgStruct);
                    generatedMsgs.add(msgStruct);
                }
                rsMsgs.close();
                rsMsgs = null;
                pstmtMsgs.close();
                pstmtMsgs = null;
                Object var15_16 = null;
                expRet = null;
                if (rsOneMsg == null) break block41;
                try {
                    rsOneMsg.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtMsgStructSegs != null) {
                try {
                    pstmtMsgStructSegs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtMsgEvtSegs != null) {
                try {
                    pstmtMsgEvtSegs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (rsMsgs != null) {
                try {
                    rsMsgs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtMsgs != null) {
                try {
                    pstmtMsgs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (expRet != null) {
                throw new GeneratorException(expRet);
            }
            break block46;
            {
                catch (IOException e3) {
                    throw new GeneratorException(e3);
                }
                catch (SQLException e4) {
                    throw new GeneratorException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e2222;
                Object var15_17 = null;
                expRet = null;
                if (rsOneMsg != null) {
                    try {
                        rsOneMsg.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtMsgStructSegs != null) {
                    try {
                        pstmtMsgStructSegs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtMsgEvtSegs != null) {
                    try {
                        pstmtMsgEvtSegs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (rsMsgs != null) {
                    try {
                        rsMsgs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtMsgs != null) {
                    try {
                        pstmtMsgs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (expRet != null) {
                    throw new GeneratorException(expRet);
                }
                throw throwable;
            }
        }
        this.generateMessagesXSD(generatedMsgs);
        this.generateBatchXSD();
    }

    private void printMsgHeader(Emit emit, String msgName) {
        emit.emit("<?xml version =\"1.0\" encoding=\"UTF-8\"?>");
        emit.down("<!--");
        emit.emit("v2.xml Message Definitions Version v" + this.mHL7Version + "  - " + msgName);
        emit.emit("Copyright (C) Sun Microsystems. All rights reserved.");
        emit.done("-->");
        emit.down("<xsd:schema");
        emit.emit("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        emit.emit("xmlns=\"urn:hl7-org:v2xml\"");
        emit.emit("xmlns:hl7=\"urn:com.sun:encoder-hl7-1.0\"");
        emit.emit("targetNamespace=\"urn:hl7-org:v2xml\" xmlns:jaxb=\"http://java.sun.com/xml/ns/jaxb\" jaxb:version=\"2.0\">");
        emit.emit();
        emit.emit("<!-- include segment definitions for version v" + this.mHL7Version + " -->");
        emit.emit("<xsd:include schemaLocation=\"segments.xsd\"/>");
        emit.emit();
        emit.down("<xsd:annotation>");
        emit.down("<xsd:appinfo source=\"urn:com.sun:encoder\">");
        emit.emit("<encoding xmlns=\"urn:com.sun:encoder\" name=\"HL7 v2 Encoding\" namespace=\"urn:com.sun:encoder-hl7-1.0\" style=\"hl7encoder-1.0\"/>");
        emit.done("</xsd:appinfo>");
        emit.done("</xsd:annotation>");
        emit.emit();
        emit.down("<!--");
        emit.emit("MESSAGE " + msgName);
        emit.done("-->");
    }

    private void printMsgFooter(Emit emit) {
        emit.done("</xsd:schema>");
    }

    private void generateOneMessage(Message message) throws SQLException, FileNotFoundException, IOException {
        Writer writer = this.getWriter(message.getName());
        Emit emit = new Emit(writer);
        this.printMsgHeader(emit, message.getName());
        StringBuffer groupDefinition = new StringBuffer();
        StringBuffer contentDefinition = new StringBuffer();
        HashMap<String, Group> namesUsed = new HashMap<String, Group>();
        message.toXSD(groupDefinition, contentDefinition, namesUsed);
        emit.emit("<!-- .. groups used in message " + message.getName() + " -->");
        writer.write(groupDefinition.toString());
        emit.emit("<!-- .. message definition " + message.getName() + " -->");
        writer.write(contentDefinition.toString());
        this.printMsgFooter(emit);
        emit.close();
        this.moveFile(this.getTempTargetFile(message.getName()), this.getTargetFile(message.getName()));
    }

    private boolean loadMessage(ResultSet rs, Message message) throws SQLException {
        boolean hasRecords = false;
        Stack<Group> groupStack = new Stack<Group>();
        groupStack.push(message);
        Group currentGroup = message;
        while (rs.next()) {
            String segCode = rs.getString("seg_code");
            if ("?".equals(segCode)) continue;
            hasRecords = true;
            if ("[".equals(segCode)) {
                groupStack.push(new Sequence(message.getName(), rs.getString("groupname"), this.mNameGen));
                currentGroup.addElement((Element)groupStack.peek());
                currentGroup = (Group)groupStack.peek();
                currentGroup.setOptional(true);
                continue;
            }
            if ("[{".equals(segCode)) {
                groupStack.push(new Sequence(message.getName(), rs.getString("groupname"), this.mNameGen));
                currentGroup.addElement((Element)groupStack.peek());
                currentGroup = (Group)groupStack.peek();
                currentGroup.setOptional(true);
                currentGroup.setRepet(true);
                continue;
            }
            if ("]".equals(segCode)) {
                groupStack.pop();
                currentGroup = (Group)groupStack.peek();
                continue;
            }
            if ("{".equals(segCode)) {
                groupStack.push(new Sequence(message.getName(), rs.getString("groupname"), this.mNameGen));
                currentGroup.addElement((Element)groupStack.peek());
                currentGroup = (Group)groupStack.peek();
                currentGroup.setRepet(true);
                continue;
            }
            if ("|".equals(segCode)) continue;
            if ("}".equals(segCode)) {
                groupStack.pop();
                currentGroup = (Group)groupStack.peek();
                continue;
            }
            if ("}]".equals(segCode)) {
                groupStack.pop();
                currentGroup = (Group)groupStack.peek();
                continue;
            }
            if ("<".equals(segCode)) {
                groupStack.push(new Choice(message.getName(), rs.getString("groupname"), this.mNameGen));
                currentGroup.addElement((Element)groupStack.peek());
                currentGroup = (Group)groupStack.peek();
                continue;
            }
            if (">".equals(segCode)) {
                groupStack.pop();
                currentGroup = (Group)groupStack.peek();
                continue;
            }
            Segment seg = new Segment(segCode);
            if (rs.getBoolean("optional")) {
                seg.setOptional(true);
            }
            if (rs.getBoolean("repetitional")) {
                seg.setRepet(true);
            }
            currentGroup.addElement(seg);
        }
        message.normalize();
        return hasRecords;
    }

    private void generateMessagesXSD(Set<String> processedMsgs) throws GeneratorException {
        Emit emit = null;
        Writer writer = null;
        try {
            int i;
            Object[] messageNames = new String[processedMsgs.size()];
            processedMsgs.toArray(messageNames);
            Arrays.sort(messageNames);
            writer = this.getWriter("messages");
            emit = new Emit(writer);
            emit.emit("<?xml version = \"1.0\" encoding=\"UTF-8\"?>");
            emit.down("<!--");
            emit.emit("v2.xml Message Definitions Version v" + this.mHL7Version + "  - messages");
            emit.emit("Copyright (C) Sun Microsystems. All rights reserved.");
            emit.done("-->");
            emit.down("<xsd:schema");
            emit.emit("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            emit.emit("xmlns=\"urn:hl7-org:v2xml\"");
            emit.emit("targetNamespace=\"urn:hl7-org:v2xml\">");
            for (i = 0; i < messageNames.length; ++i) {
                emit.emit("<!-- include message defintions for " + (String)messageNames[i] + " -->");
                emit.emit("<xsd:include schemaLocation=\"" + (String)messageNames[i] + ".xsd\"/>");
            }
            emit.emit("<!-- .. all message definitions -->");
            emit.down("<xsd:group name=\"ALLMESSAGES.CONTENT\">");
            emit.down("<xsd:choice>");
            for (i = 0; i < messageNames.length; ++i) {
                emit.emit("<xsd:element ref=\"" + (String)messageNames[i] + "\" minOccurs=\"0\" maxOccurs=\"unbounded\" />");
            }
            emit.done("</xsd:choice>");
            emit.done("</xsd:group>");
            emit.done("</xsd:schema>");
            emit.close();
            writer = null;
            emit = null;
            this.moveFile(this.getTempTargetFile("messages"), this.getTargetFile("messages"));
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
        finally {
            if (emit != null) {
                try {
                    emit.close();
                }
                catch (IOException e) {
                    throw new GeneratorException(e);
                }
            }
            this.getTempTargetFile("messages").delete();
        }
    }

    private void generateBatchXSD() throws GeneratorException {
        Emit emit = null;
        Writer writer = null;
        try {
            writer = this.getWriter("batch");
            emit = new Emit(writer);
            emit.emit("<?xml version = \"1.0\" encoding=\"UTF-8\"?>");
            emit.down("<!--");
            emit.emit("v2.xml Message Definitions Version v" + this.mHL7Version + "  - messages");
            emit.emit("Copyright (C) Sun Microsystems. All rights reserved.");
            emit.done("-->");
            emit.down("<xsd:schema");
            emit.emit("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            emit.emit("xmlns=\"urn:hl7-org:v2xml\"");
            emit.emit("targetNamespace=\"urn:hl7-org:v2xml\">");
            emit.emit();
            emit.emit("<!-- include segment definitions for version v" + this.mHL7Version + " -->");
            emit.emit("<xsd:include schemaLocation=\"segments.xsd\"/>");
            emit.emit();
            emit.emit("<!-- .. definitions used in batch message -->");
            emit.down("<xsd:element name=\"MESSAGEBATCH\">");
            emit.down("<xsd:complexType>");
            emit.down("<xsd:sequence>");
            emit.emit("<xsd:element ref=\"BHS\" minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.emit("<xsd:element ref=\"QRD\" minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.emit("<xsd:element ref=\"QRF\"  minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.emit("<xsd:element ref=\"MESSAGES\" minOccurs=\"0\" maxOccurs=\"unbounded\" />");
            emit.emit("<xsd:element ref=\"BTS\" minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.done("</xsd:sequence>");
            emit.done("</xsd:complexType>");
            emit.done("</xsd:element>");
            emit.emit("<xsd:element name=\"MESSAGES\" type=\"xsd:string\"/>");
            emit.emit("<!-- .. batch message definition -->");
            emit.emit("<xsd:element name=\"BATCH\" type=\"BATCH.CONTENT\"/>");
            emit.down("<xsd:complexType name=\"BATCH.CONTENT\">");
            emit.down("<xsd:sequence>");
            emit.emit("<xsd:element ref=\"FHS\" minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.emit("<xsd:element ref=\"MESSAGEBATCH\" minOccurs=\"1\" maxOccurs=\"unbounded\" />");
            emit.emit("<xsd:element ref=\"FTS\" minOccurs=\"0\" maxOccurs=\"1\" />");
            emit.done("</xsd:sequence>");
            emit.done("</xsd:complexType>");
            emit.done("</xsd:schema>");
            emit.close();
            writer = null;
            emit = null;
            this.moveFile(this.getTempTargetFile("batch"), this.getTargetFile("batch"));
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
        finally {
            if (emit != null) {
                try {
                    emit.close();
                }
                catch (IOException e) {
                    throw new GeneratorException(e);
                }
            }
            this.getTempTargetFile("batch").delete();
        }
    }

    private Writer getWriter(String seed) throws FileNotFoundException, IOException {
        return UnicodeFile.makeOutputWriter((File)this.getTempTargetFile(seed));
    }

    private File getTempTargetFile(String seed) {
        return new File(this.mTargetLocation, seed + ".xsd.~temp");
    }

    private File getTargetFile(String seed) {
        return new File(this.mTargetLocation, seed + ".xsd");
    }

    private static class Message
    extends Sequence {
        private final String mName;

        public Message(String name, NameGenerator nameGen) {
            super(name, name, nameGen);
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isMessage() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Choice
    extends Group {
        private final NameGenerator mNameGen;
        private String mName = null;

        public Choice(String msgName, String groupName, NameGenerator nameGen) {
            super(3, msgName, groupName);
            this.mNameGen = nameGen;
        }

        @Override
        public String getName() {
            if (this.mName != null) {
                return this.mName;
            }
            return super.getName();
        }

        @Override
        public String toXSD(StringBuffer groupDefinition, StringBuffer contentDefinition, Map<String, Group> groupNames) {
            StringWriter writer = new StringWriter();
            Emit emit = new Emit((Writer)writer, 0, 4);
            emit.indent();
            String name = this.crackOutName(groupNames);
            if (!name.equals(this.getName())) {
                this.mName = name;
            }
            String ctName = this.getName() + ".CONTENT";
            emit.down("<xsd:complexType name=\"" + ctName + "\">");
            if (!this.mNameGen.nameExists(ctName)) {
                this.mNameGen.markUsed(ctName);
            } else {
                emit.down("<xsd:annotation>");
                BaseGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(ctName));
                emit.done("</xsd:annotation>");
            }
            emit.down("<xsd:choice>");
            Iterator<Element> iter = this.getElements().iterator();
            StringBuffer sb1 = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            while (iter.hasNext()) {
                emit.emit(iter.next().toXSD(sb1, sb2, groupNames));
                sb1.append(sb2.toString());
                sb2.setLength(0);
            }
            emit.done("</xsd:choice>");
            emit.done("</xsd:complexType>");
            if (!this.mNameGen.nameExists(this.getName())) {
                emit.emit("<xsd:element name=\"" + this.getName() + "\" type=\"" + this.getName() + ".CONTENT\"/>");
                this.mNameGen.markUsed(this.getName());
            } else {
                emit.down("<xsd:element name=\"" + this.getName() + "\" type=\"" + this.getName() + ".CONTENT\">");
                emit.down("<xsd:annotation>");
                BaseGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(this.getName()));
                emit.done("</xsd:annotation>");
                emit.done("</xsd:element>");
            }
            contentDefinition.append(writer.toString());
            groupDefinition.append(sb1.toString());
            sb1.setLength(0);
            sb1.append("<xsd:element ref=\"" + this.getName() + "\"");
            if (this.isOptional()) {
                sb1.append(" minOccurs=\"0\"");
            } else {
                sb1.append(" minOccurs=\"1\"");
            }
            if (this.isRepet()) {
                sb1.append(" maxOccurs=\"unbounded\"");
            } else {
                sb1.append(" maxOccurs=\"1\"");
            }
            sb1.append("/>");
            return sb1.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Sequence
    extends Group {
        private final NameGenerator mNameGen;
        private String mName = null;

        public Sequence(String msgName, String groupName, NameGenerator nameGen) {
            super(2, msgName, groupName);
            this.mNameGen = nameGen;
        }

        @Override
        public String getName() {
            if (this.mName != null) {
                return this.mName;
            }
            return super.getName();
        }

        public boolean isMessage() {
            return false;
        }

        @Override
        public String toXSD(StringBuffer groupDefinition, StringBuffer contentDefinition, Map<String, Group> groupNames) {
            StringWriter writer = new StringWriter();
            Emit emit = new Emit((Writer)writer, 0, 4);
            emit.indent();
            String name = this.crackOutName(groupNames);
            if (!name.equals(this.getName())) {
                this.mName = name;
            }
            String ctName = this.getName() + ".CONTENT";
            emit.down("<xsd:complexType name=\"" + ctName + "\">");
            if (!this.mNameGen.nameExists(ctName)) {
                this.mNameGen.markUsed(ctName);
            } else {
                emit.down("<xsd:annotation>");
                BaseGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(ctName));
                emit.done("</xsd:annotation>");
            }
            emit.down("<xsd:sequence>");
            Iterator<Element> iter = this.getElements().iterator();
            StringBuffer sb1 = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            while (iter.hasNext()) {
                emit.emit(iter.next().toXSD(sb1, sb2, groupNames));
                sb1.append(sb2.toString());
                sb2.setLength(0);
            }
            emit.done("</xsd:sequence>");
            emit.done("</xsd:complexType>");
            if (this.isMessage()) {
                emit.down("<xsd:element name=\"" + this.getName() + "\" type=\"" + this.getName() + ".CONTENT\">");
                emit.down("<xsd:annotation>");
                emit.down("<xsd:appinfo source=\"urn:com.sun:encoder\">");
                emit.emit("<top xmlns=\"urn:com.sun:encoder\">true</top>");
                emit.done("</xsd:appinfo>");
                if (!this.mNameGen.nameExists(this.getName())) {
                    this.mNameGen.markUsed(this.getName());
                } else {
                    BaseGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(this.getName()));
                }
                emit.done("</xsd:annotation>");
                emit.done("</xsd:element>");
            } else if (!this.mNameGen.nameExists(this.getName())) {
                emit.down("<xsd:element name=\"" + this.getName() + "\" type=\"" + this.getName() + ".CONTENT\"/>");
                this.mNameGen.markUsed(this.getName());
            } else {
                emit.down("<xsd:element name=\"" + this.getName() + "\" type=\"" + this.getName() + ".CONTENT\">");
                emit.down("<xsd:annotation>");
                BaseGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(this.getName()));
                emit.done("</xsd:annotation>");
                emit.done("</xsd:element>");
            }
            contentDefinition.append(writer.toString());
            groupDefinition.append(sb1.toString());
            sb1.setLength(0);
            sb1.append("<xsd:element ref=\"" + this.getName() + "\"");
            if (this.isOptional()) {
                sb1.append(" minOccurs=\"0\"");
            } else {
                sb1.append(" minOccurs=\"1\"");
            }
            if (this.isRepet()) {
                sb1.append(" maxOccurs=\"unbounded\"");
            } else {
                sb1.append(" maxOccurs=\"1\"");
            }
            sb1.append("/>");
            return sb1.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Group
    extends Element {
        private final List<Element> mElements = new ArrayList<Element>();
        private final String mMsgName;
        private String mGroupName;

        public Group(int kind, String msgName, String groupName) {
            super(kind);
            this.mMsgName = msgName;
            if (groupName != null && (groupName = groupName.trim()).length() == 0) {
                groupName = null;
            }
            this.mGroupName = groupName;
        }

        @Override
        public String getName() {
            if (this.mGroupName == null) {
                return this.mMsgName + "." + this.getConcatName() + "_SUPPGRP";
            }
            return this.mMsgName + "." + this.mGroupName;
        }

        public String getConcatName() {
            Iterator<Element> iter = this.mElements.iterator();
            StringBuffer sb = new StringBuffer();
            while (iter.hasNext()) {
                Element elem = iter.next();
                if (elem.getType() == 1) {
                    sb.append(elem.getName());
                    continue;
                }
                sb.append(((Group)elem).getConcatName());
            }
            return sb.toString();
        }

        public boolean isAnonymous() {
            return this.mGroupName == null;
        }

        void addElement(Element elem) {
            this.mElements.add(elem);
        }

        protected List<Element> getElements() {
            return this.mElements;
        }

        public void normalize() {
            Element elem;
            int i;
            for (i = 0; i < this.mElements.size(); ++i) {
                elem = this.mElements.get(i);
                boolean needNormalize = true;
                while (elem.isGroup() && needNormalize) {
                    needNormalize = false;
                    Group group = (Group)elem;
                    if (group.mElements.size() == 0) {
                        this.mElements.set(i, null);
                        continue;
                    }
                    if (group.mElements.size() != 1 || !group.mElements.get(0).isGroup() || !((Group)group.mElements.get(0)).isAnonymous() && !group.isAnonymous()) continue;
                    elem = group.mElements.get(0);
                    if (((Group)elem).isAnonymous() && !group.isAnonymous()) {
                        ((Group)elem).mGroupName = group.mGroupName;
                    }
                    if (group.isOptional()) {
                        elem.setOptional(true);
                    }
                    if (group.isRepet()) {
                        elem.setRepet(true);
                    }
                    group.mElements.remove(0);
                    this.mElements.set(i, elem);
                    needNormalize = true;
                }
            }
            i = 0;
            while (i < this.mElements.size()) {
                elem = this.mElements.get(i);
                if (elem == null) {
                    this.mElements.remove(i);
                    continue;
                }
                if (elem.isGroup()) {
                    ((Group)elem).normalize();
                }
                ++i;
            }
        }

        protected String crackOutName(Map<String, Group> nameUsed) {
            String name = this.getName();
            int i = 2;
            while (nameUsed.containsKey(name) && nameUsed.get(name) != this) {
                name = this.mMsgName + "." + this.getConcatName() + "_SUPPGRP" + i;
                ++i;
            }
            nameUsed.put(name, this);
            return name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Segment
    extends Element {
        private final String mName;

        public Segment(String name) {
            super(1);
            this.mName = "Zxx".equals(name) ? "anyZSegment" : ("Hxx".equals(name) ? "anyHL7Segment" : name);
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public String toXSD(StringBuffer groupDefinition, StringBuffer contentDefinition, Map<String, Group> groupNames) {
            StringBuffer sb = new StringBuffer();
            sb.append("<xsd:element ref=\"" + this.getName() + "\"");
            if (this.isOptional()) {
                sb.append(" minOccurs=\"0\"");
            } else {
                sb.append(" minOccurs=\"1\"");
            }
            if (this.isRepet()) {
                sb.append(" maxOccurs=\"unbounded\"");
            } else {
                sb.append(" maxOccurs=\"1\"");
            }
            sb.append("/>");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Element {
        public static final int SEGMENT = 1;
        public static final int SEQUENCE = 2;
        public static final int CHOICE = 3;
        private final int mKind;
        private boolean mIsOptional = false;
        private boolean mIsRepet = false;

        public Element(int kind) {
            this.mKind = kind;
        }

        public int getType() {
            return this.mKind;
        }

        public abstract String getName();

        public boolean isOptional() {
            return this.mIsOptional;
        }

        public boolean isRepet() {
            return this.mIsRepet;
        }

        public void setOptional(boolean optional) {
            this.mIsOptional = optional;
        }

        public void setRepet(boolean repet) {
            this.mIsRepet = repet;
        }

        public boolean isGroup() {
            return this.mKind != 1;
        }

        public abstract String toXSD(StringBuffer var1, StringBuffer var2, Map<String, Group> var3);
    }
}

