/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.runtime.provider;

public final class HL7CharEscapeCoder {
    private static final int PROCESS_UNKNOWN = 0;
    private static final int PROCESS_ESCAPE = 1;
    private static final int PROCESS_UNESCAPE = 2;
    private static final int ESCAPE_NONE = 0;
    private static final int ESCAPE_UNDET = 1;
    private static final int ESCAPE_FLDSEP = 2;
    private static final int ESCAPE_CMPSEP = 3;
    private static final int ESCAPE_SUBSEP = 4;
    private static final int ESCAPE_REPSEP = 5;
    private static final int ESCAPE_ESPCHR = 6;
    private static final int ESCAPE_HEX = 7;
    private static final int ESCAPE_OTHER = 8;
    private final char mFieldSep;
    private final char mCompoSep;
    private final char mSubCompoSep;
    private final char mRepetSep;
    private final char mEscapeChar;
    private final Result mResult = new Result();
    private int mState = 0;
    private char[][] mEscapeSeqs;
    private char[] mDataBuf;
    private char[] mData;
    private char[] mResData;
    private int mStart;
    private int mCount;
    private int mEnd;
    private int mPos;
    private int mResPos;
    private int mLastResPos;
    private boolean mIsEnd;
    private int mLeftOver = 0;
    private boolean mEscapeOpen = false;
    private int mEscapeState = 0;
    private boolean mHasNext = false;
    private boolean mPendingScan;

    public HL7CharEscapeCoder(char fieldSep, char compoSep, char subCompoSep, char repetSep, char escapeChar) {
        this.mFieldSep = fieldSep;
        this.mCompoSep = compoSep;
        this.mSubCompoSep = subCompoSep;
        this.mRepetSep = repetSep;
        this.mEscapeChar = escapeChar;
    }

    public void escape(char[] srcchars, int srcoffset, int count) {
        int i;
        this.reset();
        this.mState = 1;
        if (count == 0) {
            return;
        }
        this.ensureEscapeSequence();
        int end = srcoffset + count;
        int pos = srcoffset;
        this.mResPos = 0;
        for (i = srcoffset; i < end; ++i) {
            if (this.mEscapeSeqs[srcchars[i] & 0xFF] == null) continue;
            char[] seq = this.mEscapeSeqs[srcchars[i] & 0xFF];
            this.ensureResultCapacity(i - pos + this.mResPos + seq.length);
            if (i > pos) {
                System.arraycopy(srcchars, pos, this.mResData, this.mResPos, i - pos);
                this.mResPos += i - pos;
            }
            System.arraycopy(seq, 0, this.mResData, this.mResPos, seq.length);
            this.mResPos += seq.length;
            pos = i + 1;
            this.mHasNext = true;
        }
        if (this.mHasNext) {
            if (i > pos) {
                this.ensureResultCapacity(i - pos + this.mResPos);
                System.arraycopy(srcchars, pos, this.mResData, this.mResPos, i - pos);
                this.mResPos += i - pos;
                pos = i;
            }
            this.mResult.mType = 1;
            this.mResult.mData = this.mResData;
            this.mResult.mStart = 0;
            this.mResult.mCount = this.mResPos;
        }
    }

    public void unescape(char[] srcchars, int srcoffset, int count, boolean end) {
        if (this.mState != 2) {
            this.reset();
        }
        this.mState = 2;
        if (this.mLeftOver > 0) {
            this.ensureSourceCapacity(this.mLeftOver + count);
            System.arraycopy(srcchars, srcoffset, this.mDataBuf, this.mLeftOver, count);
            this.mData = this.mDataBuf;
            this.mStart = 0;
            this.mCount = count + this.mLeftOver;
        } else {
            this.mData = srcchars;
            this.mStart = srcoffset;
            this.mCount = count;
        }
        this.mPos = this.mStart;
        this.mEnd = this.mStart + this.mCount;
        this.ensureResultCapacity(this.mCount);
        this.mResPos = 0;
        this.mLastResPos = 0;
        this.mIsEnd = end;
        this.mPendingScan = true;
    }

    public boolean hasResult() {
        if (this.mState == 2) {
            if (this.mPendingScan) {
                this.scan();
                this.mPendingScan = false;
            }
            return this.mHasNext;
        }
        if (this.mState == 1) {
            return this.mHasNext;
        }
        return false;
    }

    public Result getResult() {
        if (this.mState == 2) {
            if (this.mPendingScan) {
                this.scan();
                this.mPendingScan = false;
            }
            if (!this.mHasNext) {
                return null;
            }
            this.mPendingScan = true;
            return this.mResult;
        }
        if (this.mState == 1) {
            return this.mResult;
        }
        return null;
    }

    public void reset() {
        this.mResult.clear();
        this.mState = 0;
        this.mData = null;
        this.mStart = -1;
        this.mCount = 0;
        this.mEnd = -1;
        this.mPos = -1;
        this.mResPos = -1;
        this.mLastResPos = -1;
        this.mIsEnd = true;
        this.mLeftOver = 0;
        this.mEscapeOpen = false;
        this.mEscapeState = 0;
        this.mHasNext = false;
        this.mPendingScan = false;
    }

    private void scan() {
        int i;
        this.mHasNext = false;
        this.mResult.clear();
        int end = this.mEnd;
        if (this.mLeftOver > 0) {
            i = this.mLeftOver;
            this.mLeftOver = 0;
        } else {
            i = this.mPos;
        }
        this.mLastResPos = this.mResPos;
        block16: while (i < end) {
            if (this.mEscapeState == 1) {
                if (this.mData[i] == this.mEscapeChar) {
                    this.mEscapeState = 0;
                    ++i;
                    continue;
                }
                boolean copiedData = false;
                if (i - 1 > this.mPos) {
                    System.arraycopy(this.mData, this.mPos, this.mResData, this.mResPos, i - 1 - this.mPos);
                    this.mResPos += i - 1 - this.mPos;
                    this.mPos = i - 1;
                    copiedData = true;
                }
                switch (this.mData[i]) {
                    case 'F': {
                        this.mEscapeState = 2;
                        break;
                    }
                    case 'S': {
                        this.mEscapeState = 3;
                        break;
                    }
                    case 'T': {
                        this.mEscapeState = 4;
                        break;
                    }
                    case 'R': {
                        this.mEscapeState = 5;
                        break;
                    }
                    case 'E': {
                        this.mEscapeState = 6;
                        break;
                    }
                    case 'X': {
                        this.mEscapeState = 7;
                        break;
                    }
                    default: {
                        if (copiedData) {
                            --i;
                            this.mEscapeState = 0;
                            break block16;
                        }
                        this.mEscapeState = 8;
                        break;
                    }
                }
            } else if (this.mData[i] == this.mEscapeChar) {
                if (this.mEscapeState == 0) {
                    this.mEscapeState = 1;
                    this.mEscapeOpen = true;
                } else {
                    this.mEscapeOpen = false;
                    switch (this.mEscapeState) {
                        case 2: {
                            this.mResData[this.mResPos] = this.mFieldSep;
                            ++this.mResPos;
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        case 3: {
                            this.mResData[this.mResPos] = this.mCompoSep;
                            ++this.mResPos;
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        case 4: {
                            this.mResData[this.mResPos] = this.mSubCompoSep;
                            ++this.mResPos;
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        case 5: {
                            this.mResData[this.mResPos] = this.mRepetSep;
                            ++this.mResPos;
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        case 6: {
                            this.mResData[this.mResPos] = this.mEscapeChar;
                            ++this.mResPos;
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        case 7: {
                            if (i > this.mPos + 2) {
                                String hexVal = new String(this.mData, this.mPos + 2, i - this.mPos - 2);
                                char[] chars = Character.toChars(Integer.parseInt(hexVal, 16));
                                if (chars.length == 1) {
                                    this.mResData[this.mResPos++] = chars[0];
                                } else {
                                    System.arraycopy(chars, 0, this.mResData, this.mResPos, chars.length);
                                    this.mResPos += chars.length;
                                }
                            }
                            this.mEscapeState = 0;
                            this.mPos = i + 1;
                            break;
                        }
                        default: {
                            ++i;
                            break block16;
                        }
                    }
                }
            }
            ++i;
        }
        if (this.mEscapeState != 0 && this.mEscapeOpen && this.mIsEnd) {
            this.mEscapeState = 0;
            this.mEscapeOpen = false;
        }
        if (this.mEscapeState == 0) {
            if (this.mPos < i) {
                System.arraycopy(this.mData, this.mPos, this.mResData, this.mResPos, i - this.mPos);
                this.mResPos += i - this.mPos;
                this.mPos = i;
            }
            if (this.mHasNext = this.mResPos > this.mLastResPos) {
                this.mResult.mStart = this.mLastResPos;
                this.mResult.mData = this.mResData;
                this.mResult.mCount = this.mResPos - this.mLastResPos;
                this.mResult.mType = 1;
            }
        } else if (this.mEscapeOpen) {
            this.ensureSourceCapacity(i - this.mPos);
            System.arraycopy(this.mData, this.mPos, this.mDataBuf, 0, i - this.mPos);
            this.mLeftOver = i - this.mPos;
            this.mPos = 0;
        } else {
            this.mHasNext = i > this.mPos + 1;
            if (this.mHasNext) {
                this.mResult.mStart = this.mPos + 1;
                this.mResult.mData = this.mData;
                this.mResult.mCount = i - this.mPos - 2;
                this.mResult.mType = 2;
            }
            this.mPos = i;
            this.mEscapeState = 0;
        }
    }

    private void ensureSourceCapacity(int capacity) {
        if (this.mDataBuf == null) {
            this.mDataBuf = new char[capacity];
            return;
        }
        if (this.mDataBuf.length >= capacity) {
            return;
        }
        char[] buf = new char[capacity];
        System.arraycopy(this.mDataBuf, 0, buf, 0, this.mDataBuf.length);
        this.mDataBuf = buf;
    }

    private void ensureResultCapacity(int capacity) {
        if (this.mResData == null) {
            this.mResData = new char[capacity];
            return;
        }
        if (this.mResData.length >= capacity) {
            return;
        }
        char[] buf = new char[capacity];
        System.arraycopy(this.mResData, 0, buf, 0, this.mResData.length);
        this.mResData = buf;
    }

    private void ensureEscapeSequence() {
        if (this.mEscapeSeqs == null) {
            this.mEscapeSeqs = new char[256][];
            this.mEscapeSeqs[this.mFieldSep & 0xFF] = new char[]{'\\', 'F', '\\'};
            this.mEscapeSeqs[this.mCompoSep & 0xFF] = new char[]{'\\', 'S', '\\'};
            this.mEscapeSeqs[this.mSubCompoSep & 0xFF] = new char[]{'\\', 'T', '\\'};
            this.mEscapeSeqs[this.mRepetSep & 0xFF] = new char[]{'\\', 'R', '\\'};
            this.mEscapeSeqs[this.mEscapeChar & 0xFF] = new char[]{'\\', 'E', '\\'};
        }
    }

    public static final class Result {
        public static final int NONE = 0;
        public static final int CHARDATA = 1;
        public static final int ESCAPE = 2;
        public int mType;
        public char[] mData;
        public int mStart;
        public int mCount;

        void clear() {
            this.mType = 0;
            this.mData = null;
            this.mStart = -1;
            this.mCount = 0;
        }
    }
}

