/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.assignment.SizeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class DataSizeAction
extends SizeAction {
    protected String m_dataField;
    protected double m_baseSize = 1.0;
    protected double m_sizeRange;
    protected int m_scale = 0;
    protected int m_bins = -1;
    protected boolean m_inferBounds = true;
    protected boolean m_is2DArea = true;
    protected double[] m_dist;
    protected int m_tempScale;

    public DataSizeAction(String group, String field) {
        super(group);
        this.m_dataField = field;
    }

    public DataSizeAction(String group, String field, int bins) {
        this(group, field, bins, 0);
    }

    public DataSizeAction(String group, String field, int bins, int scale) {
        super(group);
        this.m_dataField = field;
        this.setScale(scale);
        this.setBinCount(bins);
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String field) {
        this.m_dataField = field;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        if (scale < 0 || scale >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + scale);
        }
        this.m_scale = scale;
    }

    public int getBinCount() {
        return this.m_bins;
    }

    public void setBinCount(int count) {
        if (this.m_scale == 3 && count <= 0) {
            throw new IllegalArgumentException("The quantile scale can not be used without binning. Use a bin value greater than zero.");
        }
        this.m_bins = count;
    }

    public boolean is2DArea() {
        return this.m_is2DArea;
    }

    public void setIs2DArea(boolean isArea) {
        this.m_is2DArea = isArea;
    }

    public double getBaseSize() {
        return this.m_baseSize;
    }

    public void setBaseSize(double size) {
        this.m_baseSize = size;
    }

    protected void setup() {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        this.m_tempScale = this.m_scale;
        if (this.m_inferBounds) {
            if (this.m_scale == 3 && this.m_bins > 0) {
                double[] values = DataLib.toDoubleArray(ts.tuples(), this.m_dataField);
                this.m_dist = MathLib.quantiles(this.m_bins, values);
            } else {
                if (this.m_scale == 3) {
                    Logger.getLogger(this.getClass().getName()).warning("Can't use quantile scale with no binning. Defaulting to linear scale. Set the bin value greater than zero to use a quantile scale.");
                    this.m_scale = 0;
                }
                this.m_dist = new double[2];
                this.m_dist[0] = DataLib.min(ts, this.m_dataField).getDouble(this.m_dataField);
                this.m_dist[1] = DataLib.max(ts, this.m_dataField).getDouble(this.m_dataField);
            }
            this.m_sizeRange = this.m_dist[this.m_dist.length - 1] / this.m_dist[0] - this.m_baseSize;
        }
    }

    protected void finish() {
        this.m_scale = this.m_tempScale;
    }

    public double getSize(VisualItem item) {
        double v = item.getDouble(this.m_dataField);
        double f = MathLib.interp(this.m_scale, v, this.m_dist);
        if (this.m_bins < 1) {
            v = this.m_baseSize + f * this.m_sizeRange;
        } else {
            int bin = (int)((f - 1.0E-4) * (double)this.m_bins);
            v = this.m_baseSize + (double)bin * (this.m_sizeRange / (double)(this.m_bins - 1));
        }
        return this.m_is2DArea ? PrefuseLib.getSize2D(v) : v;
    }
}

