/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;

public class MemberNameCheck
extends AbstractNameCheck {
    private boolean mApplyToPublic = true;
    private boolean mApplyToProtected = true;
    private boolean mApplyToPackage = true;
    private boolean mApplyToPrivate = true;

    public MemberNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    protected final boolean mustCheckName(DetailAST aAST) {
        DetailAST modifiersAST = aAST.findFirstToken(5);
        boolean isStatic = modifiersAST != null && modifiersAST.branchContains(64);
        return !isStatic && !ScopeUtils.inInterfaceOrAnnotationBlock(aAST) && !ScopeUtils.isLocalVariableDef(aAST) && modifiersAST != null && this.shouldCheckInScope(modifiersAST);
    }

    private boolean shouldCheckInScope(DetailAST aModifiers) {
        if (aModifiers == null) {
            return this.mApplyToPackage;
        }
        boolean isPublic = aModifiers.branchContains(62);
        boolean isProtected = aModifiers.branchContains(63);
        boolean isPrivate = aModifiers.branchContains(61);
        boolean isPackage = !isPublic && !isProtected && !isPrivate;
        return this.mApplyToPublic && isPublic || this.mApplyToProtected && isProtected || this.mApplyToPackage && isPackage || this.mApplyToPrivate && isPrivate;
    }

    public void setApplyToPublic(boolean aApplyTo) {
        this.mApplyToPublic = aApplyTo;
    }

    public boolean getApplyToPublic() {
        return this.mApplyToPublic;
    }

    public void setApplyToProtected(boolean aApplyTo) {
        this.mApplyToProtected = aApplyTo;
    }

    public boolean getApplyToProtected() {
        return this.mApplyToProtected;
    }

    public void setApplyToPackage(boolean aApplyTo) {
        this.mApplyToPackage = aApplyTo;
    }

    public boolean getApplyToPackage() {
        return this.mApplyToPackage;
    }

    public void setApplyToPrivate(boolean aApplyTo) {
        this.mApplyToPrivate = aApplyTo;
    }

    public boolean getApplyToPrivate() {
        return this.mApplyToPrivate;
    }
}

