/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharScanner;
import antlr.RecognitionException;
import antlr.collections.impl.BitSet;

public class MismatchedCharException
extends RecognitionException {
    public static final int CHAR = 1;
    public static final int NOT_CHAR = 2;
    public static final int RANGE = 3;
    public static final int NOT_RANGE = 4;
    public static final int SET = 5;
    public static final int NOT_SET = 6;
    public int mismatchType;
    public int foundChar;
    public int expecting;
    public int upper;
    public BitSet set;
    public CharScanner scanner;

    public MismatchedCharException() {
        super("Mismatched char");
    }

    public MismatchedCharException(char c, char lower, char upper_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 4 : 3;
        this.foundChar = c;
        this.expecting = lower;
        this.upper = upper_;
        this.scanner = scanner_;
    }

    public MismatchedCharException(char c, char expecting_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 2 : 1;
        this.foundChar = c;
        this.expecting = expecting_;
        this.scanner = scanner_;
    }

    public MismatchedCharException(char c, BitSet set_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 6 : 5;
        this.foundChar = c;
        this.set = set_;
        this.scanner = scanner_;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        switch (this.mismatchType) {
            case 1: {
                sb.append("expecting ");
                this.appendCharName(sb, this.expecting);
                sb.append(", found ");
                this.appendCharName(sb, this.foundChar);
                break;
            }
            case 2: {
                sb.append("expecting anything but '");
                this.appendCharName(sb, this.expecting);
                sb.append("'; got it anyway");
                break;
            }
            case 3: 
            case 4: {
                sb.append("expecting token ");
                if (this.mismatchType == 4) {
                    sb.append("NOT ");
                }
                sb.append("in range: ");
                this.appendCharName(sb, this.expecting);
                sb.append("..");
                this.appendCharName(sb, this.upper);
                sb.append(", found ");
                this.appendCharName(sb, this.foundChar);
                break;
            }
            case 5: 
            case 6: {
                sb.append("expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (");
                int[] elems = this.set.toArray();
                for (int i = 0; i < elems.length; ++i) {
                    this.appendCharName(sb, elems[i]);
                }
                sb.append("), found ");
                this.appendCharName(sb, this.foundChar);
                break;
            }
            default: {
                sb.append(super.getMessage());
            }
        }
        return sb.toString();
    }

    private void appendCharName(StringBuffer sb, int c) {
        switch (c) {
            case 65535: {
                sb.append("'<EOF>'");
                break;
            }
            case 10: {
                sb.append("'\\n'");
                break;
            }
            case 13: {
                sb.append("'\\r'");
                break;
            }
            case 9: {
                sb.append("'\\t'");
                break;
            }
            default: {
                sb.append('\'');
                sb.append((char)c);
                sb.append('\'');
            }
        }
    }
}

