/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.wsdl;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaAddress;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaBinding;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaExtension;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;

public class Jbi4CorbaExtensionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaExtensionUtils.class);

    public static void removeCorbaElements(Definition def) throws WSDLException {
        LOG.debug("removeCorbaElements - Definition=" + def);
        Port port = null;
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        Jbi4CorbaExtension.register(registry);
        String jbi4CorbaNamespace = null;
        for (Object namespaceKey : def.getNamespaces().keySet()) {
            LOG.debug("namespaceKey=" + namespaceKey);
            String value = (String)def.getNamespaces().get(namespaceKey);
            LOG.debug("NameSpace[" + namespaceKey + "]=" + value);
            if (!value.equalsIgnoreCase("uri://schemas.imola.it/jbi/wsdl-extensions/corba/")) continue;
            jbi4CorbaNamespace = (String)namespaceKey;
            LOG.debug("jbi4CorbaNamespace=" + jbi4CorbaNamespace);
        }
        if (jbi4CorbaNamespace != null) {
            LOG.debug("FOUND jbi4corba namespace.");
            def.getNamespaces().remove(jbi4CorbaNamespace);
        } else {
            LOG.debug("jbi4corba namespace NOT found.");
        }
        LOG.debug("Start removing the Jbi4Corba extensibility elements");
        for (Object serviceAsObject : def.getServices().values()) {
            Service service = (Service)serviceAsObject;
            LOG.debug("Service=" + service + "; Service.QName=" + service.getQName());
            for (Object obj : service.getPorts().values()) {
                port = (Port)obj;
                ArrayList<Jbi4CorbaAddress> toRemoveFromPort = new ArrayList<Jbi4CorbaAddress>();
                LOG.debug("Port=" + port + "; Port.name" + port.getName());
                for (Object element : port.getExtensibilityElements()) {
                    if (element instanceof Jbi4CorbaAddress) {
                        LOG.debug("The element IS a Jbi4CorbaAddress. Element=" + element);
                        Jbi4CorbaAddress jbi4CorbaAddress = (Jbi4CorbaAddress)element;
                        LOG.debug("Found address (It will be removed):" + jbi4CorbaAddress);
                        toRemoveFromPort.add(jbi4CorbaAddress);
                    } else {
                        LOG.debug("The element is NOT a Jbi4CorbaAddress. Element=" + element);
                    }
                    ArrayList<Jbi4CorbaBinding> toRemoveFromBinding = new ArrayList<Jbi4CorbaBinding>();
                    for (Object bindingEstension : port.getBinding().getExtensibilityElements()) {
                        if (bindingEstension instanceof Jbi4CorbaBinding) {
                            LOG.debug("bindingEstension instanceof Jbi4CorbaBinding.bindingEstension=" + bindingEstension);
                            Jbi4CorbaBinding jbi4CorbaBinding = (Jbi4CorbaBinding)bindingEstension;
                            LOG.debug("Found binding (It will be removed):" + jbi4CorbaBinding);
                            toRemoveFromBinding.add(jbi4CorbaBinding);
                            continue;
                        }
                        LOG.debug("bindingEstension instanceof Jbi4CorbaBinding.bindingEstension=" + bindingEstension);
                    }
                    LOG.debug("toRemoveFromBinding.size=" + toRemoveFromBinding.size());
                    port.getBinding().getExtensibilityElements().removeAll(toRemoveFromBinding);
                }
                LOG.debug("toRemoveFromPort.size=" + toRemoveFromPort.size());
                port.getExtensibilityElements().removeAll(toRemoveFromPort);
            }
        }
    }

    public static Binding getBinding(Definition def, String serviceName, String endpointName) {
        Service svc = def.getService(QName.valueOf(serviceName));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for service: " + serviceName + " in wsdl " + Jbi4CorbaExtensionUtils.getWSDLStringFromDefinition(def));
        }
        if (svc == null) {
            LOG.warn("Service not found in the WSDL for the serviceName:" + serviceName);
            return null;
        }
        Port port = svc.getPort(endpointName);
        if (port == null) {
            LOG.warn("Port not found in the WSDL for the endpointName:" + endpointName);
            return null;
        }
        return port.getBinding();
    }

    public static Service getService(Definition def, String serviceName) {
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        return svc;
    }

    public static Jbi4CorbaBinding getCorbaBinding(Definition def, String serviceName, String endpointName) {
        Jbi4CorbaBinding corbaBinding = null;
        Binding binding = Jbi4CorbaExtensionUtils.getBinding(def, serviceName, endpointName);
        if (binding != null) {
            List extElems = binding.getExtensibilityElements();
            Iterator extIter = null;
            if (extElems != null) {
                extIter = extElems.iterator();
            }
            while (extIter != null && extIter.hasNext() && corbaBinding == null) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!Jbi4CorbaBinding.class.isInstance(ee)) continue;
                corbaBinding = (Jbi4CorbaBinding)ee;
            }
        }
        return corbaBinding;
    }

    public static Jbi4CorbaAddress getCorbaAddress(Definition def, String serviceName, String endpointName) {
        Jbi4CorbaAddress address = null;
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port != null) {
            List extElems = port.getExtensibilityElements();
            Iterator extIter = null;
            if (extElems != null) {
                extIter = extElems.iterator();
            }
            while (extIter != null && extIter.hasNext() && address == null) {
                ExtensibilityElement ee = (ExtensibilityElement)extIter.next();
                if (!Jbi4CorbaAddress.class.isInstance(ee)) continue;
                address = (Jbi4CorbaAddress)ee;
            }
        }
        return address;
    }

    public static PortType getPortType(Definition def, String serviceName, String endpointName) {
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        Binding binding = null;
        if (port == null) {
            return null;
        }
        binding = port.getBinding();
        PortType portType = null;
        if (binding != null) {
            portType = binding.getPortType();
        }
        return portType;
    }

    public static WSDLWriter getExtendedWSDLWriter() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLWriter writer = factory.newWSDLWriter();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        Jbi4CorbaExtension.register(registry);
        return writer;
    }

    public static String getWSDLStringFromDefinition(Definition wsdl) {
        StringWriter strWriter = new StringWriter();
        try {
            Jbi4CorbaExtensionUtils.getExtendedWSDLWriter().writeWSDL(wsdl, (Writer)strWriter);
        }
        catch (WSDLException e) {
            LOG.warn(e.getMessage());
        }
        return strWriter.toString();
    }
}

