/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.processor;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.endpoint.ConsumerEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.ExchangeProcessor;
import javax.jbi.messaging.MessageExchange;

public class ConsumerExchangeProcessor
implements ExchangeProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerExchangeProcessor.class);
    ConsumerEndpoint consumerEndpoint;

    public ConsumerExchangeProcessor(ConsumerEndpoint consumerEndpoint) {
        this.consumerEndpoint = consumerEndpoint;
    }

    public void process(MessageExchange messageExchange) {
        LOG.debug("process - MessageExchange=" + messageExchange);
        try {
            if (messageExchange != null) {
                this.consumerEndpoint.getConsumerServiceDescriptor().getConsumerInvocationHandler().process(messageExchange);
            } else {
                LOG.debug("process - No Operations to do.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Error in message exchange:" + ex.getMessage();
            LOG.error(msg);
        }
    }
}

