/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.MouseVisualizer;

public class SheetButtonOperator
extends JComponentOperator {
    private int nameButtonIndex;
    private static int temporaryNameButtonIndex;

    private SheetButtonOperator(Component button) {
        super((JComponent)button);
    }

    public static synchronized SheetButtonOperator nameButton(ContainerOperator contOper, String propertyName) {
        SheetButtonOperator sbo = new SheetButtonOperator(SheetButtonOperator.waitNameButton(contOper, propertyName, 0));
        sbo.nameButtonIndex = temporaryNameButtonIndex;
        return sbo;
    }

    public static SheetButtonOperator nameButton(ContainerOperator contOper, int index) {
        SheetButtonOperator sbo = new SheetButtonOperator(SheetButtonOperator.waitNameButton(contOper, null, index));
        sbo.nameButtonIndex = index;
        return sbo;
    }

    public static SheetButtonOperator valueButton(ContainerOperator contOper, int nameButtonIndex) {
        return new SheetButtonOperator(SheetButtonOperator.waitValueButton(contOper, nameButtonIndex));
    }

    public static SheetButtonOperator customizerButton(ContainerOperator contOper) {
        return new SheetButtonOperator(SheetButtonOperator.waitCustomizerButton(contOper));
    }

    private static Component waitNameButton(ContainerOperator contOper, String name, int index) {
        throw new JemmyException("Don't use this! SheetButton no more used in property sheet.");
    }

    private static Component waitCustomizerButton(ContainerOperator contOper) {
        throw new JemmyException("Don't use this! SheetButton no more used in property sheet.");
    }

    private static Component waitValueButton(ContainerOperator contOper, int nameButtonIndex) {
        throw new JemmyException("Don't use this! SheetButton no more used in property sheet.");
    }

    static Component waitPropertyPanel(ContainerOperator contOper, int nameButtonIndex) {
        throw new JemmyException("Don't use this! SheetButton no more used in property sheet.");
    }

    private static String getButtonLabel(Component sheetButton) {
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.propertysheet.SheetButton");
            Method getLabelMethod = clazz.getDeclaredMethod("getLabel", null);
            getLabelMethod.setAccessible(true);
            return getLabelMethod.invoke((Object)sheetButton, null).toString();
        }
        catch (Exception e) {
            throw new JemmyException("SheetButton.getLabel() by reflection failed.", (Throwable)e);
        }
    }

    public String getLabel() {
        return SheetButtonOperator.getButtonLabel(this.getSource());
    }

    public int getNameButtonIndex() {
        return this.nameButtonIndex;
    }

    public void push() {
        MouseVisualizer mv = new MouseVisualizer(MouseVisualizer.TOP, 0.5, 10, false);
        mv.scroll(true);
        mv.makeVisible((ComponentOperator)this);
        this.clickMouse();
    }

    public void pushNoBlock() {
        try {
            new ActionProducer(new Action(){

                public Object launch(Object obj) {
                    SheetButtonOperator.this.push();
                    return null;
                }

                public String getDescription() {
                    return "Push \"" + SheetButtonOperator.this.getLabel() + "\" button - don't wait";
                }
            }, false).produceAction(null);
        }
        catch (Exception e) {
            throw new JemmyException("Push \"" + this.getLabel() + "\" button action failed.", (Throwable)e);
        }
    }

    public void clickForPopup() {
        MouseVisualizer mv = new MouseVisualizer(MouseVisualizer.TOP, 0.5, 10, false);
        mv.scroll(true);
        mv.makeVisible((ComponentOperator)this);
        super.clickForPopup();
    }

    static class SheetButtonChooser
    implements ComponentChooser {
        private String propertyName;
        private int index = -1;
        private Operator.StringComparator comparator;

        public SheetButtonChooser(String propertyName, Operator.StringComparator comparator) {
            this.propertyName = propertyName;
            this.comparator = comparator;
        }

        public boolean checkComponent(Component comp) {
            if (comp.getClass().getName().indexOf("LazyToolTipSheetButton") != -1) {
                ++this.index;
                return this.comparator.equals(SheetButtonOperator.getButtonLabel(comp), this.propertyName);
            }
            return false;
        }

        public String getDescription() {
            return "\"" + (this.propertyName == null ? "index-th" : this.propertyName) + "\" SheetButton";
        }

        public int getIndex() {
            return this.index;
        }
    }
}

