/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation.value;

import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.DoubleValueFactory;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.FloatValueFactory;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.IntegerValueFactory;
import proguard.optimize.evaluation.value.LongValue;
import proguard.optimize.evaluation.value.LongValueFactory;
import proguard.optimize.evaluation.value.SpecificLongValue;

class SpecificIntegerValue
extends IntegerValue {
    private int value;

    public SpecificIntegerValue(int n) {
        this.value = n;
    }

    public int value() {
        return this.value;
    }

    public IntegerValue generalize(IntegerValue integerValue) {
        return integerValue.generalize(this);
    }

    public IntegerValue add(IntegerValue integerValue) {
        return integerValue.add(this);
    }

    public IntegerValue subtract(IntegerValue integerValue) {
        return integerValue.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue integerValue) {
        return integerValue.subtract(this);
    }

    public IntegerValue multiply(IntegerValue integerValue) {
        return integerValue.multiply(this);
    }

    public IntegerValue divide(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divide(this);
    }

    public IntegerValue remainder(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue integerValue) {
        return integerValue.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue integerValue) {
        return integerValue.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue integerValue) {
        return integerValue.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue longValue) {
        return longValue.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue longValue) {
        return longValue.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue longValue) {
        return longValue.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue integerValue) {
        return integerValue.and(this);
    }

    public IntegerValue or(IntegerValue integerValue) {
        return integerValue.or(this);
    }

    public IntegerValue xor(IntegerValue integerValue) {
        return integerValue.xor(this);
    }

    public int equal(IntegerValue integerValue) {
        return integerValue.equal(this);
    }

    public int lessThan(IntegerValue integerValue) {
        return integerValue.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue integerValue) {
        return integerValue.greaterThanOrEqual(this);
    }

    public IntegerValue negate() {
        return IntegerValueFactory.create(-this.value);
    }

    public IntegerValue convertToByte() {
        byte by = (byte)this.value;
        return by == this.value ? this : IntegerValueFactory.create(by);
    }

    public IntegerValue convertToCharacter() {
        char c = (char)this.value;
        return c == this.value ? this : IntegerValueFactory.create(c);
    }

    public IntegerValue convertToShort() {
        short s = (short)this.value;
        return s == this.value ? this : IntegerValueFactory.create(s);
    }

    public IntegerValue convertToInteger() {
        return this;
    }

    public LongValue convertToLong() {
        return LongValueFactory.create(this.value);
    }

    public FloatValue convertToFloat() {
        return FloatValueFactory.create(this.value);
    }

    public DoubleValue convertToDouble() {
        return DoubleValueFactory.create(this.value);
    }

    public IntegerValue generalize(SpecificIntegerValue specificIntegerValue) {
        return this.value == specificIntegerValue.value ? this : IntegerValueFactory.create();
    }

    public IntegerValue add(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value + specificIntegerValue.value);
    }

    public IntegerValue subtract(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value - specificIntegerValue.value);
    }

    public IntegerValue subtractFrom(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(specificIntegerValue.value - this.value);
    }

    public IntegerValue multiply(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value * specificIntegerValue.value);
    }

    public IntegerValue divide(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return IntegerValueFactory.create(this.value / specificIntegerValue.value);
    }

    public IntegerValue divideOf(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return IntegerValueFactory.create(specificIntegerValue.value / this.value);
    }

    public IntegerValue remainder(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return IntegerValueFactory.create(this.value % specificIntegerValue.value);
    }

    public IntegerValue remainderOf(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return IntegerValueFactory.create(specificIntegerValue.value % this.value);
    }

    public IntegerValue shiftLeft(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value << specificIntegerValue.value);
    }

    public IntegerValue shiftLeftOf(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(specificIntegerValue.value << this.value);
    }

    public IntegerValue shiftRight(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value >> specificIntegerValue.value);
    }

    public IntegerValue shiftRightOf(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(specificIntegerValue.value >> this.value);
    }

    public IntegerValue unsignedShiftRight(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value >>> specificIntegerValue.value);
    }

    public IntegerValue unsignedShiftRightOf(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(specificIntegerValue.value >>> this.value);
    }

    public LongValue shiftLeftOf(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value() << this.value);
    }

    public LongValue shiftRightOf(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value() >> this.value);
    }

    public LongValue unsignedShiftRightOf(SpecificLongValue specificLongValue) {
        return LongValueFactory.create(specificLongValue.value() >>> this.value);
    }

    public IntegerValue and(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value & specificIntegerValue.value);
    }

    public IntegerValue or(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value | specificIntegerValue.value);
    }

    public IntegerValue xor(SpecificIntegerValue specificIntegerValue) {
        return IntegerValueFactory.create(this.value ^ specificIntegerValue.value);
    }

    public int equal(SpecificIntegerValue specificIntegerValue) {
        return this.value == specificIntegerValue.value ? 1 : -1;
    }

    public int lessThan(SpecificIntegerValue specificIntegerValue) {
        return this.value < specificIntegerValue.value ? 1 : -1;
    }

    public int lessThanOrEqual(SpecificIntegerValue specificIntegerValue) {
        return this.value <= specificIntegerValue.value ? 1 : -1;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificIntegerValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return "i:" + this.value;
    }
}

