/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MultiMemberInfoVisitor
implements MemberInfoVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private MemberInfoVisitor[] memberInfoVisitors;
    private int memberInfoVisitorCount;

    public MultiMemberInfoVisitor() {
    }

    public MultiMemberInfoVisitor(MemberInfoVisitor[] memberInfoVisitorArray) {
        this.memberInfoVisitors = memberInfoVisitorArray;
        this.memberInfoVisitorCount = memberInfoVisitorArray.length;
    }

    public void addMemberInfoVisitor(MemberInfoVisitor memberInfoVisitor) {
        this.ensureArraySize();
        this.memberInfoVisitors[this.memberInfoVisitorCount++] = memberInfoVisitor;
    }

    private void ensureArraySize() {
        if (this.memberInfoVisitors == null) {
            this.memberInfoVisitors = new MemberInfoVisitor[5];
        } else if (this.memberInfoVisitors.length == this.memberInfoVisitorCount) {
            MemberInfoVisitor[] memberInfoVisitorArray = new MemberInfoVisitor[this.memberInfoVisitorCount + 5];
            System.arraycopy(this.memberInfoVisitors, 0, memberInfoVisitorArray, 0, this.memberInfoVisitorCount);
            this.memberInfoVisitors = memberInfoVisitorArray;
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        for (int i = 0; i < this.memberInfoVisitorCount; ++i) {
            this.memberInfoVisitors[i].visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        for (int i = 0; i < this.memberInfoVisitorCount; ++i) {
            this.memberInfoVisitors[i].visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        for (int i = 0; i < this.memberInfoVisitorCount; ++i) {
            this.memberInfoVisitors[i].visitLibraryFieldInfo(libraryClassFile, libraryFieldInfo);
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        for (int i = 0; i < this.memberInfoVisitorCount; ++i) {
            this.memberInfoVisitors[i].visitLibraryMethodInfo(libraryClassFile, libraryMethodInfo);
        }
    }
}

