/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationVisitor;

public abstract class RuntimeAnnotationsAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2numberOfAnnotations;
    public Annotation[] annotations;

    protected RuntimeAnnotationsAttrInfo() {
    }

    public void annotationsAccept(ClassFile classFile, AnnotationVisitor annotationVisitor) {
        for (int i = 0; i < this.u2numberOfAnnotations; ++i) {
            annotationVisitor.visitAnnotation(classFile, this.annotations[i]);
        }
    }

    protected int getLength() {
        int n = 2;
        for (int i = 0; i < this.u2numberOfAnnotations; ++i) {
            n += this.annotations[i].getLength();
        }
        return n;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2numberOfAnnotations = dataInput.readUnsignedShort();
        this.annotations = new Annotation[this.u2numberOfAnnotations];
        for (int i = 0; i < this.u2numberOfAnnotations; ++i) {
            this.annotations[i] = Annotation.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2numberOfAnnotations);
        for (int i = 0; i < this.u2numberOfAnnotations; ++i) {
            this.annotations[i].write(dataOutput);
        }
    }
}

