/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;

public abstract class MessagePartContainer {
    private OperationInfo operation;
    private Map messageParts = new HashMap();
    private List messagePartList = new LinkedList();

    protected MessagePartContainer(OperationInfo operation) {
        this.operation = operation;
    }

    public OperationInfo getOperation() {
        return this.operation;
    }

    public MessagePartInfo addMessagePart(QName name, Class clazz) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        MessagePartInfo part = new MessagePartInfo(name, clazz, this);
        this.addMessagePart(part);
        return part;
    }

    public void addMessagePart(MessagePartInfo part) {
        this.messageParts.put(part.getName(), part);
        this.messagePartList.add(part);
    }

    public int getMessagePartIndex(MessagePartInfo part) {
        return this.messagePartList.indexOf(part);
    }

    public void removeMessagePart(QName name) {
        MessagePartInfo messagePart = this.getMessagePart(name);
        if (messagePart != null) {
            this.messageParts.remove(name);
            this.messagePartList.remove(messagePart);
        }
    }

    public MessagePartInfo getMessagePart(QName name) {
        return (MessagePartInfo)this.messageParts.get(name);
    }

    public List getMessageParts() {
        return Collections.unmodifiableList(this.messagePartList);
    }

    public int size() {
        return this.messagePartList.size();
    }
}

