/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoSubGraphHandle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JGoSubGraph
extends JGoNode {
    private static final int flagExpanded = 65536;
    private static final int flagCollapsible = 131072;
    private static final int flagExpandedResizable = 262144;
    private static final int flagWasExpanded = 524288;
    public static final int StateExpanded = 0;
    public static final int StateCollapsed = 1;
    public static final int StateExpanding = 2;
    public static final int StateCollapsing = 3;
    public static final int ChangedBackgroundColor = 2401;
    public static final int ChangedBorderPen = 2402;
    public static final int ChangedLabelSpot = 2403;
    public static final int ChangedCollapsible = 2405;
    public static final int ChangedInsets = 2406;
    public static final int ChangedOpacity = 2407;
    public static final int ChangedCollapsedLabelSpot = 2408;
    public static final int ChangedCollapsedInsets = 2409;
    public static final int ChangedCollapsedObject = 2410;
    public static final int ChangedLabel = 2411;
    public static final int ChangedPort = 2412;
    public static final int ChangedState = 2413;
    public static final int ChangedSavedBounds = 2414;
    public static final int ChangedSavedPaths = 2415;
    public static final int ChangedWasExpanded = 2416;
    public static final int ChangedExpandedResizable = 2417;
    private int myState = 0;
    private JGoSubGraphHandle myHandle = null;
    private JGoText myLabel = null;
    private JGoPort myPort = null;
    private JGoObject myCollapsedObject = null;
    private Color myBackgroundColor = new Color(200, 200, 255, 63);
    private double myOpacity = 0.2;
    private JGoPen myBorderPen = null;
    private int myLabelSpot = 2;
    private int myCollapsedLabelSpot = 0;
    private Insets myInsets = new Insets(4, 4, 4, 4);
    private Insets myCollapsedInsets = new Insets(0, 0, 0, 0);
    private HashMap myBoundsHashtable = new HashMap();
    private HashMap myPathsHashtable = new HashMap();
    private transient Rectangle mySavedBoundsInsideMargins = null;

    public JGoSubGraph() {
        this.initCommon();
    }

    public JGoSubGraph(String labeltext) {
        this.initCommon();
        this.initialize(labeltext);
    }

    private void initCommon() {
        this.setInternalFlags((this.getInternalFlags() | 0x100000 | 0x10000 | 0x20000) & 0xFFFFFFEF & 0xFFFFFBFF);
    }

    public void initialize(String labeltext) {
        this.myCollapsedObject = this.createCollapsedObject();
        super.addObjectAtTail(this.myCollapsedObject);
        this.myLabel = this.createLabel(labeltext);
        super.addObjectAtTail(this.myLabel);
        this.myHandle = this.createHandle();
        super.addObjectAtTail(this.myHandle);
        this.myPort = this.createPort();
        super.addObjectAtHead(this.myPort);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoText createLabel(String labeltext) {
        JGoText t = null;
        if (labeltext != null) {
            t = new JGoText();
            t.setText(labeltext);
            t.setSelectable(false);
            t.setDragsNode(true);
            t.setEditable(true);
            t.setEditOnSingleClick(true);
            t.setTransparent(true);
            t.setBold(true);
            t.setAlignment(2);
            t.setMultiline(true);
            t.setWrapping(true);
        }
        return t;
    }

    public JGoSubGraphHandle createHandle() {
        JGoSubGraphHandle h = new JGoSubGraphHandle();
        return h;
    }

    protected JGoPort createPort() {
        return null;
    }

    protected JGoObject createCollapsedObject() {
        return null;
    }

    protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        JGoObject copyobj;
        JGoObject origobj;
        Map.Entry pair;
        JGoSubGraph newobj = (JGoSubGraph)newarea;
        newobj.myState = this.myState;
        newobj.myBackgroundColor = this.myBackgroundColor;
        newobj.myOpacity = this.myOpacity;
        newobj.myBorderPen = this.myBorderPen;
        newobj.myLabelSpot = this.myLabelSpot;
        newobj.myCollapsedLabelSpot = this.myCollapsedLabelSpot;
        newobj.myInsets.top = this.myInsets.top;
        newobj.myInsets.left = this.myInsets.left;
        newobj.myInsets.bottom = this.myInsets.bottom;
        newobj.myInsets.right = this.myInsets.right;
        newobj.myCollapsedInsets.top = this.myCollapsedInsets.top;
        newobj.myCollapsedInsets.left = this.myCollapsedInsets.left;
        newobj.myCollapsedInsets.bottom = this.myCollapsedInsets.bottom;
        newobj.myCollapsedInsets.right = this.myCollapsedInsets.right;
        super.copyChildren(newarea, env);
        newobj.myHandle = (JGoSubGraphHandle)env.get(this.myHandle);
        newobj.myLabel = (JGoText)env.get(this.myLabel);
        newobj.myPort = (JGoPort)env.get(this.myPort);
        newobj.myCollapsedObject = (JGoObject)env.get(this.myCollapsedObject);
        HashMap newmap = newobj.myBoundsHashtable;
        Iterator it = this.myBoundsHashtable.entrySet().iterator();
        while (it.hasNext()) {
            pair = it.next();
            origobj = (JGoObject)pair.getKey();
            copyobj = (JGoObject)env.get(origobj);
            Rectangle r = (Rectangle)pair.getValue();
            newmap.put(copyobj, new Rectangle(r.x, r.y, r.width, r.height));
        }
        newmap = newobj.myPathsHashtable;
        it = this.myPathsHashtable.entrySet().iterator();
        while (it.hasNext()) {
            pair = it.next();
            origobj = (JGoStroke)pair.getKey();
            copyobj = (JGoStroke)env.get(origobj);
            if (origobj == null) continue;
            ArrayList pts = (ArrayList)pair.getValue();
            ArrayList<Point> copypts = new ArrayList<Point>();
            for (int i = 0; i < pts.size(); ++i) {
                Point p = (Point)pts.get(i);
                copypts.add(new Point(p.x, p.y));
            }
            newmap.put(copyobj, copypts);
        }
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        JGoListPosition pos = super.addObjectAtHead(obj);
        if (pos != null) {
            obj.setDragsNode(false);
        }
        return pos;
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        JGoObject ontop = this.getLabel();
        if (ontop == null) {
            ontop = this.getHandle();
        }
        if (ontop != null) {
            return this.insertObjectBefore(this.findObject(ontop), obj);
        }
        JGoListPosition pos = super.addObjectAtTail(obj);
        if (pos != null) {
            obj.setDragsNode(false);
        }
        return pos;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        JGoListPosition newpos = super.insertObjectBefore(pos, obj);
        if (newpos != null) {
            obj.setDragsNode(false);
        }
        return newpos;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        JGoListPosition newpos = super.insertObjectAfter(pos, obj);
        if (newpos != null) {
            obj.setDragsNode(false);
        }
        return newpos;
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject child = super.removeObjectAtPos(pos);
        if (child == this.myLabel) {
            this.myLabel = null;
        } else if (child == this.myHandle) {
            this.myHandle = null;
        } else if (child == this.myPort) {
            this.myPort = null;
        } else if (child == this.myCollapsedObject) {
            this.myCollapsedObject = null;
        }
        if (this.getSavedBounds().containsKey(child)) {
            this.getSavedBounds().remove(child);
        }
        if (this.getSavedPaths().containsKey(child)) {
            this.getSavedPaths().remove(child);
        }
        return child;
    }

    public void paint(Graphics2D g, JGoView view) {
        if (this.paintsDecoration(view)) {
            this.paintDecoration(g, view);
        }
        super.paint(g, view);
    }

    protected boolean paintsDecoration(JGoView view) {
        return this.getCollapsedObject() == null || !this.getCollapsedObject().isVisible();
    }

    protected void paintDecoration(Graphics2D g, JGoView view) {
        Color c = this.getBackgroundColor();
        JGoPen p = this.getBorderPen();
        if (c != null || p != null) {
            Rectangle r = this.computeBorder();
            if (c.getAlpha() == 255) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), Math.max(0, Math.min(255, (int)(255.0 * this.getOpacity()))));
            }
            JGoDrawable.drawRect(g, p, JGoBrush.makeStockBrush(c), r.x, r.y, r.width, r.height);
        }
    }

    public void expandRectByPenWidth(Rectangle rect) {
        super.expandRectByPenWidth(rect);
        Insets insets = this.isExpanded() ? this.getInsets() : this.getCollapsedInsets();
        int w = 1;
        JGoPen pen = this.getBorderPen();
        if (pen != null) {
            w = pen.getWidth();
        }
        rect.x -= w + insets.left;
        rect.y -= w + insets.top;
        rect.width += w + insets.left + insets.right;
        rect.height += w + insets.top + insets.bottom;
    }

    protected Rectangle computeBoundingRect() {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        boolean any = false;
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!obj.isVisible()) continue;
            Rectangle b = obj.getBoundingRect();
            if (!any) {
                any = true;
                rect.x = b.x;
                rect.y = b.y;
                rect.width = b.width;
                rect.height = b.height;
                continue;
            }
            rect.add(b);
        }
        if (!any) {
            rect = this.getBoundingRect();
        }
        Rectangle r = this.computeBorder();
        r.add(rect);
        return r;
    }

    public Rectangle computeBorder() {
        Rectangle rect = this.computeInsideMargins(null);
        if (rect.width > 0 && rect.height > 0) {
            Insets insets = this.isExpanded() ? this.getInsets() : this.getCollapsedInsets();
            rect.x -= insets.left;
            rect.y -= insets.top;
            rect.width += insets.left + insets.right;
            rect.height += insets.top + insets.bottom;
        } else {
            JGoSubGraph.setBoundsRect(rect, this.getBoundingRect());
        }
        return rect;
    }

    public Rectangle computeInsideMargins(JGoObject ignore) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        boolean any = false;
        boolean more = false;
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (ignore != null && obj == ignore || this.computeInsideMarginsSkip(obj)) continue;
            Rectangle r = obj.getBoundingRect();
            if (!any) {
                any = true;
                JGoSubGraph.setBoundsRect(rect, r);
                continue;
            }
            more = true;
            rect.add(r);
        }
        if (!any) {
            if (this.getCollapsedObject() != null) {
                JGoSubGraph.setBoundsRect(rect, this.getCollapsedObject().getBoundingRect());
            } else if (this.mySavedBoundsInsideMargins != null) {
                JGoSubGraph.setBoundsRect(rect, this.mySavedBoundsInsideMargins);
            }
        } else if (any && !more) {
            if (this.mySavedBoundsInsideMargins == null) {
                this.mySavedBoundsInsideMargins = new Rectangle(0, 0, 0, 0);
            }
            JGoSubGraph.setBoundsRect(this.mySavedBoundsInsideMargins, rect);
        }
        return rect;
    }

    protected boolean computeInsideMarginsSkip(JGoObject child) {
        if (child == this.getHandle()) {
            return true;
        }
        if (child == this.getLabel()) {
            return !child.isVisible();
        }
        if (child instanceof JGoPort) {
            return true;
        }
        if (child == this.getCollapsedObject()) {
            return !child.isVisible();
        }
        JGoLink link = null;
        if (child instanceof JGoLink) {
            link = (JGoLink)child;
        }
        if (link != null) {
            if (!link.isVisible() || !this.isExpanded()) {
                return true;
            }
            if (this.getPort() != null && (link.getFromPort() != null && link.getFromPort().getParent() == this || link.getToPort() != null && link.getToPort().getParent() == this)) {
                return true;
            }
        } else if (this.getCollapsedObject() != null && !child.isVisible() && !this.isExpanded()) {
            return true;
        }
        return false;
    }

    public ArrayList pickObjects(Point p, boolean selectableOnly, ArrayList coll, int max) {
        if (coll == null) {
            coll = new ArrayList<JGoObject>();
        }
        if (coll.size() >= max) {
            return coll;
        }
        if (!this.isVisible()) {
            return coll;
        }
        if (!super.isPointInObj(p)) {
            return coll;
        }
        JGoListPosition pos = this.getLastObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getPrevObjectPos(pos);
            JGoObject picked = obj.pick(p, selectableOnly);
            if (picked == null) continue;
            coll.add(picked);
            if (coll.size() < max) continue;
            return coll;
        }
        JGoObject selfpick = this.pick(p, selectableOnly);
        if (selfpick != null) {
            coll.add(this);
        }
        return coll;
    }

    protected void gainedSelection(JGoSelection selection) {
        if (!this.isResizable()) {
            selection.createBoundingHandle(this);
            return;
        }
        Rectangle rect = this.computeBorder();
        int x1 = rect.x;
        int x2 = rect.x + rect.width / 2;
        int x3 = rect.x + rect.width;
        int y1 = rect.y;
        int y2 = rect.y + rect.height / 2;
        int y3 = rect.y + rect.height;
        selection.createResizeHandle(this, x1, y1, 1, true);
        selection.createResizeHandle(this, x3, y1, 3, true);
        selection.createResizeHandle(this, x1, y3, 7, true);
        selection.createResizeHandle(this, x3, y3, 5, true);
        if (!this.is4ResizeHandles()) {
            selection.createResizeHandle(this, x2, y1, 2, true);
            selection.createResizeHandle(this, x3, y2, 4, true);
            selection.createResizeHandle(this, x2, y3, 6, true);
            selection.createResizeHandle(this, x1, y2, 8, true);
        }
    }

    protected Rectangle handleResize(Graphics2D g, JGoView view, Rectangle origRect, Point newPoint, int whichHandle, int evttype, int minWidth, int minHeight) {
        Rectangle reqBounds = this.computeInsideMargins(null);
        Rectangle box = this.computeResize(origRect, newPoint, whichHandle, reqBounds.width, reqBounds.height);
        Insets ins = new Insets(Math.max(0, reqBounds.y - box.y), Math.max(0, reqBounds.x - box.x), Math.max(0, box.y + box.height - (reqBounds.y + reqBounds.height)), Math.max(0, box.x + box.width - (reqBounds.x + reqBounds.width)));
        if (this.isExpanded()) {
            this.setInsets(ins);
        } else {
            this.setCollapsedInsets(ins);
        }
        return null;
    }

    public void layoutChildren(JGoObject child) {
        if (this.isInitializing()) {
            return;
        }
        if (child != null && child == this.getHandle()) {
            return;
        }
        if (child != null && child == this.getPort()) {
            return;
        }
        this.layoutCollapsedObject();
        this.layoutLabel();
        this.layoutHandle();
        if (this.getHandle() != null && this.getLabel() != null && this.getHandle().getLeft() == this.getLabel().getLeft() && this.getHandle().getTop() == this.getLabel().getTop()) {
            this.layoutLabel();
        }
        this.layoutPort();
    }

    protected void layoutCollapsedObject() {
        Rectangle rect;
        JGoObject icon = this.getCollapsedObject();
        if (icon == null) {
            return;
        }
        if (this.isExpanded()) {
            rect = this.computeInsideMargins(icon);
        } else {
            Dimension maxsize = this.computeCollapsedSize(true);
            rect = this.computeCollapsedRectangle(maxsize);
        }
        boolean oldInit = this.isInitializing();
        this.setInitializing(true);
        icon.setTopLeft(rect.x, rect.y);
        this.setInitializing(oldInit);
    }

    protected void layoutLabel() {
        Rectangle rect;
        int spot;
        JGoText lab = this.getLabel();
        if (lab == null) {
            return;
        }
        if (!this.isExpanded()) {
            spot = this.getCollapsedLabelSpot();
            JGoObject icon = this.getCollapsedObject();
            if (icon != null) {
                rect = icon.getBoundingRect();
            } else {
                Dimension maxsize = this.computeCollapsedSize(true);
                rect = this.computeCollapsedRectangle(maxsize);
            }
        } else {
            spot = this.getLabelSpot();
            rect = this.computeInsideMargins(lab);
        }
        Point pt = this.getRectangleSpotLocation(rect, spot, null);
        boolean oldInit = this.isInitializing();
        this.setInitializing(true);
        this.positionLabel(lab, spot, pt);
        this.setInitializing(oldInit);
    }

    private void positionLabel(JGoText lab, int spot, Point pt) {
        if (spot == 1) {
            lab.setAlignment(spot);
            lab.setSpotLocation(7, pt);
            if (this.getHandle() != null && this.getHandle().getLeft() == lab.getLeft() && this.getHandle().getTop() == lab.getTop()) {
                pt.x += this.getHandle().getWidth() + 2;
                lab.setSpotLocation(7, pt);
            }
        } else if (spot == 3) {
            lab.setAlignment(spot);
            lab.setSpotLocation(5, pt);
        } else if (spot == 5) {
            lab.setAlignment(spot);
            lab.setSpotLocation(3, pt);
        } else if (spot == 7) {
            lab.setAlignment(spot);
            lab.setSpotLocation(1, pt);
        } else {
            lab.setAlignment(JGoSubGraph.spotOpposite(spot));
            lab.setSpotLocation(JGoSubGraph.spotOpposite(spot), pt);
        }
    }

    protected void layoutHandle() {
        if (!this.isExpanded()) {
            return;
        }
        JGoSubGraphHandle h = this.getHandle();
        if (h != null) {
            Rectangle r = this.computeInsideMargins(null);
            h.setTopLeft(r.x, r.y);
        }
    }

    public void layoutPort() {
        JGoPort p = this.getPort();
        if (p != null) {
            if (this.getHandle() != null) {
                Rectangle r = this.getHandle().getBoundingRect();
                p.setBoundingRect(r);
            } else if (this.getLabel() != null) {
                p.setBoundingRect(this.getLabel().getBoundingRect());
            } else {
                Rectangle r = this.computeInsideMargins(null);
                p.setTopLeft(r.x, r.y);
            }
        }
    }

    public static JGoSubGraph findParentSubGraph(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        for (JGoArea o = obj.getParent(); o != null; o = o.getParent()) {
            if (!(o instanceof JGoSubGraph)) continue;
            return (JGoSubGraph)o;
        }
        return null;
    }

    public static void reparentToCommonSubGraph(JGoObject obj, JGoObject child1, JGoObject child2, boolean behind, JGoLayer layer) {
        JGoObject pgroup;
        JGoSubGraph fsg = JGoSubGraph.findParentSubGraph(child1);
        JGoSubGraph tsg = JGoSubGraph.findParentSubGraph(child2);
        for (pgroup = JGoObject.findCommonParent(fsg, tsg); pgroup != null && !(pgroup instanceof JGoSubGraph); pgroup = pgroup.getParent()) {
        }
        JGoSubGraph sg = null;
        if (pgroup instanceof JGoSubGraph) {
            sg = (JGoSubGraph)pgroup;
        }
        if (obj.getParent() != sg || obj.getLayer() == null) {
            if (obj.getParent() == null && obj.getLayer() == null) {
                if (sg != null) {
                    if (behind) {
                        sg.addObjectAtHead(obj);
                    } else {
                        sg.addObjectAtTail(obj);
                    }
                } else {
                    layer.addObjectAtTail(obj);
                }
            } else {
                ArrayList<JGoObject> coll = new ArrayList<JGoObject>();
                coll.add(obj);
                if (sg != null) {
                    sg.addCollection(coll, false, null);
                } else {
                    layer.addCollection(coll, false, null);
                }
            }
        }
    }

    public static void reparentAllLinksToSubGraphs(JGoObjectSimpleCollection coll, boolean behind, JGoLayer layer) {
        ArrayList<JGoObject> items = new ArrayList<JGoObject>();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            items.add(obj);
        }
        JGoSubGraph.reparentAllLinksToSubGraphs(items, behind, layer);
    }

    public static void reparentAllLinksToSubGraphs(ArrayList coll, boolean behind, JGoLayer layer) {
        ArrayList<JGoLink> search = new ArrayList<JGoLink>();
        for (int j = 0; j < coll.size(); ++j) {
            JGoLink link;
            JGoLink link2;
            int i;
            JGoObject obj = (JGoObject)coll.get(j);
            if (obj instanceof JGoNode) {
                JGoNode node = (JGoNode)obj;
                search.clear();
                ArrayList links = node.findAll(6, search);
                for (i = 0; i < links.size(); ++i) {
                    link2 = (JGoLink)links.get(i);
                    if (link2 == null || link2.getFromPort() == null || link2.getToPort() == null) continue;
                    JGoSubGraph.reparentToCommonSubGraph(link2, link2.getFromPort(), link2.getToPort(), behind, layer);
                }
                continue;
            }
            if (obj instanceof JGoPort) {
                JGoPort port = (JGoPort)obj;
                search.clear();
                JGoListPosition pos = port.getFirstLinkPos();
                while (pos != null) {
                    JGoLink link3 = port.getLinkAtPos(pos);
                    pos = port.getNextLinkPos(pos);
                    search.add(link3);
                }
                for (i = 0; i < search.size(); ++i) {
                    link2 = (JGoLink)search.get(i);
                    if (link2 == null || link2.getFromPort() == null || link2.getToPort() == null) continue;
                    JGoSubGraph.reparentToCommonSubGraph(link2, link2.getFromPort(), link2.getToPort(), behind, layer);
                }
                continue;
            }
            if (!(obj instanceof JGoLink) || (link = (JGoLink)obj) == null || link.getFromPort() == null || link.getToPort() == null) continue;
            JGoSubGraph.reparentToCommonSubGraph(link, link.getFromPort(), link.getToPort(), behind, layer);
        }
    }

    public Dimension computeCollapsedSize(boolean visible) {
        Dimension maxsize = new Dimension(0, 0);
        if (visible && this.getCollapsedObject() != null) {
            Dimension csize = this.getCollapsedObject().getSize();
            maxsize.width = csize.width;
            maxsize.height = csize.height;
        }
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (this.computeCollapsedSizeSkip(obj)) continue;
            Dimension sz = obj.getSize();
            JGoSubGraph g = null;
            if (obj instanceof JGoSubGraph) {
                g = (JGoSubGraph)obj;
            }
            if (g != null) {
                sz = g.computeCollapsedSize(false);
            }
            maxsize.width = Math.max(maxsize.width, sz.width);
            maxsize.height = Math.max(maxsize.height, sz.height);
        }
        return maxsize;
    }

    protected boolean computeCollapsedSizeSkip(JGoObject child) {
        if (child == this.getHandle()) {
            return true;
        }
        if (child == this.getLabel()) {
            return true;
        }
        if (child == this.getCollapsedObject()) {
            return true;
        }
        if (child instanceof JGoPort) {
            return true;
        }
        if (child instanceof JGoLink) {
            return true;
        }
        if (child.getPartner() instanceof JGoLabeledLink) {
            return true;
        }
        return this.getCollapsedObject() != null && !child.isVisible();
    }

    protected Point computeReferencePoint() {
        Point hpos = this.getHandle() != null ? this.getHandle().getTopLeft() : this.getTopLeft();
        return hpos;
    }

    protected Rectangle computeCollapsedRectangle(Dimension s) {
        Point hpos = this.computeReferencePoint();
        return new Rectangle(hpos.x, hpos.y, s.width, s.height);
    }

    public void collapse() {
        JGoObject obj;
        if (this.getState() != 0) {
            return;
        }
        if (!this.isCollapsible()) {
            return;
        }
        this.setState(3);
        this.setInitializing(true);
        this.foredate(40);
        this.foredate(2415);
        this.foredate(2414);
        this.getSavedBounds().put(this, JGoSubGraph.copyRect(this.getBoundingRect()));
        this.prepareCollapse();
        Dimension maxsize = this.computeCollapsedSize(true);
        Rectangle cr = this.computeCollapsedRectangle(maxsize);
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            this.saveChildBounds(obj, cr);
        }
        pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            this.collapseChild(obj, cr);
        }
        this.finishCollapse(cr);
        this.setInitializing(false);
        this.setState(1);
        this.layoutChildren(null);
        this.setBoundingRectInvalid(true);
        this.update(2414, 0, null);
        this.update(2415, 0, null);
        this.update(40, 0, null);
    }

    protected void prepareCollapse() {
    }

    protected void saveChildBounds(JGoObject child, Rectangle sgrect) {
        if (child == this.getHandle()) {
            return;
        }
        if (child == this.getLabel()) {
            return;
        }
        if (child == this.getCollapsedObject()) {
            return;
        }
        if (child instanceof JGoPort) {
            return;
        }
        if (child instanceof JGoLink) {
            JGoLink stroke = (JGoLink)child;
            ArrayList copy = stroke.copyPointsArray();
            for (int i = 0; i < copy.size(); ++i) {
                Point p = (Point)copy.get(i);
                p.x -= sgrect.x;
                p.y -= sgrect.y;
            }
            this.getSavedPaths().put(child, copy);
        } else if (!(child.getPartner() instanceof JGoLabeledLink)) {
            Rectangle rect = child.getBoundingRect();
            this.getSavedBounds().put(child, new Rectangle(rect.x - sgrect.x, rect.y - sgrect.y, rect.width, rect.height));
        }
    }

    protected void collapseChild(JGoObject child, Rectangle sgrect) {
        if (child == this.getHandle()) {
            return;
        }
        if (child == this.getLabel()) {
            return;
        }
        if (child == this.getCollapsedObject()) {
            return;
        }
        if (child instanceof JGoPort) {
            return;
        }
        if (!(child instanceof JGoLink)) {
            JGoSubGraph sg = null;
            if (child instanceof JGoSubGraph) {
                sg = (JGoSubGraph)child;
            }
            if (sg != null && sg.isExpanded()) {
                sg.setWasExpanded(true);
                sg.collapse();
            }
            Point mid = new Point(sgrect.x + sgrect.width / 2, sgrect.y + sgrect.height / 2);
            child.setSpotLocation(0, mid);
        }
        child.setVisible(false);
    }

    protected void finishCollapse(Rectangle sgrect) {
        if (this.getCollapsedObject() != null) {
            this.getCollapsedObject().setVisible(true);
        }
        if (this.isResizable()) {
            this.setExpandedResizable(true);
            this.setResizable(false);
        }
    }

    public void expand() {
        JGoObject obj;
        if (this.getState() != 1) {
            return;
        }
        if (!this.isCollapsible()) {
            return;
        }
        this.setState(2);
        this.setInitializing(true);
        this.foredate(40);
        this.foredate(2415);
        this.foredate(2414);
        this.prepareExpand();
        Point hpos = this.computeReferencePoint();
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (obj instanceof JGoLink) continue;
            this.expandChild(obj, hpos);
        }
        pos = this.getFirstObjectPos();
        while (pos != null) {
            obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPos(pos);
            if (!(obj instanceof JGoLink)) continue;
            this.expandChild(obj, hpos);
        }
        boolean empty = this.getSavedBounds().size() <= 1;
        Rectangle savedBounds = null;
        if (this.getSavedBounds().containsKey(this)) {
            savedBounds = (Rectangle)this.getSavedBounds().get(this);
        }
        this.finishExpand(hpos);
        this.setInitializing(false);
        this.setState(0);
        this.layoutChildren(null);
        this.setBoundingRectInvalid(true);
        if (empty && savedBounds != null) {
            this.setTopLeft(savedBounds.x, savedBounds.y);
        }
        this.update(2414, 0, null);
        this.update(2415, 0, null);
        this.update(40, 0, null);
    }

    protected void prepareExpand() {
    }

    protected void expandChild(JGoObject child, Point hpos) {
        if (child == this.getCollapsedObject()) {
            return;
        }
        child.setVisible(true);
        if (child instanceof JGoLink) {
            JGoLink stroke = (JGoLink)child;
            if (this.getSavedPaths().containsKey(stroke)) {
                ArrayList vec = (ArrayList)this.getSavedPaths().get(stroke);
                ArrayList<Point> copy = new ArrayList<Point>();
                for (int i = 0; i < vec.size(); ++i) {
                    Point p = (Point)vec.get(i);
                    copy.add(new Point(p.x + hpos.x, p.y + hpos.y));
                }
                stroke.setPoints(copy);
            }
        } else if (this.getSavedBounds().containsKey(child)) {
            Rectangle r = (Rectangle)this.getSavedBounds().get(child);
            if (child instanceof JGoSubGraph) {
                JGoSubGraph sg = (JGoSubGraph)child;
                if (sg.isWasExpanded()) {
                    sg.setWasExpanded(false);
                    sg.expand();
                }
                sg.setTopLeft(hpos.x + r.x, hpos.y + r.y);
            } else {
                child.setBoundingRect(hpos.x + r.x, hpos.y + r.y, r.width, r.height);
            }
        }
    }

    protected void finishExpand(Point hpos) {
        if (this.getCollapsedObject() != null) {
            this.getCollapsedObject().setVisible(false);
        }
        if (this.isExpandedResizable()) {
            this.setExpandedResizable(false);
            this.setResizable(true);
        }
        this.getSavedBounds().clear();
        this.getSavedPaths().clear();
    }

    public void toggle() {
        if (this.getState() == 0) {
            this.collapse();
        } else if (this.getState() == 1) {
            this.expand();
        }
    }

    public void expandAll() {
        this.expand();
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!(obj instanceof JGoSubGraph)) continue;
            ((JGoSubGraph)obj).expandAll();
        }
    }

    public HashMap getSavedBounds() {
        return this.myBoundsHashtable;
    }

    public HashMap getSavedPaths() {
        return this.myPathsHashtable;
    }

    public JGoSubGraphHandle getHandle() {
        return this.myHandle;
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText value) {
        JGoText old = this.myLabel;
        if (old != value) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myLabel = value;
            if (value != null) {
                this.addObjectAtTail(value);
            }
            this.update(2411, 0, old);
        }
    }

    public JGoPort getPort() {
        return this.myPort;
    }

    public void setPort(JGoPort value) {
        JGoPort old = this.myPort;
        if (old != value) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myPort = value;
            if (value != null) {
                this.addObjectAtHead(value);
            }
            this.update(2412, 0, old);
        }
    }

    public JGoObject getCollapsedObject() {
        return this.myCollapsedObject;
    }

    public void setCollapsedObject(JGoObject value) {
        JGoObject old = this.myCollapsedObject;
        if (old != value) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myCollapsedObject = value;
            if (value != null) {
                this.addObjectAtHead(value);
            }
            this.update(2410, 0, old);
            if (this.getCollapsedObject() != null && old != null) {
                this.getCollapsedObject().setVisible(old.isVisible());
            }
        }
    }

    public Color getBackgroundColor() {
        return this.myBackgroundColor;
    }

    public void setBackgroundColor(Color c) {
        Color old = this.myBackgroundColor;
        if (old == null && c != null || !old.equals(c)) {
            this.myBackgroundColor = c;
            this.update(2401, 0, old);
        }
    }

    public void setOpacity(double opacity) {
        double old = this.myOpacity;
        if (old != opacity && opacity >= 0.0 && opacity <= 1.0) {
            this.myOpacity = opacity;
            this.update(2407, 0, new Double(old));
        }
    }

    public double getOpacity() {
        return this.myOpacity;
    }

    public JGoPen getBorderPen() {
        return this.myBorderPen;
    }

    public void setBorderPen(JGoPen p) {
        JGoPen old = this.myBorderPen;
        if (old == null && p != null || !old.equals(p)) {
            this.myBorderPen = p;
            this.update(2402, 0, old);
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void setInsets(Insets x) {
        Insets s = this.myInsets;
        if (!s.equals(x) && x.top >= 0 && x.left >= 0 && x.bottom >= 0 && x.right >= 0) {
            this.update();
            Insets oldInsets = new Insets(s.top, s.left, s.bottom, s.right);
            this.myInsets.top = x.top;
            this.myInsets.left = x.left;
            this.myInsets.bottom = x.bottom;
            this.myInsets.right = x.right;
            this.update(2406, 0, oldInsets);
        }
    }

    public Insets getCollapsedInsets() {
        return this.myCollapsedInsets;
    }

    public void setCollapsedInsets(Insets x) {
        Insets s = this.myCollapsedInsets;
        if (!s.equals(x) && x.top >= 0 && x.left >= 0 && x.bottom >= 0 && x.right >= 0) {
            this.update();
            Insets oldInsets = new Insets(s.top, s.left, s.bottom, s.right);
            this.myCollapsedInsets.top = x.top;
            this.myCollapsedInsets.left = x.left;
            this.myCollapsedInsets.bottom = x.bottom;
            this.myCollapsedInsets.right = x.right;
            this.update(2406, 0, oldInsets);
        }
    }

    public int getLabelSpot() {
        return this.myLabelSpot;
    }

    public void setLabelSpot(int s) {
        this.setLabelSpot(s, false);
    }

    private void setLabelSpot(int spot, boolean undoing) {
        int old = this.myLabelSpot;
        if (old != spot) {
            this.myLabelSpot = spot;
            this.update(2403, old, null);
            if (!undoing) {
                this.layoutChildren(null);
            }
        }
    }

    public int getCollapsedLabelSpot() {
        return this.myCollapsedLabelSpot;
    }

    public void setCollapsedLabelSpot(int value) {
        this.setCollapsedLabelSpot(value, false);
    }

    private void setCollapsedLabelSpot(int spot, boolean undoing) {
        int old = this.myCollapsedLabelSpot;
        if (old != spot) {
            this.myCollapsedLabelSpot = spot;
            this.update(2408, old, null);
            if (!undoing) {
                this.layoutChildren(null);
            }
        }
    }

    public boolean isExpanded() {
        return this.getState() == 0;
    }

    protected int getState() {
        return this.myState;
    }

    protected void setState(int value) {
        int old = this.myState;
        if (old != value) {
            this.myState = value;
            Rectangle r = this.getBoundingRect();
            this.update(2413, old, new Rectangle(r.x, r.y, r.width, r.height));
        }
    }

    public void setCollapsible(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x20000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x20000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFDFFFF);
            }
            this.update(2405, old ? 1 : 0, null);
        }
    }

    public boolean isCollapsible() {
        return (this.getInternalFlags() & 0x20000) != 0;
    }

    void setExpandedResizable(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x40000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x40000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFBFFFF);
            }
            this.update(2417, old ? 1 : 0, null);
        }
    }

    boolean isExpandedResizable() {
        return (this.getInternalFlags() & 0x40000) != 0;
    }

    void setWasExpanded(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x80000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x80000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFF7FFFF);
            }
            this.update(2416, old ? 1 : 0, null);
        }
    }

    boolean isWasExpanded() {
        return (this.getInternalFlags() & 0x80000) != 0;
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2414: 
            case 2415: {
                JGoDocumentChangedEdit before;
                if (!e.isBeforeChanging() && (before = e.findBeforeChangingEdit()) != null) {
                    e.setOldValue(before.getNewValue());
                }
                return;
            }
        }
        super.copyOldValueForUndo(e);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2413: {
                e.setNewValueInt(this.getState());
                return;
            }
            case 2401: {
                e.setNewValue(this.getBackgroundColor());
                return;
            }
            case 2402: {
                e.setNewValue(this.getBorderPen());
                return;
            }
            case 2403: {
                e.setNewValueInt(this.getLabelSpot());
                return;
            }
            case 2405: {
                e.setNewValueBoolean(this.isCollapsible());
                return;
            }
            case 2406: {
                Insets s = this.getInsets();
                e.setNewValue(new Insets(s.top, s.left, s.bottom, s.right));
                return;
            }
            case 2407: {
                e.setNewValue(new Double(this.getOpacity()));
                return;
            }
            case 2408: {
                e.setNewValueInt(this.getCollapsedLabelSpot());
                return;
            }
            case 2409: {
                Insets s = this.getCollapsedInsets();
                e.setNewValue(new Insets(s.top, s.left, s.bottom, s.right));
                return;
            }
            case 2410: {
                e.setNewValue(this.getCollapsedObject());
                return;
            }
            case 2411: {
                e.setNewValue(this.getLabel());
                return;
            }
            case 2412: {
                e.setNewValue(this.getPort());
                return;
            }
            case 2414: {
                e.setNewValue(this.getSavedBounds().clone());
                return;
            }
            case 2415: {
                e.setNewValue(this.getSavedPaths().clone());
                return;
            }
            case 2417: {
                e.setNewValueBoolean(this.isExpandedResizable());
                return;
            }
            case 2416: {
                e.setNewValueBoolean(this.isWasExpanded());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 2413: {
                this.setState(e.getValueInt(undo));
                return;
            }
            case 2401: {
                this.setBackgroundColor((Color)e.getValue(undo));
                return;
            }
            case 2402: {
                this.setBorderPen((JGoPen)e.getValue(undo));
                return;
            }
            case 2403: {
                this.setLabelSpot(e.getValueInt(undo), true);
                return;
            }
            case 2405: {
                this.setCollapsible(e.getValueBoolean(undo));
                return;
            }
            case 2406: {
                this.setInsets((Insets)e.getValue(undo));
                return;
            }
            case 2407: {
                this.setOpacity(e.getValueDouble(undo));
                return;
            }
            case 2408: {
                this.setCollapsedLabelSpot(e.getValueInt(undo), true);
                return;
            }
            case 2409: {
                this.setCollapsedInsets((Insets)e.getValue(undo));
                return;
            }
            case 2410: {
                this.setCollapsedObject((JGoObject)e.getValue(undo));
                return;
            }
            case 2411: {
                this.setLabel((JGoText)e.getValue(undo));
                return;
            }
            case 2412: {
                this.setPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2414: {
                HashMap ht = (HashMap)e.getValue(undo);
                if (ht != null) {
                    this.myBoundsHashtable = (HashMap)ht.clone();
                } else {
                    this.myBoundsHashtable.clear();
                }
                return;
            }
            case 2415: {
                HashMap ht = (HashMap)e.getValue(undo);
                if (ht != null) {
                    this.myPathsHashtable = (HashMap)ht.clone();
                } else {
                    this.myPathsHashtable.clear();
                }
                return;
            }
            case 2417: {
                this.setExpandedResizable(e.getValueBoolean(undo));
                return;
            }
            case 2416: {
                this.setWasExpanded(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("subgraphlabel")) {
            this.myLabel = (JGoText)referencedObject;
        } else if (attr.equals("subgraphhandle")) {
            this.myHandle = (JGoSubGraphHandle)referencedObject;
        } else if (attr.equals("subgraphport")) {
            this.myPort = (JGoPort)referencedObject;
        } else if (attr.equals("collapsedobject")) {
            this.myCollapsedObject = (JGoObject)referencedObject;
        } else if (attr.equals("borderpen")) {
            this.myBorderPen = (JGoPen)referencedObject;
        } else if (attr.equals("hashtableobjs")) {
            Integer minIntegerKey = null;
            Iterator it = this.getSavedBounds().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (!(pair.getKey() instanceof Integer)) continue;
                Integer key = (Integer)pair.getKey();
                if (minIntegerKey != null && key >= minIntegerKey) continue;
                minIntegerKey = key;
            }
            if (minIntegerKey != null) {
                Rectangle r = (Rectangle)this.getSavedBounds().get(minIntegerKey);
                this.getSavedBounds().remove(minIntegerKey);
                this.getSavedBounds().put(referencedObject, r);
            }
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoSubGraph = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoSubGraph", jGoElementGroup);
            jGoSubGraph.setAttribute("labelspot", Integer.toString(this.myLabelSpot));
            jGoSubGraph.setAttribute("collapsedlabelspot", Integer.toString(this.myCollapsedLabelSpot));
            if (this.myBackgroundColor != null) {
                int nRed = this.myBackgroundColor.getRed();
                int nGreen = this.myBackgroundColor.getGreen();
                int nBlue = this.myBackgroundColor.getBlue();
                int nAlpha = this.myBackgroundColor.getAlpha();
                String sColor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ")";
                jGoSubGraph.setAttribute("backgroundcolor", sColor);
            }
            jGoSubGraph.setAttribute("opacity", Double.toString(this.getOpacity()));
            jGoSubGraph.setAttribute("expanded", this.isExpanded() ? "true" : "false");
            jGoSubGraph.setAttribute("wasexpanded", this.isWasExpanded() ? "true" : "false");
            jGoSubGraph.setAttribute("expandedresizable", this.isExpandedResizable() ? "true" : "false");
            jGoSubGraph.setAttribute("collapsible", this.isCollapsible() ? "true" : "false");
            jGoSubGraph.setAttribute("insets_top", Integer.toString(this.getInsets().top));
            jGoSubGraph.setAttribute("insets_left", Integer.toString(this.getInsets().left));
            jGoSubGraph.setAttribute("insets_bottom", Integer.toString(this.getInsets().bottom));
            jGoSubGraph.setAttribute("insets_right", Integer.toString(this.getInsets().right));
            jGoSubGraph.setAttribute("collapsed_insets_top", Integer.toString(this.getCollapsedInsets().top));
            jGoSubGraph.setAttribute("collapsed_insets_left", Integer.toString(this.getCollapsedInsets().left));
            jGoSubGraph.setAttribute("collapsed_insets_bottom", Integer.toString(this.getCollapsedInsets().bottom));
            jGoSubGraph.setAttribute("collapsed_insets_right", Integer.toString(this.getCollapsedInsets().right));
            if (this.myLabel != null) {
                svgDoc.registerReferencingNode(jGoSubGraph, "subgraphlabel", this.myLabel);
            }
            if (this.myHandle != null) {
                svgDoc.registerReferencingNode(jGoSubGraph, "subgraphhandle", this.myHandle);
            }
            if (this.myPort != null) {
                svgDoc.registerReferencingNode(jGoSubGraph, "subgraphport", this.myPort);
            }
            if (this.myCollapsedObject != null) {
                svgDoc.registerReferencingNode(jGoSubGraph, "collapsedobject", this.myCollapsedObject);
            }
            if (this.myBorderPen != null) {
                if (!svgDoc.isRegisteredReference(this.myBorderPen)) {
                    jGoSubGraph.setAttribute("embeddedborderpen", "true");
                    DomElement subGroup = svgDoc.createElement("g");
                    jGoSubGraph.appendChild(subGroup);
                    this.myBorderPen.SVGWriteObject(svgDoc, subGroup);
                }
                svgDoc.registerReferencingNode(jGoSubGraph, "borderpen", this.myBorderPen);
            }
            String xPoints = "";
            String yPoints = "";
            String wDimensions = "";
            String hDimensions = "";
            Iterator it = this.getSavedBounds().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                JGoObject obj = (JGoObject)pair.getKey();
                Rectangle r = (Rectangle)pair.getValue();
                svgDoc.registerReferencingNode(jGoSubGraph, "hashtableobjs", obj);
                if (xPoints.length() > 0) {
                    xPoints = xPoints + " ";
                    yPoints = yPoints + " ";
                    wDimensions = wDimensions + " ";
                    hDimensions = hDimensions + " ";
                }
                xPoints = xPoints + Integer.toString(r.x);
                yPoints = yPoints + Integer.toString(r.y);
                wDimensions = wDimensions + Integer.toString(r.width);
                hDimensions = hDimensions + Integer.toString(r.height);
            }
            if (xPoints.length() > 0) {
                jGoSubGraph.setAttribute("xpoints", xPoints);
                jGoSubGraph.setAttribute("ypoints", yPoints);
                jGoSubGraph.setAttribute("wdimensions", wDimensions);
                jGoSubGraph.setAttribute("hdimensions", hDimensions);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String collapsed_insets_right;
            String collapsed_insets_bottom;
            String collapsed_insets_left;
            String collapsed_insets_top;
            String insets_right;
            String insets_bottom;
            String insets_left;
            String insets_top;
            String s;
            String opacity;
            String sColor;
            this.myLabelSpot = Integer.parseInt(jGoChildElement.getAttribute("labelspot"));
            String sCollapsedLabelSpot = jGoChildElement.getAttribute("collapsedlabelspot");
            if (sCollapsedLabelSpot.length() > 0) {
                this.myCollapsedLabelSpot = Integer.parseInt(sCollapsedLabelSpot);
            }
            if ((sColor = jGoChildElement.getAttribute("backgroundcolor")).length() > 0 && sColor.startsWith("rgbalpha")) {
                int nAttStart = sColor.indexOf("(") + 1;
                int nAttEnd = sColor.indexOf(",", nAttStart);
                String red = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(",", nAttStart);
                String green = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(",", nAttStart);
                String blue = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(")", nAttStart);
                String alpha = sColor.substring(nAttStart, nAttEnd);
                this.myBackgroundColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
            }
            if ((opacity = svgElement.getAttribute("opacity")).length() > 0) {
                this.myOpacity = Double.parseDouble(opacity);
            }
            if ((s = svgElement.getAttribute("expanded")).length() > 0) {
                this.setState(s.equals("true") ? 0 : 1);
            }
            if ((s = svgElement.getAttribute("wasexpanded")).length() > 0) {
                this.setWasExpanded(s.equals("true"));
            }
            if ((s = svgElement.getAttribute("expandedresizable")).length() > 0) {
                this.setExpandedResizable(s.equals("true"));
            }
            if ((s = svgElement.getAttribute("collapsible")).length() > 0) {
                this.setCollapsible(s.equals("true"));
            }
            if ((insets_top = svgElement.getAttribute("insets_top")).length() > 0) {
                this.myInsets.top = Integer.parseInt(insets_top);
            }
            if ((insets_left = svgElement.getAttribute("insets_left")).length() > 0) {
                this.myInsets.left = Integer.parseInt(insets_left);
            }
            if ((insets_bottom = svgElement.getAttribute("insets_bottom")).length() > 0) {
                this.myInsets.bottom = Integer.parseInt(insets_bottom);
            }
            if ((insets_right = svgElement.getAttribute("insets_right")).length() > 0) {
                this.myInsets.right = Integer.parseInt(insets_right);
            }
            if ((collapsed_insets_top = svgElement.getAttribute("collapsed_insets_top")).length() > 0) {
                this.myCollapsedInsets.top = Integer.parseInt(collapsed_insets_top);
            }
            if ((collapsed_insets_left = svgElement.getAttribute("collapsed_insets_left")).length() > 0) {
                this.myCollapsedInsets.left = Integer.parseInt(collapsed_insets_left);
            }
            if ((collapsed_insets_bottom = svgElement.getAttribute("collapsed_insets_bottom")).length() > 0) {
                this.myCollapsedInsets.bottom = Integer.parseInt(collapsed_insets_bottom);
            }
            if ((collapsed_insets_right = svgElement.getAttribute("collapsed_insets_right")).length() > 0) {
                this.myCollapsedInsets.right = Integer.parseInt(collapsed_insets_right);
            }
            String subgraphlabel = jGoChildElement.getAttribute("subgraphlabel");
            svgDoc.registerReferencingObject(this, "subgraphlabel", subgraphlabel);
            String subgraphhandle = jGoChildElement.getAttribute("subgraphhandle");
            svgDoc.registerReferencingObject(this, "subgraphhandle", subgraphhandle);
            String subgraphport = jGoChildElement.getAttribute("subgraphport");
            svgDoc.registerReferencingObject(this, "subgraphport", subgraphport);
            String collapsedobject = jGoChildElement.getAttribute("collapsedobject");
            svgDoc.registerReferencingObject(this, "collapsedobject", collapsedobject);
            if (jGoChildElement.getAttribute("embeddedborderpen").equals("true")) {
                svgDoc.SVGTraverseChildren(jGoDoc, jGoChildElement, null, false);
            }
            String borderpen = jGoChildElement.getAttribute("borderpen");
            svgDoc.registerReferencingObject(this, "borderpen", borderpen);
            String sHashTableObjs = jGoChildElement.getAttribute("hashtableobjs");
            while (sHashTableObjs.length() > 0) {
                int nEnd = sHashTableObjs.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = sHashTableObjs.length();
                }
                String sHashTableObj = sHashTableObjs.substring(0, nEnd);
                sHashTableObjs = nEnd >= sHashTableObjs.length() ? "" : sHashTableObjs.substring(nEnd + 1);
                svgDoc.registerReferencingObject(this, "hashtableobjs", sHashTableObj);
            }
            int i = 0;
            String xPoints = jGoChildElement.getAttribute("xpoints");
            String yPoints = jGoChildElement.getAttribute("ypoints");
            String wDimensions = jGoChildElement.getAttribute("wdimensions");
            String hDimensions = jGoChildElement.getAttribute("hdimensions");
            while (xPoints.length() > 0 && yPoints.length() > 0) {
                int nEnd = xPoints.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = xPoints.length();
                }
                String sX = xPoints.substring(0, nEnd);
                xPoints = nEnd >= xPoints.length() ? "" : xPoints.substring(nEnd + 1);
                nEnd = yPoints.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = yPoints.length();
                }
                String sY = yPoints.substring(0, nEnd);
                yPoints = nEnd >= yPoints.length() ? "" : yPoints.substring(nEnd + 1);
                nEnd = wDimensions.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = wDimensions.length();
                }
                String sW = wDimensions.substring(0, nEnd);
                wDimensions = nEnd >= wDimensions.length() ? "" : wDimensions.substring(nEnd + 1);
                nEnd = hDimensions.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = hDimensions.length();
                }
                String sH = hDimensions.substring(0, nEnd);
                hDimensions = nEnd >= hDimensions.length() ? "" : hDimensions.substring(nEnd + 1);
                Rectangle r = new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), Integer.parseInt(sW), Integer.parseInt(sH));
                this.getSavedBounds().put(new Integer(i++), r);
            }
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }
}

