/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class JGoSelection
implements JGoObjectSimpleCollection,
Transferable,
Serializable {
    private JGoObjList mySelectedObjects = new JGoObjList();
    private HashMap myHandles = new HashMap();
    private transient JGoView myView = null;
    private JGoPen myBoundingHandlePen = null;
    private JGoPen myResizeHandlePen = JGoPen.black;
    private JGoBrush myResizeHandleBrush = null;
    private boolean myResizeHandleSizeInViewCoords = false;

    public JGoSelection() {
        this.myView = null;
    }

    public JGoSelection(JGoView view) {
        this.myView = view;
    }

    public final JGoView getView() {
        return this.myView;
    }

    public int getNumObjects() {
        return this.mySelectedObjects.getNumObjects();
    }

    public boolean isEmpty() {
        return this.mySelectedObjects.isEmpty();
    }

    public JGoListPosition getFirstObjectPos() {
        return this.mySelectedObjects.getFirstObjectPos();
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        return this.mySelectedObjects.getObjectAtPos(pos);
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        return this.mySelectedObjects.getNextObjectPos(pos);
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition pos) {
        return this.mySelectedObjects.getNextObjectPos(pos);
    }

    public JGoObject getPrimarySelection() {
        JGoListPosition pos = this.mySelectedObjects.getFirstObjectPos();
        if (pos == null) {
            return null;
        }
        return this.mySelectedObjects.getObjectAtPos(pos);
    }

    public JGoObject selectObject(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (this.getPrimarySelection() == obj && this.getNumObjects() == 1) {
            return obj;
        }
        this.clearSelection();
        return this.extendSelection(obj);
    }

    public JGoObject extendSelection(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if ((obj = obj.redirectSelection()) == null) {
            return null;
        }
        if (!this.isSelected(obj)) {
            this.addToSelection(obj);
        }
        return obj;
    }

    public JGoObject toggleSelection(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if ((obj = obj.redirectSelection()) == null) {
            return null;
        }
        if (this.isSelected(obj)) {
            this.removeFromSelection(obj);
        } else {
            this.addToSelection(obj);
        }
        return obj;
    }

    public void clearSelection(JGoObject obj) {
        if (obj == null) {
            this.clearSelection();
            return;
        }
        if ((obj = obj.redirectSelection()) == null) {
            return;
        }
        if (this.isSelected(obj)) {
            this.removeFromSelection(obj);
        }
    }

    public void clearSelection() {
        JGoView view = this.getView();
        JGoListPosition pos = this.mySelectedObjects.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.mySelectedObjects.getObjectAtPos(pos);
            this.mySelectedObjects.removeObjectAtPos(pos);
            obj.lostSelection(this);
            if (view != null) {
                view.fireUpdate(21, 0, obj);
            }
            this.myHandles.remove(obj);
            pos = this.mySelectedObjects.getFirstObjectPos();
        }
    }

    public boolean isInSelection(JGoObject obj) {
        if (obj == null) {
            return false;
        }
        if ((obj = obj.redirectSelection()) == null) {
            return false;
        }
        return this.isSelected(obj);
    }

    public boolean isSelected(JGoObject obj) {
        return this.myHandles.containsKey(obj);
    }

    private void addToSelection(JGoObject obj) {
        JGoView view = this.getView();
        if (view != null && obj.getView() != view && obj.getDocument() != view.getDocument()) {
            return;
        }
        this.mySelectedObjects.addObjectAtTail(obj);
        this.myHandles.put(obj, null);
        obj.gainedSelection(this);
        if (view != null) {
            view.fireUpdate(20, 0, obj);
        }
    }

    private void removeFromSelection(JGoObject obj) {
        JGoObject primary = this.getPrimarySelection();
        this.mySelectedObjects.removeObject(obj);
        JGoView view = this.getView();
        obj.lostSelection(this);
        if (view != null) {
            view.fireUpdate(21, 0, obj);
        }
        this.myHandles.remove(obj);
        if (primary == obj && (primary = this.getPrimarySelection()) != null) {
            primary.lostSelection(this);
            if (view != null) {
                view.fireUpdate(21, 1, primary);
            }
            primary.gainedSelection(this);
            if (view != null) {
                view.fireUpdate(20, 1, primary);
            }
        }
    }

    public void clearSelectionHandles(JGoObject obj) {
        if (obj != null) {
            obj.hideSelectionHandles(this);
        } else {
            JGoListPosition pos = this.mySelectedObjects.getFirstObjectPos();
            while (pos != null) {
                obj = this.mySelectedObjects.getObjectAtPos(pos);
                pos = this.mySelectedObjects.getNextObjectPos(pos);
                obj.hideSelectionHandles(this);
            }
        }
    }

    public void restoreSelectionHandles(JGoObject obj) {
        if (obj != null) {
            if (this.isSelected(obj) && obj.isVisible()) {
                obj.showSelectionHandles(this);
            }
        } else {
            JGoListPosition pos = this.mySelectedObjects.getFirstObjectPos();
            while (pos != null) {
                obj = this.mySelectedObjects.getObjectAtPos(pos);
                pos = this.mySelectedObjects.getNextObjectPos(pos);
                if (!obj.isVisible()) continue;
                obj.showSelectionHandles(this);
            }
        }
    }

    public void showHandles(JGoObject obj) {
        Object something = this.myHandles.get(obj);
        if (something == null) {
            return;
        }
        JGoView view = this.getView();
        if (view != null) {
            if (something instanceof ArrayList) {
                ArrayList vec = (ArrayList)something;
                for (int i = 0; i < vec.size(); ++i) {
                    JGoHandle h = (JGoHandle)vec.get(i);
                    h.setVisible(true);
                }
            } else {
                JGoHandle h = (JGoHandle)something;
                h.setVisible(true);
            }
        }
    }

    public void hideHandles(JGoObject obj) {
        Object something = this.myHandles.get(obj);
        if (something == null) {
            return;
        }
        JGoView view = this.getView();
        if (view != null) {
            if (something instanceof ArrayList) {
                ArrayList vec = (ArrayList)something;
                for (int i = 0; i < vec.size(); ++i) {
                    JGoHandle h = (JGoHandle)vec.get(i);
                    h.setVisible(false);
                }
            } else {
                JGoHandle h = (JGoHandle)something;
                h.setVisible(false);
            }
        }
    }

    public JGoHandle createBoundingHandle(JGoObject obj) {
        JGoView view = this.getView();
        Rectangle rect = view != null ? view.getTempRectangle() : new Rectangle(0, 0, 0, 0);
        Rectangle b = obj.getBoundingRect();
        rect.x = b.x;
        rect.y = b.y;
        rect.width = b.width;
        rect.height = b.height;
        --rect.x;
        --rect.y;
        rect.width += 2;
        rect.height += 2;
        JGoHandle handle = new JGoHandle(rect, 0);
        handle.setHandleType(-1);
        handle.setSelectable(false);
        Color sel_color = view != null ? (this.getPrimarySelection() == obj ? view.getPrimarySelectionColor() : view.getSecondarySelectionColor()) : JGoBrush.ColorBlack;
        if (this.myBoundingHandlePen == null || !this.myBoundingHandlePen.getColor().equals(sel_color)) {
            this.myBoundingHandlePen = JGoPen.make(65535, 2, sel_color);
        }
        handle.setPen(this.myBoundingHandlePen);
        handle.setBrush(null);
        this.addHandle(obj, handle);
        return handle;
    }

    public boolean isResizeHandleSizeInViewCoords() {
        return this.myResizeHandleSizeInViewCoords;
    }

    public void setResizeHandleSizeInViewCoords(boolean b) {
        this.myResizeHandleSizeInViewCoords = b;
    }

    public JGoHandle allocateResizeHandle(JGoObject obj, int x, int y, int handleType) {
        JGoView view = this.getView();
        Rectangle rect = view != null ? view.getTempRectangle() : new Rectangle(0, 0, 0, 0);
        rect.width = JGoHandle.getDefaultHandleWidth();
        rect.height = JGoHandle.getDefaultHandleHeight();
        if (this.isResizeHandleSizeInViewCoords() && view != null && view.getScale() != 1.0) {
            Dimension dim = view.getTempDimension();
            dim.width = rect.width;
            dim.height = rect.height;
            view.convertViewToDoc(dim);
            rect.width = dim.width;
            if (rect.width < 2) {
                rect.width = 2;
            }
            rect.height = dim.height;
            if (rect.height < 2) {
                rect.height = 2;
            }
        }
        rect.x = x - rect.width / 2;
        rect.y = y - rect.height / 2;
        JGoHandle handle = new JGoHandle(rect, 0);
        return handle;
    }

    public JGoHandle createResizeHandle(JGoObject obj, int x, int y, int handleType, boolean filled) {
        JGoView view = this.getView();
        JGoHandle handle = this.allocateResizeHandle(obj, x, y, handleType);
        handle.setHandleType(handleType);
        if (handleType == -1) {
            handle.setSelectable(false);
        } else {
            handle.setSelectable(true);
        }
        Color sel_color = view != null ? (this.getPrimarySelection() == obj ? view.getPrimarySelectionColor() : view.getSecondarySelectionColor()) : JGoBrush.ColorBlack;
        if (filled) {
            handle.setPen(this.myResizeHandlePen);
            if (this.myResizeHandleBrush == null || !this.myResizeHandleBrush.getColor().equals(sel_color)) {
                this.myResizeHandleBrush = JGoBrush.make(65535, sel_color);
            }
            handle.setBrush(this.myResizeHandleBrush);
        } else {
            if (this.myBoundingHandlePen == null || !this.myBoundingHandlePen.getColor().equals(sel_color)) {
                this.myBoundingHandlePen = JGoPen.make(65535, 2, sel_color);
            }
            handle.setPen(this.myBoundingHandlePen);
            handle.setBrush(null);
        }
        this.addHandle(obj, handle);
        return handle;
    }

    public void addHandle(JGoObject obj, JGoHandle handle) {
        handle.setHandleFor(obj);
        Object something = this.myHandles.get(obj);
        if (something == null) {
            this.myHandles.put(obj, handle);
        } else if (something instanceof ArrayList) {
            ArrayList vec = (ArrayList)something;
            vec.add(handle);
        } else {
            ArrayList<Object> vec = new ArrayList<Object>();
            vec.add(something);
            vec.add(handle);
            this.myHandles.put(obj, vec);
        }
        if (this.getView() != null) {
            this.getView().addObjectAtHead(handle);
        }
    }

    public void deleteHandles(JGoObject obj) {
        Object something = this.myHandles.get(obj);
        if (something == null) {
            return;
        }
        JGoView view = this.getView();
        if (view != null) {
            if (something instanceof ArrayList) {
                ArrayList vec = (ArrayList)something;
                for (int i = 0; i < vec.size(); ++i) {
                    JGoHandle h = (JGoHandle)vec.get(i);
                    view.removeObject(h);
                }
            } else {
                JGoHandle h = (JGoHandle)something;
                view.removeObject(h);
            }
        }
        this.myHandles.put(obj, null);
    }

    public int getNumHandles(JGoObject obj) {
        Object something = this.myHandles.get(obj);
        if (something == null) {
            return 0;
        }
        if (something instanceof ArrayList) {
            ArrayList vec = (ArrayList)something;
            return vec.size();
        }
        return 1;
    }

    public DataFlavor[] getTransferDataFlavors() {
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            return doc.getTransferDataFlavors();
        }
        return new DataFlavor[0];
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            return doc.isDataFlavorSupported(f);
        }
        return false;
    }

    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(f)) {
            return this;
        }
        throw new UnsupportedFlavorException(f);
    }

    private JGoDocument getDocument() {
        JGoDocument doc = null;
        if (this.getView() != null) {
            doc = this.getView().getDocument();
        } else {
            JGoListPosition pos = this.mySelectedObjects.getFirstObjectPos();
            while (pos != null) {
                JGoObject temp = this.mySelectedObjects.getObjectAtPos(pos);
                pos = this.mySelectedObjects.getNextObjectPos(pos);
                doc = temp.getDocument();
                if (doc != null) break;
                JGoView view = temp.getView();
                if (view != null) {
                    doc = view.getDocument();
                }
                if (doc == null) continue;
                break;
            }
        }
        return doc;
    }
}

