/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class JGoScrollBar
extends JGoControl {
    public static final int ChangedScrollBar = 1002;
    public static final int ChangedScrollBarValue = 1003;
    public static final int ChangedScrollBarVertical = 1004;
    private boolean myVertical = true;
    private int myValue = 0;
    private int myExtent = 10;
    private int myMinimum = 0;
    private int myMaximum = 100;
    private int myUnitIncrement = 1;
    private int myBlockIncrement = 9;
    private transient boolean myValueChanging = false;

    public JGoScrollBar() {
    }

    public JGoScrollBar(Rectangle rect, boolean vertical) {
        super(rect);
        this.myVertical = vertical;
    }

    public JGoScrollBar(Point location, Dimension size, boolean vertical) {
        super(location, size);
        this.myVertical = vertical;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoScrollBar newobj = (JGoScrollBar)super.copyObject(env);
        if (newobj != null) {
            newobj.myVertical = this.myVertical;
            newobj.myValue = this.myValue;
            newobj.myExtent = this.myExtent;
            newobj.myMinimum = this.myMinimum;
            newobj.myMaximum = this.myMaximum;
            newobj.myUnitIncrement = this.myUnitIncrement;
            newobj.myBlockIncrement = this.myBlockIncrement;
        }
        return newobj;
    }

    public JComponent createComponent(JGoView view) {
        JScrollBar sbar = new JScrollBar(this.isVertical() ? 1 : 0);
        sbar.setValues(this.getValue(), this.getExtent(), this.getMinimum(), this.getMaximum());
        sbar.addAdjustmentListener(new JSBListener(this, view));
        new DropTarget(sbar, new JSBDTListener(sbar, view));
        return sbar;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    public void setVertical(boolean v) {
        boolean oldVertical = this.myVertical;
        if (oldVertical != v) {
            this.myVertical = v;
            this.myValueChanging = true;
            Iterator it = this.getIterator();
            while (it.hasNext()) {
                Map.Entry pair = (Map.Entry)it.next();
                JGoView view = (JGoView)pair.getKey();
                JScrollBar sbar = (JScrollBar)pair.getValue();
                sbar.setOrientation(this.isVertical() ? 1 : 0);
                view.getCanvas().validate();
            }
            this.myValueChanging = false;
            this.update(1004, oldVertical ? 1 : 0, null);
        }
    }

    public void setValues(int val, int ext, int min, int max, int unit, int block) {
        if (this.getValue() != val || this.getExtent() != ext || this.getMinimum() != min || this.getMaximum() != max || this.getUnitIncrement() != unit || this.getBlockIncrement() != block) {
            int oldValue = this.getValue();
            int[] oldvals = new int[]{oldValue, this.getExtent(), this.getMinimum(), this.getMaximum(), this.getUnitIncrement(), this.getBlockIncrement()};
            this.setValuesInternal(val, ext, min, max, unit, block);
            this.update(1002, 0, oldvals);
            JGoArea parent = this.getParent();
            if (parent != null) {
                parent.update(1003, oldValue, null);
            }
        }
    }

    private void setValuesInternal(int val, int ext, int min, int max, int unit, int block) {
        this.myValue = val;
        this.myExtent = ext;
        this.myMinimum = min;
        this.myMaximum = max;
        this.myValueChanging = true;
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            JGoView view = (JGoView)pair.getKey();
            JScrollBar sbar = (JScrollBar)pair.getValue();
            sbar.setValues(val, ext, min, max);
            sbar.setUnitIncrement(unit);
            sbar.setBlockIncrement(block);
            view.getCanvas().validate();
        }
        this.myValueChanging = false;
    }

    public int getValue() {
        return this.myValue;
    }

    public void setValue(int newvalue) {
        int oldValue = this.getValue();
        if (oldValue != newvalue) {
            this.myValue = newvalue;
            this.setValueInternal(newvalue);
            this.update(1003, oldValue, null);
            JGoArea parent = this.getParent();
            if (parent != null) {
                parent.update(1003, oldValue, null);
            }
        }
    }

    private void setValueInternal(int newvalue) {
        this.myValueChanging = true;
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            JGoView view = (JGoView)pair.getKey();
            JScrollBar sbar = (JScrollBar)pair.getValue();
            if (sbar.getValue() == newvalue) continue;
            sbar.setValue(newvalue);
            view.getCanvas().validate();
        }
        this.myValueChanging = false;
    }

    public int getExtent() {
        return this.myExtent;
    }

    public int getMinimum() {
        return this.myMinimum;
    }

    public int getMaximum() {
        return this.myMaximum;
    }

    public int getUnitIncrement() {
        return this.myUnitIncrement;
    }

    public int getBlockIncrement() {
        return this.myBlockIncrement;
    }

    public void valueChanged(int newvalue, JGoView view) {
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        this.setValue(newvalue);
        if (doc != null) {
            doc.endTransaction(view.getEditPresentationName(12));
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 1002: {
                int[] newvals = new int[]{this.getValue(), this.getExtent(), this.getMinimum(), this.getMaximum(), this.getUnitIncrement(), this.getBlockIncrement()};
                e.setNewValue(newvals);
                return;
            }
            case 1003: {
                e.setNewValueInt(this.getValue());
                return;
            }
            case 1004: {
                e.setNewValueBoolean(this.isVertical());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 1002: {
                int[] vals = undo ? (int[])e.getOldValue() : (int[])e.getNewValue();
                this.setValuesInternal(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
                return;
            }
            case 1003: {
                this.setValueInternal(e.getValueInt(undo));
                return;
            }
            case 1004: {
                this.setVertical(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoScrollBar = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoScrollBar", jGoElementGroup);
            jGoScrollBar.setAttribute("vertical", this.myVertical ? "true" : "false");
            jGoScrollBar.setAttribute("value", Integer.toString(this.myValue));
            jGoScrollBar.setAttribute("extent", Integer.toString(this.myExtent));
            jGoScrollBar.setAttribute("minimum", Integer.toString(this.myMinimum));
            jGoScrollBar.setAttribute("maximum", Integer.toString(this.myMaximum));
            jGoScrollBar.setAttribute("unitincrement", Integer.toString(this.myUnitIncrement));
            jGoScrollBar.setAttribute("blockincrement", Integer.toString(this.myBlockIncrement));
        }
        DomElement element = svgDoc.createElement("rect");
        this.SVGWriteAttributes(element);
        jGoElementGroup.appendChild(element);
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            this.myVertical = jGoChildElement.getAttribute("vertical").equals("true");
            this.myValue = Integer.parseInt(jGoChildElement.getAttribute("value"));
            this.myExtent = Integer.parseInt(jGoChildElement.getAttribute("extent"));
            this.myMinimum = Integer.parseInt(jGoChildElement.getAttribute("minimum"));
            this.myMaximum = Integer.parseInt(jGoChildElement.getAttribute("maximum"));
            this.myUnitIncrement = Integer.parseInt(jGoChildElement.getAttribute("unitincrement"));
            this.myBlockIncrement = Integer.parseInt(jGoChildElement.getAttribute("blockincrement"));
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        svgElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        svgElement.setAttribute("width", Integer.toString(this.getWidth()));
        svgElement.setAttribute("height", Integer.toString(this.getHeight()));
        svgElement.setAttribute("style", "stroke:black;stroke-width:1;fill:none");
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String nX = svgElement.getAttribute("x");
        String nY = svgElement.getAttribute("y");
        this.setTopLeft(new Point(Integer.parseInt(nX), Integer.parseInt(nY)));
        String nWidth = svgElement.getAttribute("width");
        String nHeight = svgElement.getAttribute("height");
        this.setWidth(Integer.parseInt(nWidth));
        this.setHeight(Integer.parseInt(nHeight));
    }

    static class JSBDTListener
    implements DropTargetListener {
        JComponent comp;
        JGoView view;

        JSBDTListener(JComponent o, JGoView v) {
            this.comp = o;
            this.view = v;
        }

        public void dragEnter(DropTargetDragEvent e) {
            this.view.onDragEnter(this.makeDragEvent(e));
        }

        public void dragOver(DropTargetDragEvent e) {
            this.view.onDragOver(this.makeDragEvent(e));
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            this.view.onDropActionChanged(this.makeDragEvent(e));
        }

        public void dragExit(DropTargetEvent e) {
            this.view.onDragExit(e);
        }

        public void drop(DropTargetDropEvent e) {
            this.view.onDrop(this.makeDropEvent(e));
        }

        DropTargetDragEvent makeDragEvent(DropTargetDragEvent e) {
            return new DropTargetDragEvent(e.getDropTargetContext(), this.adjustPoint(e.getLocation()), e.getDropAction(), e.getSourceActions());
        }

        DropTargetDropEvent makeDropEvent(DropTargetDropEvent e) {
            return new DropTargetDropEvent(e.getDropTargetContext(), this.adjustPoint(e.getLocation()), e.getDropAction(), e.getSourceActions());
        }

        Point adjustPoint(Point orig) {
            Point viewPnt = this.comp.getLocationOnScreen();
            Point viewLoc = this.view.getCanvas().getLocationOnScreen();
            return new Point(viewPnt.x - viewLoc.x + orig.x, viewPnt.y - viewLoc.y + orig.y);
        }
    }

    static class JSBListener
    implements AdjustmentListener {
        JGoScrollBar bar;
        JGoView view;

        JSBListener(JGoScrollBar b, JGoView v) {
            this.bar = b;
            this.view = v;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!this.bar.myValueChanging && e.getAdjustmentType() == 5) {
                int newvalue = e.getValue();
                this.bar.valueChanged(newvalue, this.view);
            }
        }
    }
}

