/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;

public class JGoPrintPreview
extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected int m_orientation;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;
    protected PageFormat m_pageFormat;
    protected int m_pageCount;

    public JGoPrintPreview(Printable target, String title, PageFormat pf, int pageCount) {
        super(title);
        this.m_pageFormat = pf;
        this.m_pageCount = pageCount;
        this.setSize(600, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_target = target;
        JToolBar tb = new JToolBar();
        JButton bt = new JButton("Print", new ImageIcon("print.gif"));
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    public void run() {
                        try {
                            PrinterJob prnJob = PrinterJob.getPrinterJob();
                            Book book = new Book();
                            book.append((this).JGoPrintPreview.this.m_target, (this).JGoPrintPreview.this.m_pageFormat, (this).JGoPrintPreview.this.m_pageCount);
                            prnJob.setPageable(book);
                            if (!prnJob.printDialog()) {
                                return;
                            }
                            JGoPrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                            prnJob.print();
                            JGoPrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                            JGoPrintPreview.this.dispose();
                        }
                        catch (PrinterException ex) {
                            ex.printStackTrace();
                            System.err.println("Printing error: " + ex.toString());
                        }
                    }
                };
                runner.start();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(4, 6, 4, 6));
        tb.add(bt);
        bt = new JButton("Close");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JGoPrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(scales);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    public void run() {
                        String str = (this).JGoPrintPreview.this.m_cbScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = (this).JGoPrintPreview.this.m_wPage * scale / 100;
                        int h = (this).JGoPrintPreview.this.m_hPage * scale / 100;
                        Component[] comps = (this).JGoPrintPreview.this.m_preview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        (this).JGoPrintPreview.this.m_preview.doLayout();
                        (this).JGoPrintPreview.this.m_preview.getParent().getParent().validate();
                    }
                };
                runner.start();
            }
        };
        this.m_cbScale.addActionListener(lst);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        tb.addSeparator();
        tb.add(this.m_cbScale);
        this.getContentPane().add((Component)tb, "North");
        this.m_preview = new PreviewContainer();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.m_pageFormat;
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int scale = 10;
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics2D g = (Graphics2D)img.getGraphics();
                if (this.m_target instanceof JGoView) {
                    JGoView view = (JGoView)this.m_target;
                    view.applyRenderingHints(g);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g.setColor(Color.white);
                g.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (target.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.m_preview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
        JScrollPane ps = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

