/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class JGoGlobal {
    private static double myJavaVersion = -1.0;
    private static Component myComponent = null;
    private static Graphics2D myGraphics2D = null;

    private JGoGlobal() {
    }

    public static void TRACE(String msg) {
        System.err.println(msg);
    }

    public static double getJGoVersion() {
        return 5.14;
    }

    public static boolean isJGoVersion(double version) {
        return JGoGlobal.getJGoVersion() == version;
    }

    public static boolean isAtLeastJGoVersion(double version) {
        return JGoGlobal.getJGoVersion() >= version;
    }

    public static double getJavaVersion() {
        if (myJavaVersion == -1.0) {
            try {
                myJavaVersion = JGoGlobal.convertToDouble(System.getProperty("java.version", "1.0"));
            }
            catch (SecurityException se) {
                myJavaVersion = 1.0;
            }
        }
        return myJavaVersion;
    }

    public static boolean isJavaVersion(double version) {
        return JGoGlobal.getJavaVersion() == version;
    }

    public static boolean isAtLeastJavaVersion(double version) {
        return JGoGlobal.getJavaVersion() >= version;
    }

    private static double convertToDouble(String version) {
        Double doub;
        int len = version.length();
        String tempver = "";
        boolean decimalfound = false;
        for (int pos = 0; pos < len; ++pos) {
            char ch = version.charAt(pos);
            if (Character.isDigit(ch) || ch == '.' && !decimalfound) {
                tempver = tempver + ch;
            }
            if (ch != '.') continue;
            decimalfound = true;
        }
        try {
            doub = new Double(tempver);
        }
        catch (NumberFormatException nfe) {
            doub = new Double(1.0);
        }
        return doub;
    }

    public static Component getComponent() {
        return myComponent;
    }

    public static void setComponent(Component c) {
        if (myComponent == null || !myComponent.isDisplayable()) {
            myComponent = c;
        }
    }

    public static Graphics2D getGraphics2D() {
        if (myGraphics2D == null) {
            BufferedImage image = new BufferedImage(1, 1, 1);
            myGraphics2D = image.createGraphics();
            myGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            myGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            myGraphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            myGraphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (JGoGlobal.isAtLeastJavaVersion(1.4)) {
                myGraphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
        return myGraphics2D;
    }

    public static void setup() {
        if (JGoGlobal.getComponent() == null || !JGoGlobal.getComponent().isDisplayable()) {
            JLabel f = new JLabel();
            JGoGlobal.setComponent(f);
        }
    }

    public static Toolkit getToolkit() {
        if (JGoGlobal.getComponent() != null) {
            return JGoGlobal.getComponent().getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }
}

