/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public abstract class JGoControl
extends JGoObject {
    private transient HashMap myMap = null;

    public JGoControl() {
    }

    public JGoControl(Rectangle rect) {
        super(rect);
    }

    public JGoControl(Point location, Dimension size) {
        super(location, size);
    }

    protected void ownerChange(JGoObjectCollection oldOwner, JGoObjectCollection newOwner, JGoObject mainObject) {
        super.ownerChange(oldOwner, newOwner, mainObject);
        if (oldOwner != null && newOwner == null && oldOwner instanceof JGoDocument) {
            JGoDocument olddoc = (JGoDocument)oldOwner;
            Iterator it = this.getIterator();
            while (it.hasNext()) {
                Map.Entry pair = (Map.Entry)it.next();
                JGoView view = (JGoView)pair.getKey();
                JComponent comp = (JComponent)pair.getValue();
                if (view == null || comp == null) continue;
                view.removeControl(this, comp);
            }
            this.getMap().clear();
        } else if (oldOwner == null && newOwner != null && newOwner instanceof JGoDocument && this.isVisible()) {
            JGoDocument doc = (JGoDocument)newOwner;
            JGoDocumentListener[] v = doc.getDocumentListeners();
            for (int i = 0; i < v.length; ++i) {
                JGoView view;
                JGoDocumentListener listener = v[i];
                if (!(listener instanceof JGoView) || (view = (JGoView)listener) == null) continue;
                JComponent comp = this.getComponent(view);
            }
        } else if (oldOwner != null && newOwner == null && oldOwner instanceof JGoView) {
            JComponent comp;
            JGoView oldview = (JGoView)oldOwner;
            if (this.getMap().get(oldview) != null && (comp = (JComponent)this.getMap().remove(oldview)) != null) {
                oldview.removeControl(this, comp);
            }
        } else if (oldOwner == null && newOwner != null && newOwner instanceof JGoView && this.isVisible()) {
            JGoView view = (JGoView)newOwner;
            JComponent comp = this.getComponent(view);
        }
    }

    public JComponent getComponent(JGoView view) {
        JComponent comp = (JComponent)this.getMap().get(view);
        if (comp == null && (comp = this.createComponent(view)) != null) {
            this.getMap().put(view, comp);
            view.addControl(this, comp);
            comp.setVisible(true);
            comp.repaint();
            view.getCanvas().validate();
        }
        return comp;
    }

    public abstract JComponent createComponent(JGoView var1);

    public void setVisible(boolean bFlag) {
        if (bFlag != this.isVisible()) {
            Iterator it = this.getIterator();
            while (it.hasNext()) {
                Map.Entry pair = (Map.Entry)it.next();
                JGoView view = (JGoView)pair.getKey();
                JComponent comp = (JComponent)pair.getValue();
                if (view == null) continue;
                if (bFlag && comp == null) {
                    this.getComponent(view);
                    continue;
                }
                if (bFlag || comp == null) continue;
                view.removeControl(this, comp);
                this.getMap().put(view, null);
            }
        }
        super.setVisible(bFlag);
    }

    protected void geometryChange(Rectangle prevRect) {
        super.geometryChange(prevRect);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            JGoView view = (JGoView)pair.getKey();
            JComponent comp = (JComponent)pair.getValue();
            if (view == null || comp == null) continue;
            Rectangle b = this.getBoundingRect();
            rect.x = b.x;
            rect.y = b.y;
            rect.width = b.width;
            rect.height = b.height;
            view.convertDocToView(rect);
            comp.setBounds(rect);
            comp.repaint();
            view.getCanvas().validate();
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        JComponent comp = this.getComponent(view);
        if (comp != null) {
            Rectangle rect = view.getTempRectangle();
            Rectangle b = this.getBoundingRect();
            rect.x = b.x;
            rect.y = b.y;
            rect.width = b.width;
            rect.height = b.height;
            view.convertDocToView(rect);
            if (!comp.getBounds().equals(rect)) {
                comp.setBounds(rect);
                comp.setVisible(true);
                view.getCanvas().validate();
            }
        }
    }

    public Iterator getIterator() {
        return this.getMap().entrySet().iterator();
    }

    HashMap getMap() {
        if (this.myMap == null) {
            this.myMap = new HashMap();
        }
        return this.myMap;
    }
}

