/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.property.DateProperty;

public abstract class UtcProperty
extends DateProperty {
    public UtcProperty(String name, ParameterList parameters) {
        super(name, parameters);
        this.setDate(new DateTime(true));
    }

    public UtcProperty(String name) {
        super(name);
        this.setDate(new DateTime(true));
    }

    public final DateTime getDateTime() {
        return (DateTime)this.getDate();
    }

    public void setDateTime(DateTime dateTime) {
        if (dateTime != null) {
            dateTime.setUtc(true);
        }
        this.setDate(dateTime);
    }

    public void validate() throws ValidationException {
        super.validate();
        if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
            throw new ValidationException("Property must have a DATE-TIME value");
        }
        DateTime dateTime = (DateTime)this.getDate();
        if (dateTime != null && !dateTime.isUtc()) {
            throw new ValidationException("DATE-TIME value must be specified in UTC time");
        }
    }
}

