/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Period
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7321090422911676490L;
    private DateTime start;
    private DateTime end;
    private Dur duration;

    public Period(String aValue) throws ParseException {
        this.start = new DateTime(aValue.substring(0, aValue.indexOf(47)));
        try {
            this.end = new DateTime(aValue.substring(aValue.indexOf(47) + 1));
        }
        catch (ParseException pe) {
            this.duration = new Dur(aValue);
        }
    }

    public Period(DateTime start, DateTime end) {
        this.start = start;
        this.end = end;
    }

    public Period(DateTime start, Dur duration) {
        this.start = start;
        this.duration = duration;
    }

    public final Dur getDuration() {
        if (this.end != null) {
            return new Dur(this.start, this.end);
        }
        return this.duration;
    }

    public final DateTime getEnd() {
        if (this.end == null) {
            DateTime derived = new DateTime(this.duration.getTime(this.start).getTime());
            derived.setUtc(this.start.isUtc());
            return derived;
        }
        return this.end;
    }

    public final DateTime getStart() {
        return this.start;
    }

    public final boolean includes(Date date) {
        return this.includes(date, true);
    }

    public final boolean includes(Date date, boolean inclusive) {
        if (inclusive) {
            return !this.getStart().after(date) && !this.getEnd().before(date);
        }
        return this.getStart().before(date) && this.getEnd().after(date);
    }

    public final boolean before(Period period) {
        return this.getEnd().before(period.getStart());
    }

    public final boolean after(Period period) {
        return this.getStart().after(period.getEnd());
    }

    public final boolean intersects(Period period) {
        if (period.includes(this.getStart()) && !period.getEnd().equals(this.getStart())) {
            return true;
        }
        return this.includes(period.getStart()) && !this.getEnd().equals(period.getStart());
    }

    public final boolean adjacent(Period period) {
        if (this.getStart().equals(period.getEnd())) {
            return true;
        }
        return this.getEnd().equals(period.getStart());
    }

    public final boolean contains(Period period) {
        return this.includes(period.getStart()) && this.includes(period.getEnd());
    }

    public final Period add(Period period) {
        DateTime newPeriodStart = null;
        DateTime newPeriodEnd = null;
        if (period == null) {
            newPeriodStart = this.getStart();
            newPeriodEnd = this.getEnd();
        } else {
            newPeriodStart = this.getStart().before(period.getStart()) ? this.getStart() : period.getStart();
            newPeriodEnd = this.getEnd().after(period.getEnd()) ? this.getEnd() : period.getEnd();
        }
        return new Period(newPeriodStart, newPeriodEnd);
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.start);
        b.append('/');
        if (this.end != null) {
            b.append(this.end);
        } else {
            b.append(this.duration);
        }
        return b.toString();
    }

    public final int compareTo(Object arg0) {
        return this.compareTo((Period)arg0);
    }

    public final int compareTo(Period arg0) {
        int endCompare;
        if (arg0 == null) {
            throw new ClassCastException("Cannot compare this object to null");
        }
        int startCompare = this.getStart().compareTo(arg0.getStart());
        if (startCompare != 0) {
            return startCompare;
        }
        if (this.end != null && (endCompare = this.end.compareTo(arg0.getEnd())) != 0) {
            return endCompare;
        }
        return this.getDuration().compareTo(arg0.getDuration());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Period)) {
            return false;
        }
        Period period = (Period)o;
        return ObjectUtils.equals((Object)this.getStart(), (Object)period.getStart()) && ObjectUtils.equals((Object)this.getEnd(), (Object)period.getEnd());
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.start).append((Object)(this.end != null ? this.end : this.duration)).toHashCode();
    }
}

