/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.custom.appinfo.CustomEncoding;
import com.sun.encoder.custom.appinfo.Delimiter;
import com.sun.encoder.custom.appinfo.DelimiterLevel;
import com.sun.encoder.custom.appinfo.NodeProperties;
import com.sun.encoder.custom.runtime.provider.Delim;
import com.sun.encoder.custom.runtime.provider.Nodes;
import com.sun.encoder.custom.runtime.provider.OtdDelim;
import com.sun.encoder.runtime.CoderFactory;
import com.sun.encoder.runtime.provider.Misc;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesFactory {
    public static final QName NODE_PROP_ELEMENT = new QName("urn:com.sun:encoder-custom-1.0", "nodeProperties");
    public static final QName APPINFO_SOURCE_ATTR = new QName("source");
    public static final String ENCODER_NAMESPACE = "urn:com.sun:encoder";

    public static Nodes loadFromXSD(File xsdPath, QName rootElementName) throws EncoderConfigurationException {
        try {
            SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)NodeProperties.class.getClassLoader());
            SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((File)xsdPath);
            SchemaTypeSystem schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)typeLoader, null);
            typeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{typeLoader, schemaTS});
            SchemaGlobalElement rootElement = typeLoader.findElement(rootElementName);
            if (rootElement == null) {
                throw new EncoderConfigurationException("Unable to find element " + rootElementName + " in " + xsdPath);
            }
            Nodes nodes = NodesFactory.loadFromXSD(rootElement);
            nodes.setMetadataLocation(xsdPath.toURL());
            nodes.setMetadataNamespace(schemaXmlObj.getSchema().getTargetNamespace());
            return nodes;
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public static Nodes loadFromXSD(URL xsdURL, QName rootElementName) throws EncoderConfigurationException {
        try {
            SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)NodeProperties.class.getClassLoader());
            XmlOptions options = new XmlOptions();
            options.put((Object)"COMPILE_DOWNLOAD_URLS", (Object)Boolean.TRUE);
            SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((URL)xsdURL, (XmlOptions)options);
            SchemaTypeSystem schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)typeLoader, (XmlOptions)options);
            typeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{typeLoader, schemaTS});
            SchemaGlobalElement rootElement = typeLoader.findElement(rootElementName);
            if (rootElement == null) {
                throw new EncoderConfigurationException("Unable to find element " + rootElementName + " in " + xsdURL);
            }
            Nodes nodes = NodesFactory.loadFromXSD(rootElement);
            nodes.setMetadataLocation(xsdURL);
            nodes.setMetadataNamespace(schemaXmlObj.getSchema().getTargetNamespace());
            return nodes;
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public static Nodes loadFromXSD(SchemaGlobalElement rootElement) throws EncoderConfigurationException {
        HashMap<String, Integer> nodeMap = new HashMap<String, Integer>();
        ArrayList<RawNode> nodeList = new ArrayList<RawNode>();
        ArrayList<Delim> delimList = new ArrayList<Delim>();
        ArrayList<Delim.Slot> slotList = new ArrayList<Delim.Slot>();
        int index = NodesFactory.loadRawNode(null, -1, (SchemaLocalElement)rootElement, nodeMap, nodeList, delimList, slotList);
        Delim[] delims = new Delim[delimList.size()];
        delimList.toArray(delims);
        Delim.Slot[] slots = new Delim.Slot[slotList.size()];
        slotList.toArray(slots);
        OtdDelim otdDelim = new OtdDelim(delims, slots);
        Nodes nodes = new Nodes(nodeList.size(), otdDelim);
        if (((RawNode)nodeList.get((int)index)).mAntecoding != null || ((RawNode)nodeList.get((int)index)).mDecoding != null || ((RawNode)nodeList.get((int)index)).mPreDecodeCharCoding != null) {
            String antecoding = ((RawNode)nodeList.get((int)index)).mAntecoding;
            String decoding = ((RawNode)nodeList.get((int)index)).mPreDecodeCharCoding;
            if (antecoding == null) {
                antecoding = "iso-8859-1";
            }
            if (decoding == null) {
                decoding = ((RawNode)nodeList.get((int)index)).mDecoding;
            }
            if (decoding == null) {
                decoding = "iso-8859-1";
            }
            nodes.setAntecoder(CoderFactory.getTrans((String)antecoding, (String)decoding));
        }
        if (((RawNode)nodeList.get((int)index)).mDecoding != null) {
            nodes.setDecoder(CoderFactory.getCoder((String)((RawNode)nodeList.get((int)index)).mDecoding));
        }
        if (((RawNode)nodeList.get((int)index)).mEncoding != null) {
            nodes.setEncoder(CoderFactory.getCoder((String)((RawNode)nodeList.get((int)index)).mEncoding));
        }
        if (((RawNode)nodeList.get((int)index)).mPostcoding != null || ((RawNode)nodeList.get((int)index)).mEncoding != null || ((RawNode)nodeList.get((int)index)).mPostEncodeCharCoding != null) {
            String postcoding = ((RawNode)nodeList.get((int)index)).mPostcoding;
            String encoding = ((RawNode)nodeList.get((int)index)).mPostEncodeCharCoding;
            if (postcoding == null) {
                postcoding = "iso-8859-1";
            }
            if (encoding == null) {
                encoding = ((RawNode)nodeList.get((int)index)).mEncoding;
            }
            if (encoding == null) {
                encoding = "iso-8859-1";
            }
            nodes.setPostcoder(CoderFactory.getTrans((String)encoding, (String)postcoding));
        }
        if (((RawNode)nodeList.get((int)index)).mAntecoding != null) {
            nodes.setAnteCoding(((RawNode)nodeList.get((int)index)).mAntecoding);
        }
        if (((RawNode)nodeList.get((int)index)).mPostcoding != null) {
            nodes.setPostCoding(((RawNode)nodeList.get((int)index)).mPostcoding);
        }
        int nodeCount = nodeList.size();
        for (int i = 0; i < nodeCount; ++i) {
            RawNode n = (RawNode)nodeList.get(i);
            boolean repeat = i == index ? false : n.mRepeat;
            try {
                nodes.add(i, n.mFromId, n.mNodeId, n.mType, n.mNamespace, n.mName, n.mChild, n.mOption, repeat, n.mMaxOcc, n.mOrder, n.mLength, n.mAlign, n.mMatch, n.mSub, n.mLevel);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new EncoderConfigurationException("Node: {" + n.mNamespace + "}" + n.mName + ": " + e.getMessage());
            }
        }
        nodes.setRoot(index);
        return nodes;
    }

    private static CustomEncoding getCustomEncoding(SchemaLocalElement elem) throws XmlException {
        SchemaAnnotation anno = elem.getAnnotation();
        if (anno == null) {
            return null;
        }
        XmlObject[] xmlObjs = anno.getApplicationInformation();
        if (xmlObjs == null || xmlObjs.length == 0) {
            return null;
        }
        for (int i = 0; i < xmlObjs.length; ++i) {
            XmlCursor cursor = xmlObjs[i].newCursor();
            String source = cursor.getAttributeText(APPINFO_SOURCE_ATTR);
            cursor.dispose();
            if (!ENCODER_NAMESPACE.equals(source)) continue;
            if (xmlObjs[i] instanceof CustomEncoding) {
                return (CustomEncoding)xmlObjs[i];
            }
            return CustomEncoding.Factory.parse((String)xmlObjs[i].xmlText());
        }
        return null;
    }

    private static byte getNodeType(NodeProperties nodeProps) {
        switch (nodeProps.getNodeType().intValue()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Invalid node type: " + nodeProps.getNodeType());
    }

    private static byte getOrder(NodeProperties nodeProps) {
        if (!nodeProps.isSetOrder()) {
            return 0;
        }
        switch (nodeProps.getOrder().intValue()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid order: " + nodeProps.getOrder());
    }

    private static byte getAlign(NodeProperties nodeProps) {
        if (!nodeProps.isSetAlignment()) {
            return 1;
        }
        switch (nodeProps.getAlignment().intValue()) {
            case 3: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 6: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Invalid alignment: " + nodeProps.getAlignment());
    }

    private static byte[] getMatch(NodeProperties nodeProps) {
        if (!nodeProps.isSetMatch()) {
            return null;
        }
        return Misc.str2bytes((String)Misc.nonPrintable((String)nodeProps.getMatch()));
    }

    private static Delim loadDelimiter(Delimiter rawDelim, List<Delim.Slot> slotList) {
        byte term;
        byte lieu;
        byte type;
        byte prec = 10;
        if (!rawDelim.isSetKind()) {
            type = 0;
        } else {
            switch (rawDelim.getKind().intValue()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 3: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid delimiter type: " + rawDelim.getKind());
                }
            }
        }
        if (!rawDelim.isSetPrecedence()) {
            prec = (byte)rawDelim.getPrecedence();
        }
        if (!rawDelim.isSetOptionalMode()) {
            lieu = 0;
        } else {
            switch (rawDelim.getOptionalMode().intValue()) {
                case 2: {
                    lieu = 1;
                    break;
                }
                case 3: {
                    lieu = 2;
                    break;
                }
                case 4: {
                    lieu = 3;
                    break;
                }
                case 1: {
                    lieu = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid optional mode: " + rawDelim.getOptionalMode());
                }
            }
        }
        if (!rawDelim.isSetTerminatorMode()) {
            term = 0;
        } else {
            switch (rawDelim.getTerminatorMode().intValue()) {
                case 2: {
                    term = 1;
                    break;
                }
                case 3: {
                    term = 2;
                    break;
                }
                case 4: {
                    term = 3;
                    break;
                }
                case 1: {
                    term = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid terminator mode: " + rawDelim.getTerminatorMode());
                }
            }
        }
        if (rawDelim.getBytes().isSetConstant()) {
            byte[] bytes = Misc.str2bytes((String)Misc.nonPrintable((String)rawDelim.getBytes().getConstant()));
            return new Delim(type, prec, term, lieu, bytes, rawDelim.isSetSkipLeading() && rawDelim.getSkipLeading(), rawDelim.isSetCollapse() && rawDelim.getCollapse());
        }
        int pos = rawDelim.getBytes().getEmbedded().getOffset();
        short len = rawDelim.getBytes().getEmbedded().getLength();
        short slot = (short)slotList.size();
        slotList.add(new Delim.Slot(pos, len));
        return new Delim(type, prec, term, lieu, slot, rawDelim.isSetSkipLeading() && rawDelim.getSkipLeading(), rawDelim.isSetCollapse() && rawDelim.getCollapse());
    }

    private static int[][] getLevels(NodeProperties nodeProps, List<Delim> delimList, List<Delim.Slot> slotList) {
        if (!nodeProps.isSetDelimiterSet()) {
            return null;
        }
        DelimiterLevel[] rawLevels = nodeProps.getDelimiterSet().getLevelArray();
        int[][] levels = new int[rawLevels.length][];
        for (int i = 0; i < rawLevels.length; ++i) {
            Delimiter[] rawDelims = rawLevels[i].getDelimiterArray();
            int[] delims = new int[rawDelims.length];
            for (int j = 0; j < rawDelims.length; ++j) {
                delims[j] = delimList.size();
                delimList.add(NodesFactory.loadDelimiter(rawDelims[j], slotList));
            }
            levels[i] = delims;
        }
        return levels;
    }

    private static int loadRawNode(String parentKey, int indexWithinParent, SchemaLocalElement elem, Map<String, Integer> nodeMap, List<RawNode> nodeList, List<Delim> delimList, List<Delim.Slot> slotList) throws EncoderConfigurationException {
        String postEncodeCharCoding;
        boolean opt;
        NodeProperties nodeProps;
        CustomEncoding customEncoding;
        String key = indexWithinParent == -1 ? elem.getName().toString() : parentKey + "|" + indexWithinParent;
        Integer nodeIndex = nodeMap.get(key);
        if (nodeIndex != null) {
            return nodeIndex;
        }
        SchemaType type = elem.getType();
        if (type == null || type.isNoType() || type.isURType() && !type.isSimpleType()) {
            throw new EncoderConfigurationException("No type or UR type is not supported.  element='" + elem.getName() + "'");
        }
        try {
            customEncoding = NodesFactory.getCustomEncoding(elem);
        }
        catch (XmlException ex) {
            throw new EncoderConfigurationException("Unable to load node properties.", (Throwable)ex);
        }
        if (customEncoding == null) {
            customEncoding = CustomEncoding.Factory.newInstance();
            nodeProps = customEncoding.addNewNodeProperties();
            nodeProps.setNodeType(NodeProperties.NodeType.DELIMITED);
        } else {
            nodeProps = customEncoding.getNodeProperties();
            if (nodeProps == null) {
                nodeProps = NodeProperties.Factory.newInstance();
                nodeProps.setNodeType(NodeProperties.NodeType.DELIMITED);
            }
        }
        boolean isSimple = type.getContentType() == 2 || type.isSimpleType();
        byte nodeType = NodesFactory.getNodeType(nodeProps);
        boolean bl = opt = elem.getMinOccurs() != null && elem.getMinOccurs().signum() == 0;
        boolean rep = elem.getMaxOccurs() == null ? true : elem.getMaxOccurs().compareTo(BigInteger.ONE) > 0;
        int maxOcc = rep && elem.getMaxOccurs() != null ? elem.getMaxOccurs().intValue() : -1;
        byte order = NodesFactory.getOrder(nodeProps);
        int length = nodeType == 3 ? nodeProps.getLength() : 0;
        byte align = NodesFactory.getAlign(nodeProps);
        byte[] match = NodesFactory.getMatch(nodeProps);
        if (!isSimple) {
            match = null;
        }
        int[] sub = null;
        int[][] levels = NodesFactory.getLevels(nodeProps, delimList, slotList);
        String antecoding = nodeProps.isSetInputCharset() ? nodeProps.getInputCharset() : null;
        String decoding = nodeProps.isSetParsingCharset() ? nodeProps.getParsingCharset() : null;
        String encoding = nodeProps.isSetSerializingCharset() ? nodeProps.getSerializingCharset() : null;
        String postcoding = nodeProps.isSetOutputCharset() ? nodeProps.getOutputCharset() : null;
        String preDecodeCharCoding = customEncoding.isSetPreDecodeCharCoding() ? customEncoding.getPreDecodeCharCoding() : null;
        String string = postEncodeCharCoding = customEncoding.isSetPostEncodeCharCoding() ? customEncoding.getPostEncodeCharCoding() : null;
        if (nodeType == 4) {
            if (isSimple || type.getContentModel() == null) {
                throw new EncoderConfigurationException("Group node must not be simple type (content).  element='" + elem.getName() + "'");
            }
            if (type.getContentModel().getParticleType() == 2) {
                nodeType = 0;
            }
        }
        RawNode rawNode = new RawNode(-1, -1, nodeType, elem.getName().getNamespaceURI(), elem.getName().getLocalPart(), indexWithinParent, opt, rep, maxOcc, order, length, align, match, sub, levels, antecoding, decoding, encoding, postcoding, preDecodeCharCoding, postEncodeCharCoding);
        nodeIndex = new Integer(nodeList.size());
        nodeList.add(rawNode);
        nodeMap.put(key, nodeIndex);
        if (!isSimple) {
            int[] subNodes;
            SchemaParticle contentModel = type.getContentModel();
            if (contentModel == null) {
                throw new EncoderConfigurationException("Complex type without child element is not supported.  element='" + elem.getName() + "'");
            }
            if (contentModel.getParticleType() == 5) {
                throw new EncoderConfigurationException("Wildcard is not supported for this encoding style.  element='" + elem.getName() + "'");
            }
            if (contentModel.getParticleType() == 4) {
                subNodes = new int[]{NodesFactory.loadRawNode(key, 0, (SchemaLocalElement)contentModel, nodeMap, nodeList, delimList, slotList)};
            } else {
                SchemaParticle[] particles = contentModel.getParticleChildren();
                subNodes = new int[particles.length];
                for (int i = 0; i < particles.length; ++i) {
                    if (particles[i].getParticleType() != 4) {
                        throw new EncoderConfigurationException("Amonymous group is not supported.  element='" + elem.getName() + "'");
                    }
                    subNodes[i] = NodesFactory.loadRawNode(key, i, (SchemaLocalElement)particles[i], nodeMap, nodeList, delimList, slotList);
                }
            }
            rawNode.mSub = subNodes;
        }
        return nodeIndex;
    }

    private static class RawNode {
        public final int mFromId;
        public final int mNodeId;
        public final String mNamespace;
        public final String mName;
        public final byte mType;
        public final int[][] mLevel;
        public final int mChild;
        public int[] mSub;
        public final boolean mOption;
        public final boolean mRepeat;
        public final int mMaxOcc;
        public final byte mOrder;
        public final int mLength;
        public final byte mAlign;
        public final byte[] mMatch;
        public final String mAntecoding;
        public final String mEncoding;
        public final String mDecoding;
        public final String mPostcoding;
        public final String mPreDecodeCharCoding;
        public final String mPostEncodeCharCoding;

        public RawNode(int from, int to, byte type, String namespace, String name, int child, boolean opt, boolean rep, int maxOcc, byte order, int length, byte align, byte[] match, int[] sub, int[][] level, String antecoding, String decoding, String encoding, String postcoding, String preDecodeCharCoding, String postEncodeCharCoding) {
            this.mFromId = from;
            this.mNodeId = to;
            this.mType = type;
            this.mNamespace = namespace;
            this.mName = name;
            this.mChild = child;
            this.mOption = opt;
            this.mRepeat = rep;
            this.mMaxOcc = maxOcc;
            this.mOrder = order;
            this.mLength = length;
            this.mAlign = align;
            this.mMatch = match;
            this.mSub = sub;
            this.mLevel = level;
            this.mAntecoding = antecoding;
            this.mDecoding = decoding;
            this.mEncoding = encoding;
            this.mPostcoding = postcoding;
            this.mPreDecodeCharCoding = preDecodeCharCoding;
            this.mPostEncodeCharCoding = postEncodeCharCoding;
        }
    }
}

