/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.custom.runtime.provider.Delim;
import com.sun.encoder.custom.runtime.provider.OtdDelim;
import com.sun.encoder.runtime.CoderFactory;
import com.sun.encoder.runtime.StringCoder;
import com.sun.encoder.runtime.TransCoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class Nodes {
    public static final String DEFAULT_ANTECODING = "iso-8859-1";
    public static final String DEFAULT_DECODING = "iso-8859-1";
    public static final String DEFAULT_ENCODING = "iso-8859-1";
    public static final String DEFAULT_POSTCODING = "iso-8859-1";
    public static final String DEFAULT_PREDECODECHARCODING = "iso-8859-1";
    public static final String DEFAULT_POSTENCODECHARCODING = "iso-8859-1";
    private final Node[] mNodes;
    private URL mMetadataLocation;
    private String mMetadataNamespace;
    public final OtdDelim mDelim;
    private TransCoder mAntecoder = CoderFactory.getTrans((String)"iso-8859-1", (String)"iso-8859-1");
    private String mAnteCoding = "iso-8859-1";
    private StringCoder mDecoder = CoderFactory.getCoder((String)"iso-8859-1");
    private StringCoder mEncoder = CoderFactory.getCoder((String)"iso-8859-1");
    private TransCoder mPostcoder = CoderFactory.getTrans((String)"iso-8859-1", (String)"iso-8859-1");
    private String mPostCoding = "iso-8859-1";
    private StringCoder mPreDecodeCharCoder;
    private StringCoder mPostEncodeCharCoder;
    private int mRoot;
    private boolean mVerified = false;

    Nodes(int count, OtdDelim delim) {
        this.mNodes = new Node[count];
        this.mDelim = delim;
    }

    public OtdDelim getDelim() {
        return this.mDelim;
    }

    public Node get(int index) {
        if (index < 0 || this.mNodes.length <= index) {
            throw new IllegalArgumentException("index out of node range: " + index);
        }
        if (this.mNodes[index] == null) {
            throw new RuntimeException("missing node descriptor #" + index);
        }
        return this.mNodes[index];
    }

    public void add(int index, int from, int to, byte type, String namespace, String name, int child, boolean opt, boolean rep, int length, byte[] match, int[] sub, int[][] level) {
        this.add(index, from, to, type, namespace, name, child, opt, rep, -1, (byte)0, length, match == null ? (byte)0 : 1, match, sub, level);
    }

    public void add(int index, int from, int to, byte type, String namespace, String name, int child, boolean opt, boolean rep, int maxOcc, byte order, int length, byte align, byte[] match, int[] sub, int[][] level) {
        if (index < 0 || this.mNodes.length <= index) {
            throw new IndexOutOfBoundsException("index out of node range: " + index);
        }
        if (this.mNodes[index] != null) {
            throw new RuntimeException("duplicate node descriptor #" + index);
        }
        if (type != 3 && length != 0) {
            throw new IllegalArgumentException("non-fixed node needs length=0");
        }
        this.mNodes[index] = new Node(from, to, type, namespace, name, child, sub, opt, rep, maxOcc, order, length, align, match, this.mDelim.build(level));
    }

    public void setMetadataLocation(URL location) {
        this.mMetadataLocation = location;
    }

    public URL getMetadataLocation() {
        return this.mMetadataLocation;
    }

    public void setMetadataNamespace(String namespace) {
        this.mMetadataNamespace = namespace;
    }

    public String getMetadataNamespace() {
        return this.mMetadataNamespace;
    }

    public static String nodeType(byte type) {
        switch (type) {
            case 0: {
                return "ALTER";
            }
            case 1: {
                return "ARRAY";
            }
            case 2: {
                return "DELIM";
            }
            case 3: {
                return "FIXED";
            }
            case 4: {
                return "GROUP";
            }
            case 5: {
                return "TRANS";
            }
            case 6: {
                return "UNDEF";
            }
        }
        throw new RuntimeException("unknown node type #" + type);
    }

    public static String nodeOrder(byte order) {
        switch (order) {
            case 0: {
                return "SEQ";
            }
            case 1: {
                return "MIX";
            }
            case 2: {
                return "ANY";
            }
        }
        throw new RuntimeException("unknown node order #" + order);
    }

    public static String nodeAlign(byte align) {
        switch (align) {
            case 0: {
                return "BLIND";
            }
            case 1: {
                return "EXACT";
            }
            case 2: {
                return "BEGIN";
            }
            case 3: {
                return "FINAL";
            }
            case 4: {
                return "INTER";
            }
            case 5: {
                return "SUPER";
            }
            case 6: {
                return "ONEOF";
            }
        }
        throw new RuntimeException("unknown node align #" + align);
    }

    public void print(PrintWriter out) {
        for (int i = 0; i < this.mNodes.length; ++i) {
            OtdDelim.DelimLevel level;
            Node node = this.mNodes[i];
            if (node == null) continue;
            out.print("[" + i + "] " + node.nodeType() + (node.mOption ? " optional" : "") + (node.mRepeat ? " repeated" : "") + " child=" + node.mChild + ", order=" + node.nodeOrder() + (node.mMaxOcc < 0 ? "" : ", maxOcc=" + node.mMaxOcc) + (node.mLength == 0 ? "" : ", length=" + node.mLength));
            if (node.mSub != null) {
                out.print(", sub");
                for (int j = 0; j < node.mSub.length; ++j) {
                    out.print(" " + node.mSub[j]);
                }
            }
            if ((level = node.mLevel) != null) {
                out.print(", level");
                while (level != null) {
                    out.print(" [" + level.mPlain + "/" + level.mArray);
                    for (int j = 0; j < level.mRefs.length; ++j) {
                        out.print(" " + level.mRefs[j]);
                    }
                    out.print("]");
                    level = level.mNext;
                }
            }
            out.println();
        }
        out.println("[ " + this.mNodes.length + " entries ]");
    }

    public void print(PrintStream out) {
        PrintWriter pw = new PrintWriter(out);
        this.print(pw);
        pw.flush();
    }

    public void verify() {
        int i;
        if (this.mVerified) {
            throw new RuntimeException("2nd call to verify()");
        }
        boolean[] seen = new boolean[this.mNodes.length];
        for (i = 0; i < this.mNodes.length; ++i) {
            seen[i] = false;
        }
        for (i = 0; i < this.mNodes.length; ++i) {
            Node node = this.mNodes[i];
            if (node == null) {
                throw new RuntimeException("node #" + i + " was not set");
            }
            int[] sub = node.mSub;
            if (node.mSub == null) continue;
            for (int j = 0; j < sub.length; ++j) {
                int child = sub[j];
                if (child < 0 || this.mNodes.length <= child) {
                    throw new RuntimeException("node #" + i + ", ref #" + j + " is invalid: " + child);
                }
                if (seen[child]) {
                    throw new RuntimeException("node #" + i + ", ref #" + j + " is duplicate parent of " + child);
                }
                if (this.mNodes[child].mChild != j) {
                    throw new RuntimeException("node #" + i + " says node[" + child + "].mChild should be " + j + ", not " + this.mNodes[child].mChild);
                }
                seen[child] = true;
            }
        }
        this.mVerified = true;
    }

    public static Nodes example() throws IOException {
        Delim[] delims = new Delim[]{new Delim(3, "A"), new Delim(3, "B")};
        OtdDelim otd = new OtdDelim(delims, null);
        Nodes nodes = new Nodes(4, otd);
        nodes.add(0, -1, -1, (byte)4, null, "eins", 0, false, false, 0, null, new int[]{1}, null);
        nodes.add(1, -1, -1, (byte)2, null, "zwei", 0, false, false, 0, null, new int[]{2, 3}, new int[][]{{0}, {1}});
        nodes.add(2, -1, -1, (byte)2, null, "drei", 0, false, false, 0, null, null, null);
        nodes.add(3, -1, -1, (byte)2, null, "vier", 1, false, false, 0, null, null, null);
        return nodes;
    }

    public static void main(String[] args) {
        try {
            System.out.println("[ start ]");
            Nodes nodes = Nodes.example();
            System.out.println("[ verify ]");
            nodes.verify();
            System.out.println("[ ready ]");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public TransCoder getAntecoder() {
        return this.mAntecoder;
    }

    public void setAntecoder(TransCoder antecoder) {
        this.mAntecoder = antecoder;
    }

    public StringCoder getDecoder() {
        return this.mDecoder;
    }

    public void setDecoder(StringCoder decoder) {
        this.mDecoder = decoder;
    }

    public StringCoder getEncoder() {
        return this.mEncoder;
    }

    public void setEncoder(StringCoder encoder) {
        this.mEncoder = encoder;
    }

    public TransCoder getPostcoder() {
        return this.mPostcoder;
    }

    public void setPostcoder(TransCoder postcoder) {
        this.mPostcoder = postcoder;
    }

    public StringCoder getPreDecodeCharCoder() {
        if (this.mPreDecodeCharCoder != null) {
            return this.mPreDecodeCharCoder;
        }
        return this.mDecoder;
    }

    public void setPreDecodeCharCoder(StringCoder coder) {
        this.mPreDecodeCharCoder = coder;
    }

    public StringCoder getPostEncodeCharCoder() {
        if (this.mPostEncodeCharCoder != null) {
            return this.mPostEncodeCharCoder;
        }
        return this.mEncoder;
    }

    public void setPostEncodeCharCoder(StringCoder coder) {
        this.mPostEncodeCharCoder = coder;
    }

    public String getAnteCoding() {
        return this.mAnteCoding;
    }

    public void setAnteCoding(String coding) {
        this.mAnteCoding = coding;
    }

    public String getPostCoding() {
        return this.mPostCoding;
    }

    public void setPostCoding(String coding) {
        this.mPostCoding = coding;
    }

    public int getRoot() {
        return this.mRoot;
    }

    public void setRoot(int root) {
        this.mRoot = root;
    }

    public static class Node {
        public final int mFromId;
        public final int mNodeId;
        public final String mNamespace;
        public final String mName;
        public final byte mType;
        public final OtdDelim.DelimLevel mLevel;
        public final int mChild;
        public final int[] mSub;
        public final boolean mOption;
        public final boolean mRepeat;
        public final int mMaxOcc;
        public final byte mOrder;
        public final int mLength;
        public final byte mAlign;
        public final byte[] mMatch;

        public Node(int from, int to, byte type, String namespace, String name, int child, int[] sub, boolean opt, boolean rep, int maxOcc, byte order, int length, byte align, byte[] match, OtdDelim.DelimLevel level) {
            if (sub != null && match != null) {
                throw new IllegalArgumentException("only leaf nodes can have match");
            }
            if (align == 1 && match != null && type == 3 && length > 0 && match.length > length) {
                throw new IllegalArgumentException("match length exceeds field length");
            }
            this.mFromId = from;
            this.mNodeId = to;
            this.mNamespace = namespace;
            this.mName = name;
            this.mType = type;
            this.mChild = child;
            this.mSub = sub;
            this.mOption = opt;
            this.mRepeat = rep;
            this.mMaxOcc = maxOcc;
            this.mOrder = order;
            this.mLength = length;
            this.mAlign = align;
            this.mMatch = match;
            this.mLevel = level;
        }

        public boolean isAlter() {
            return this.mType == 0;
        }

        public boolean isArray() {
            return this.mType == 1;
        }

        public boolean isDelim() {
            return this.mType == 2;
        }

        public boolean isFixed() {
            return this.mType == 3;
        }

        public boolean isGroup() {
            return this.mType == 4;
        }

        public boolean isTrans() {
            return this.mType == 5;
        }

        public boolean isSimple() {
            return this.mSub == null;
        }

        public String nodeType() {
            return Nodes.nodeType(this.mType);
        }

        public String nodeOrder() {
            return Nodes.nodeOrder(this.mOrder);
        }

        public String nodeAlign() {
            return Nodes.nodeAlign(this.mAlign);
        }

        public static interface Align {
            public static final byte BLIND = 0;
            public static final byte EXACT = 1;
            public static final byte BEGIN = 2;
            public static final byte FINAL = 3;
            public static final byte INTER = 4;
            public static final byte SUPER = 5;
            public static final byte ONEOF = 6;
        }

        public static interface Order {
            public static final byte SEQ = 0;
            public static final byte MIX = 1;
            public static final byte ANY = 2;
        }

        public static interface Type {
            public static final byte ALTER = 0;
            public static final byte ARRAY = 1;
            public static final byte DELIM = 2;
            public static final byte FIXED = 3;
            public static final byte GROUP = 4;
            public static final byte TRANS = 5;
            public static final byte UNDEF = 6;
            public static final byte EXREF = 7;
        }
    }

    private static class Lexer {
        private final LineNumberReader mIn;
        private int mLast = -1;
        private StringBuffer mBuf = new StringBuffer();

        public Lexer(InputStream in) {
            try {
                this.mIn = new LineNumberReader(new InputStreamReader(in, "UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException("platform broken, no UTF-8");
            }
        }

        private int get() throws IOException {
            if (this.mLast >= 0) {
                int res = this.mLast;
                this.mLast = -1;
                return res;
            }
            return this.mIn.read();
        }

        private void unget(int c) {
            if (this.mLast >= 0) {
                throw new RuntimeException("double unget()");
            }
            this.mLast = c;
        }

        public int skipSpace() throws IOException {
            int c;
            while ((c = this.get()) == 32) {
            }
            if (c == 35) {
                while ((c = this.get()) >= 0 && c != 10) {
                }
            }
            return c;
        }

        public int scanInt(String what) throws IOException {
            int c = this.skipSpace();
            int digits = 0;
            int value = 0;
            if (c == 45) {
                return -1;
            }
            while (48 <= c && c <= 57) {
                value = value * 10 + (c - 48);
                c = this.get();
                ++digits;
            }
            if (digits == 0) {
                throw new RuntimeException("line " + this.mIn.getLineNumber() + ": " + what + " not an integer, last char = '" + (char)c + "' (" + c + ")");
            }
            this.unget(c);
            return value;
        }

        public int[] scanIntRow(String what) throws IOException {
            int count = this.scanInt(what + " count");
            if (count < 0) {
                return null;
            }
            int[] value = new int[count];
            for (int i = 0; i < count; ++i) {
                value[i] = this.scanInt(what + " part");
            }
            return value;
        }

        public int[][] scanIntRowRow(String what) throws IOException {
            int count = this.scanInt(what + " count");
            if (count < 0) {
                return null;
            }
            int[][] value = new int[count][];
            for (int i = 0; i < count; ++i) {
                value[i] = this.scanIntRow(what + " part");
            }
            return value;
        }

        public boolean scanBool() throws IOException {
            int c = this.skipSpace();
            if (c == 102) {
                return false;
            }
            if (c == 116) {
                return true;
            }
            throw new RuntimeException("line " + this.mIn.getLineNumber() + ": not a boolean");
        }

        public String scanString() throws IOException {
            int c = this.skipSpace();
            if (c == 45) {
                return null;
            }
            int quote = c;
            this.mBuf.setLength(0);
            while ((c = this.get()) != quote) {
                if (c == 92) {
                    c = this.get();
                    switch (c) {
                        case 101: {
                            c = 92;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 113: {
                            c = quote;
                        }
                    }
                }
                if (c < 0) {
                    throw new RuntimeException("line " + this.mIn.getLineNumber() + ": EOF in string");
                }
                this.mBuf.append((char)c);
            }
            return this.mBuf.toString();
        }
    }
}

