/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.management.snmp.EnumRowStatus;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibEntry;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpStandardMetaServer;
import com.sun.management.snmp.agent.SnmpStandardObjectServer;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStorageType;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryMBean;
import java.io.Serializable;

public class UsmUserEntryMeta
extends SnmpMibEntry
implements Serializable,
SnmpStandardMetaServer {
    private static final long serialVersionUID = 353173372738958004L;
    protected UsmUserEntryMBean node;
    protected SnmpStandardObjectServer objectserver = null;

    public UsmUserEntryMeta(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        this.objectserver = snmpStandardObjectServer;
        this.varList = new int[11];
        this.varList[0] = 9;
        this.varList[1] = 8;
        this.varList[2] = 7;
        this.varList[3] = 6;
        this.varList[4] = 5;
        this.varList[5] = 4;
        this.varList[6] = 13;
        this.varList[7] = 12;
        this.varList[8] = 3;
        this.varList[9] = 11;
        this.varList[10] = 10;
        SnmpMibNode.sort(this.varList);
    }

    public SnmpValue get(long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 9: {
                return new SnmpString(this.node.getUsmUserPrivKeyChange());
            }
            case 8: {
                return new SnmpOid(this.node.getUsmUserPrivProtocol());
            }
            case 7: {
                return new SnmpString(this.node.getUsmUserOwnAuthKeyChange());
            }
            case 6: {
                return new SnmpString(this.node.getUsmUserAuthKeyChange());
            }
            case 5: {
                return new SnmpOid(this.node.getUsmUserAuthProtocol());
            }
            case 4: {
                return new SnmpOid(this.node.getUsmUserCloneFrom());
            }
            case 13: {
                return new SnmpInt(this.node.getUsmUserStatus());
            }
            case 12: {
                return new SnmpInt(this.node.getUsmUserStorageType());
            }
            case 3: {
                return new SnmpString(this.node.getUsmUserSecurityName());
            }
            case 2: {
                throw new SnmpStatusException(224);
            }
            case 11: {
                return new SnmpString(this.node.getUsmUserPublic());
            }
            case 1: {
                throw new SnmpStatusException(224);
            }
            case 10: {
                return new SnmpString(this.node.getUsmUserOwnPrivKeyChange());
            }
        }
        throw new SnmpStatusException(225);
    }

    public SnmpValue set(SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 9: {
                if (snmpValue instanceof SnmpString) {
                    this.node.setUsmUserPrivKeyChange(((SnmpString)snmpValue).toByte());
                    return new SnmpString(this.node.getUsmUserPrivKeyChange());
                }
                throw new SnmpStatusException(7);
            }
            case 8: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.setUsmUserPrivProtocol(((SnmpOid)snmpValue).toString());
                    return new SnmpOid(this.node.getUsmUserPrivProtocol());
                }
                throw new SnmpStatusException(7);
            }
            case 7: {
                if (snmpValue instanceof SnmpString) {
                    this.node.setUsmUserOwnAuthKeyChange(((SnmpString)snmpValue).toByte());
                    return new SnmpString(this.node.getUsmUserOwnAuthKeyChange());
                }
                throw new SnmpStatusException(7);
            }
            case 6: {
                if (snmpValue instanceof SnmpString) {
                    this.node.setUsmUserAuthKeyChange(((SnmpString)snmpValue).toByte());
                    return new SnmpString(this.node.getUsmUserAuthKeyChange());
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.setUsmUserAuthProtocol(((SnmpOid)snmpValue).toString());
                    return new SnmpOid(this.node.getUsmUserAuthProtocol());
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.setUsmUserCloneFrom(((SnmpOid)snmpValue).toString());
                    return new SnmpOid(this.node.getUsmUserCloneFrom());
                }
                throw new SnmpStatusException(7);
            }
            case 13: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setUsmUserStatus(new EnumUsmUserStatus(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getUsmUserStatus());
                }
                throw new SnmpStatusException(7);
            }
            case 12: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setUsmUserStorageType(new EnumUsmUserStorageType(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getUsmUserStorageType());
                }
                throw new SnmpStatusException(7);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 11: {
                if (snmpValue instanceof SnmpString) {
                    this.node.setUsmUserPublic(((SnmpString)snmpValue).toByte());
                    return new SnmpString(this.node.getUsmUserPublic());
                }
                throw new SnmpStatusException(7);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                if (snmpValue instanceof SnmpString) {
                    this.node.setUsmUserOwnPrivKeyChange(((SnmpString)snmpValue).toByte());
                    return new SnmpString(this.node.getUsmUserOwnPrivKeyChange());
                }
                throw new SnmpStatusException(7);
            }
        }
        throw new SnmpStatusException(17);
    }

    public void check(SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        switch ((int)l) {
            case 9: {
                if (snmpValue instanceof SnmpString) {
                    this.node.checkUsmUserPrivKeyChange(((SnmpString)snmpValue).toByte());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 8: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.checkUsmUserPrivProtocol(((SnmpOid)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 7: {
                if (snmpValue instanceof SnmpString) {
                    this.node.checkUsmUserOwnAuthKeyChange(((SnmpString)snmpValue).toByte());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 6: {
                if (snmpValue instanceof SnmpString) {
                    this.node.checkUsmUserAuthKeyChange(((SnmpString)snmpValue).toByte());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.checkUsmUserAuthProtocol(((SnmpOid)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                if (snmpValue instanceof SnmpOid) {
                    this.node.checkUsmUserCloneFrom(((SnmpOid)snmpValue).toString());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 13: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkUsmUserStatus(new EnumUsmUserStatus(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 12: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkUsmUserStorageType(new EnumUsmUserStorageType(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 11: {
                if (snmpValue instanceof SnmpString) {
                    this.node.checkUsmUserPublic(((SnmpString)snmpValue).toByte());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                if (snmpValue instanceof SnmpString) {
                    this.node.checkUsmUserOwnPrivKeyChange(((SnmpString)snmpValue).toByte());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(UsmUserEntryMBean usmUserEntryMBean) {
        this.node = usmUserEntryMBean;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.get(this, snmpMibSubRequest, n);
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.set(this, snmpMibSubRequest, n);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        this.objectserver.check(this, snmpMibSubRequest, n);
    }

    public boolean isVariable(long l) {
        switch ((int)l) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isReadable(long l) {
        switch ((int)l) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public String getAttributeName(long l) throws SnmpStatusException {
        switch ((int)l) {
            case 9: {
                return "UsmUserPrivKeyChange";
            }
            case 8: {
                return "UsmUserPrivProtocol";
            }
            case 7: {
                return "UsmUserOwnAuthKeyChange";
            }
            case 6: {
                return "UsmUserAuthKeyChange";
            }
            case 5: {
                return "UsmUserAuthProtocol";
            }
            case 4: {
                return "UsmUserCloneFrom";
            }
            case 13: {
                return "UsmUserStatus";
            }
            case 12: {
                return "UsmUserStorageType";
            }
            case 3: {
                return "UsmUserSecurityName";
            }
            case 2: {
                return "UsmUserName";
            }
            case 11: {
                return "UsmUserPublic";
            }
            case 1: {
                return "UsmUserEngineID";
            }
            case 10: {
                return "UsmUserOwnPrivKeyChange";
            }
        }
        throw new SnmpStatusException(225);
    }

    public long getRowStatusId() {
        return 13L;
    }

    public String getRowStatusName() {
        return new String("UsmUserStatus");
    }

    protected int mapRowStatus(SnmpVarBind snmpVarBind, Object object) throws SnmpStatusException {
        SnmpValue snmpValue = snmpVarBind.getSnmpValue();
        if (snmpValue == null) {
            throw new SnmpStatusException(12);
        }
        if (!(snmpValue instanceof SnmpInt)) {
            throw new SnmpStatusException(7);
        }
        int n = ((SnmpInt)snmpValue).intValue();
        if (!EnumRowStatus.isValidValue(n)) {
            throw new SnmpStatusException(12);
        }
        return n;
    }

    public int getRowStatus(Object object) throws SnmpStatusException {
        SnmpValue snmpValue = this.get(13L, object);
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        snmpVarBind.setSnmpValue(snmpValue);
        return this.mapRowStatus(snmpVarBind, object);
    }

    public SnmpValue setRowStatus(int n, Object object) throws SnmpStatusException {
        SnmpInt snmpInt = new SnmpInt(n);
        return this.set(snmpInt, 13L, object);
    }

    public boolean isRowReady(Object object) throws SnmpStatusException {
        return true;
    }
}

