/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.net.DatagramPacket;

class SnmpResponseHandler {
    SnmpQManager snmpq = null;
    SnmpSession session = null;
    SnmpEngineImpl engine = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpResponseHandler");
    String dbgTag = "SnmpResponseHandler";

    public SnmpResponseHandler(SnmpSession snmpSession) {
        this.snmpq = SnmpQManager.getTheInstance();
        this.session = snmpSession;
    }

    public SnmpResponseHandler(SnmpQManager snmpQManager, SnmpSession snmpSession) {
        this.snmpq = snmpQManager;
        this.session = snmpSession;
    }

    public void setEngine(SnmpEngine snmpEngine) {
        this.engine = (SnmpEngineImpl)snmpEngine;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (logger.finerOn()) {
            logger.finer("processDatagram", "Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMsg.dumpHexBuffer(byArray, 0, n));
        }
        SnmpRequest snmpRequest = null;
        try {
            int n2 = SnmpMsg.getProtocolVersion(datagramPacket.getData());
            SnmpPduFactory snmpPduFactory = this.snmpq.findPduFactory(datagramPacket.getAddress(), datagramPacket.getPort());
            if (snmpPduFactory == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Use the SnmpSession pdu factory.");
                }
                snmpPduFactory = this.session.getPduFactory();
            } else if (logger.finestOn()) {
                logger.finest("processDatagram", "Use the SnmpPeer pdu factory.");
            }
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
            SnmpIncomingResponse snmpIncomingResponse = snmpMsgProcessingSubSystem.getIncomingResponse(n2, snmpPduFactory);
            int n3 = snmpIncomingResponse.getRequestId(byArray);
            if (snmpPduFactory == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory for = " + datagramPacket.getAddress() + ":" + datagramPacket.getPort());
                }
                return;
            }
            snmpRequest = this.snmpq.removeRequest(n3);
            if (snmpRequest == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Unable to find corresponding for requestId = " + n3);
                }
                return;
            }
            snmpIncomingResponse.setSecurityCache(snmpRequest.getSecurityCache());
            SnmpPdu snmpPdu = null;
            try {
                snmpIncomingResponse.decodeMessage(byArray, n, datagramPacket.getAddress(), datagramPacket.getPort());
                snmpPdu = snmpIncomingResponse.decodeSnmpPdu();
            }
            catch (SnmpSecurityException snmpSecurityException) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", " Security Exception when unmarshalling, status : " + snmpSecurityException.status);
                }
                snmpRequest.setErrorStatusAndIndex(snmpSecurityException.status, 0);
                snmpRequest.invokeOnResponse(null);
                return;
            }
            if (snmpPdu == null) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                }
                return;
            }
            if (!(snmpPdu instanceof SnmpPduRequestType)) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Dropping packet. The packet does not contain a response");
                }
                snmpPdu = null;
                return;
            }
            SnmpPdu snmpPdu2 = snmpPdu;
            snmpRequest.setResponseSecurityParameters(snmpIncomingResponse.getSecurityParameters());
            snmpRequest.invokeOnResponse(snmpPdu2);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("processDatagram", "Exception while processing");
                logger.finest("processDatagram", exception);
            }
            if (!this.session.isInvalidResponseErrorHidden()) {
                if (logger.finestOn()) {
                    logger.finest("processDatagram", "Error are not hidden.throw genErr.");
                }
                snmpRequest.setErrorStatusAndIndex(5, 0);
                snmpRequest.invokeOnResponse(null);
            }
            return;
        }
    }
}

