/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public class SnmpTrap
implements Serializable {
    private static final long serialVersionUID = 4545122574911175203L;
    public static final SnmpOid coldStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.1");
    public static final SnmpOid warmStartOid = new SnmpOid("1.3.6.1.6.3.1.1.5.2");
    public static final SnmpOid linkDownOid = new SnmpOid("1.3.6.1.6.3.1.1.5.3");
    public static final SnmpOid linkUpOid = new SnmpOid("1.3.6.1.6.3.1.1.5.4");
    public static final SnmpOid authenticationFailureOid = new SnmpOid("1.3.6.1.6.3.1.1.5.5");
    public static final SnmpOid egpNeighborLossOid = new SnmpOid("1.3.6.1.6.3.1.1.5.6");
    private static final SnmpOid snmpTrapRadicalOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapSysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    public static final SnmpOid snmpTrapOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    public static final SnmpOid snmpTrapAddressOid = new SnmpOid("1.3.6.1.6.3.18.1.3.0");
    public static final SnmpOid snmpTrapEnterpriseOid = new SnmpOid("1.3.6.1.6.3.1.1.4.3.0");
    public static final SnmpOid snmpTrapsOid = new SnmpOid("1.3.6.1.6.3.1.1.5");
    public static final SnmpOid snmpTrapCommunityOid = new SnmpOid("1.3.6.1.6.3.18.1.4.0");
    String dbgTag = "SnmpTrap";
    InetAddress address = null;
    String communityString = null;
    SnmpOid trapOid = null;
    Integer gen = null;
    Integer specific = null;
    SnmpAdaptorServer server = null;
    SnmpOid enterpriseOid = null;
    SnmpPduTrap pduTrap = null;
    SnmpPduRequest pduRequest = null;
    SnmpVarBindList pduTrapList = null;
    int bufferSize = 1024;
    int port = -1;
    SnmpScopedPduRequest scopedTrap = null;
    private boolean originator = true;
    private InetAddress pduAddr = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpTrap");

    public SnmpTrap(int n, int n2, SnmpVarBindList snmpVarBindList) {
        this.gen = new Integer(n);
        this.specific = new Integer(n2);
        this.initialize(null, null, snmpVarBindList);
    }

    public SnmpTrap(InetAddress inetAddress, String string, int n, int n2, SnmpVarBindList snmpVarBindList) {
        this.gen = new Integer(n);
        this.specific = new Integer(n2);
        this.initialize(inetAddress, string, snmpVarBindList);
    }

    public SnmpTrap(SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) {
        this.trapOid = snmpOid;
        this.initialize(null, null, snmpVarBindList);
    }

    public SnmpTrap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) {
        this.trapOid = snmpOid;
        this.initialize(inetAddress, string, snmpVarBindList);
    }

    public SnmpTrap(SnmpPduTrap snmpPduTrap) {
        this.pduTrap = snmpPduTrap;
        this.convertPduList(snmpPduTrap.varBindList);
    }

    public SnmpTrap(SnmpScopedPduRequest snmpScopedPduRequest) {
        this.scopedTrap = snmpScopedPduRequest;
        this.convertPduList(snmpScopedPduRequest.varBindList);
    }

    public SnmpTrap(SnmpPduRequest snmpPduRequest) {
        this.pduRequest = snmpPduRequest;
        this.convertPduList(snmpPduRequest.varBindList);
    }

    public InetAddress getSourceAddress() {
        if (this.scopedTrap != null) {
            return this.scopedTrap.address;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.address;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.address;
        }
        return null;
    }

    public SnmpPdu getPdu() {
        if (this.scopedTrap != null) {
            return this.scopedTrap;
        }
        if (this.pduRequest != null) {
            return this.pduRequest;
        }
        if (this.pduTrap != null) {
            return this.pduTrap;
        }
        return null;
    }

    public void setEnterpriseOid(String string) {
        this.enterpriseOid = new SnmpOid(string);
    }

    public void setDestinationAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setDestinationPort(int n) {
        this.port = n;
    }

    public void setCommunityString(String string) {
        this.communityString = string;
    }

    public void sendV3(SnmpV3AdaptorServer snmpV3AdaptorServer) throws IOException, SnmpStatusException {
        if (this.scopedTrap == null) {
            throw new SnmpStatusException("No scoped trap. Should use sendV3Usm method");
        }
        if (this.port != -1) {
            SnmpUsmPeer snmpUsmPeer = null;
            if (this.getAddress() != null) {
                try {
                    snmpUsmPeer = new SnmpUsmPeer(snmpV3AdaptorServer.getEngine(), this.getAddress().getHostAddress(), this.port, null);
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    throw new SnmpStatusException("Unknown model: " + snmpUnknownModelException);
                }
                snmpV3AdaptorServer.snmpV3Trap(snmpUsmPeer, this.scopedTrap);
                return;
            }
        }
        snmpV3AdaptorServer.snmpV3Trap(this.getAddress(), this.scopedTrap);
    }

    public void sendV3Usm(SnmpV3AdaptorServer snmpV3AdaptorServer, String string, int n, String string2) throws IOException, SnmpStatusException {
        byte[] byArray;
        if (logger.finestOn()) {
            logger.finest("sendV3Trap", "trapOid= " + this.getTrapOid());
        }
        int n2 = this.port == -1 ? snmpV3AdaptorServer.getTrapPort() : this.port;
        SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)snmpV3AdaptorServer.getEngine();
        SnmpUsmPeer snmpUsmPeer = null;
        SnmpUsmParameters snmpUsmParameters = null;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV3Trap", "Create Peer " + this.getAddress() + "/" + n2);
            }
            try {
                snmpUsmPeer = new SnmpUsmPeer(snmpEngineImpl, this.getAddress().getHostAddress(), n2, null);
                snmpUsmParameters = new SnmpUsmParameters(snmpEngineImpl);
            }
            catch (SnmpUnknownModelException snmpUnknownModelException) {
                throw new SnmpStatusException("Unknown model: " + snmpUnknownModelException);
            }
            snmpUsmParameters.setPrincipal(string);
            snmpUsmParameters.setSecurityLevel(n);
            byArray = this.getContext(string2);
            if (byArray != null) {
                snmpUsmParameters.setContextName(byArray);
            }
            snmpUsmPeer.setParams(snmpUsmParameters);
        }
        if (snmpUsmPeer != null) {
            snmpV3AdaptorServer.snmpV3UsmTrap(snmpUsmPeer, this.getTrapOid(), this.getVarBindList(3), this.getTimeStamp());
        } else {
            byArray = this.getContext(string2);
            snmpV3AdaptorServer.snmpV3UsmTrap(this.getAddress(), string, n, byArray == null ? null : new String(byArray), this.getTrapOid(), this.getVarBindList(3), this.getTimeStamp());
        }
    }

    public void sendV2(SnmpAdaptorServer snmpAdaptorServer) throws IOException, SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("sendV2Trap", "trapOid= " + this.getTrapOid());
        }
        int n = this.port == -1 ? snmpAdaptorServer.getTrapPort() : this.port;
        SnmpPeer snmpPeer = null;
        SnmpParameters snmpParameters = null;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV2Trap", "Create Peer " + this.getAddress() + "/" + n);
            }
            snmpPeer = new SnmpPeer(this.getAddress().getHostAddress(), n);
            snmpParameters = new SnmpParameters();
            snmpParameters.setRdCommunity(this.getCommunity());
            snmpPeer.setParams(snmpParameters);
        }
        if (logger.finestOn()) {
            logger.finest("sendV2Trap", "pduRequest is not provided");
        }
        if (snmpPeer == null) {
            snmpAdaptorServer.snmpV2Trap(this.getAddress(), this.getCommunity(), this.getTrapOid(), this.getVarBindList(1), this.getTimeStamp());
        } else {
            snmpAdaptorServer.snmpV2Trap(snmpPeer, this.getTrapOid(), this.getVarBindList(1), this.getTimeStamp());
        }
    }

    public void sendV1(SnmpAdaptorServer snmpAdaptorServer) throws IOException, SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("snmpV1Trap", "generic = " + this.getGeneric());
        }
        int n = this.port == -1 ? snmpAdaptorServer.getTrapPort() : this.port;
        SnmpPeer snmpPeer = null;
        SnmpParameters snmpParameters = null;
        if (this.getAddress() != null) {
            if (logger.finestOn()) {
                logger.finest("sendV1Trap", "Create Peer " + this.getAddress() + "/" + n);
            }
            snmpPeer = new SnmpPeer(this.getAddress().getHostAddress(), n);
            snmpParameters = new SnmpParameters();
            snmpParameters.setRdCommunity(this.getCommunity());
            snmpPeer.setParams(snmpParameters);
        }
        if (snmpPeer == null) {
            snmpAdaptorServer.snmpV1Trap(this.getAddress(), this.getAgentAddr(), this.getCommunity(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), this.getTimeStamp());
        } else {
            snmpAdaptorServer.snmpV1Trap(snmpPeer, this.getAgentAddr(), this.getEnterpriseOid(), this.getGeneric(), this.getSpecific(), this.getVarBindList(0), this.getTimeStamp());
        }
    }

    private SnmpOid getTrapOid() {
        if (this.trapOid != null) {
            return this.trapOid;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            return (SnmpOid)snmpVarBind.getSnmpValue();
        }
        return this.calculateTrapOid();
    }

    private int getGeneric() {
        if (this.gen != null) {
            return this.gen;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.genericTrap;
        }
        return this.calculateGeneric();
    }

    private int getSpecific() {
        if (this.specific != null) {
            return this.specific;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.specificTrap;
        }
        return this.calculateSpecific();
    }

    private InetAddress getAddress() {
        return this.address;
    }

    private String getCommunity() {
        if (this.communityString != null) {
            return this.communityString;
        }
        if (this.pduTrap != null && this.pduTrap.community != null) {
            return new String(this.pduTrap.community);
        }
        if (this.pduRequest != null && this.pduRequest.community != null) {
            return new String(this.pduRequest.community);
        }
        if (this.scopedTrap != null && this.scopedTrap.contextName != null) {
            return new String(this.scopedTrap.contextName);
        }
        return null;
    }

    private byte[] getContext(String string) {
        if (string != null) {
            return string.getBytes();
        }
        if (this.pduTrap != null) {
            return this.pduTrap.community;
        }
        if (this.pduRequest != null) {
            return this.pduRequest.community;
        }
        if (this.scopedTrap != null) {
            return this.scopedTrap.contextName;
        }
        return null;
    }

    private SnmpOid getEnterpriseOid() {
        if (this.enterpriseOid != null) {
            return this.enterpriseOid;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.enterprise;
        }
        return this.calculateEnterpriseOid();
    }

    private SnmpVarBindList getVarBindList(int n) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("getVarBindList", "Calculate varbindlist for version : " + n);
        }
        switch (n) {
            case 1: 
            case 3: {
                return this.calculateV2VarBindList();
            }
            case 0: {
                return this.calculateV1VarBindList();
            }
        }
        throw new SnmpStatusException("getVarBindList: Unable to define varBindList.");
    }

    private SnmpVarBindList getFullV2VarBindList() {
        SnmpVarBindList snmpVarBindList = this.calculateV2VarBindList();
        int n = snmpVarBindList.indexOfOid(snmpTrapOid);
        if (n == -1) {
            if (logger.finestOn()) {
                logger.finest("getFullV2VarBindList", "Must add trapOid : " + this.getTrapOid());
            }
            snmpVarBindList.insertElementAt(new SnmpVarBind(snmpTrapOid, this.getTrapOid()), 0);
        }
        if ((n = snmpVarBindList.indexOfOid(snmpTrapSysUpTimeOid)) == -1) {
            if (logger.finestOn()) {
                logger.finest("getFullV2VarBindList", "Must add timeStamp : " + this.getTimeStamp());
            }
            snmpVarBindList.insertElementAt(new SnmpVarBind(snmpTrapSysUpTimeOid, this.getTimeStamp()), 0);
        }
        if (logger.finestOn()) {
            logger.finest("getFullV2VarBindList", "List updated");
        }
        return snmpVarBindList;
    }

    private SnmpTimeticks getTimeStamp() {
        if (this.pduTrap != null) {
            return new SnmpTimeticks(this.pduTrap.timeStamp);
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int n = this.pduTrapList.indexOfOid(snmpTrapSysUpTimeOid);
            SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
            return (SnmpTimeticks)snmpVarBind.getSnmpValue();
        }
        return null;
    }

    public void sendAsNotificationOriginator() {
        this.originator = true;
    }

    public void sendAsProxy() {
        this.originator = false;
    }

    public boolean isOriginatorWay() {
        return this.originator;
    }

    public boolean isProxyWay() {
        return !this.isOriginatorWay();
    }

    public void setPduSourceAddress(InetAddress inetAddress) {
        this.pduAddr = inetAddress;
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] byArray) {
        if (byArray.length == 4) {
            return new SnmpIpAddress(byArray);
        }
        if (logger.finestOn()) {
            logger.finest("handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    private SnmpIpAddress getAgentAddr() {
        if (this.isOriginatorWay()) {
            if (this.pduAddr != null) {
                return this.handleMultipleIpVersion(this.pduAddr.getAddress());
            }
            if (logger.finestOn()) {
                logger.finest("getAgentAddr", "Originator way, let the SnmpAdaptor handling the source address");
            }
            return null;
        }
        if (this.pduTrap != null) {
            return this.pduTrap.agentAddr;
        }
        if (this.pduRequest != null || this.scopedTrap != null) {
            int n = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
            if (n != -1) {
                SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
                return (SnmpIpAddress)snmpVarBind.getSnmpValue();
            }
            return new SnmpIpAddress("0.0.0.0");
        }
        return null;
    }

    private int calculateGeneric() {
        SnmpOid snmpOid = null;
        if (this.trapOid != null) {
            snmpOid = this.trapOid;
        } else {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            snmpOid = (SnmpOid)snmpVarBind.getSnmpValue();
        }
        if (snmpOid.equals(coldStartOid)) {
            return 0;
        }
        if (snmpOid.equals(warmStartOid)) {
            return 1;
        }
        if (snmpOid.equals(linkDownOid)) {
            return 2;
        }
        if (snmpOid.equals(linkUpOid)) {
            return 3;
        }
        if (snmpOid.equals(authenticationFailureOid)) {
            return 4;
        }
        if (snmpOid.equals(egpNeighborLossOid)) {
            return 5;
        }
        return 6;
    }

    private int calculateSpecific() {
        SnmpOid snmpOid = null;
        if (this.trapOid != null) {
            snmpOid = this.trapOid;
        } else {
            SnmpVarBindList snmpVarBindList = this.pduTrapList;
            int n = snmpVarBindList.indexOfOid(snmpTrapOid);
            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
            snmpOid = (SnmpOid)snmpVarBind.getSnmpValue();
        }
        if (this.getGeneric() == 6) {
            int n = 0;
            try {
                n = (int)snmpOid.getOidArc(snmpOid.getLength() - 1);
            }
            catch (SnmpStatusException snmpStatusException) {
                // empty catch block
            }
            return n;
        }
        return 0;
    }

    private SnmpOid calculateTrapOid() {
        SnmpOid snmpOid = null;
        int n = 0;
        int n2 = 0;
        if (this.pduTrap != null) {
            n = this.pduTrap.genericTrap;
            n2 = this.pduTrap.specificTrap;
        } else {
            n = this.gen;
            n2 = this.specific;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                snmpOid = new SnmpOid(snmpTrapRadicalOid.longValue());
                snmpOid.append(n + 1);
                break;
            }
            default: {
                snmpOid = this.enterpriseOid != null ? new SnmpOid(snmpTrapEnterpriseOid.longValue()) : new SnmpOid(this.pduTrap.enterprise.longValue());
                snmpOid.append(0L);
                snmpOid.append(n2);
            }
        }
        return snmpOid;
    }

    private SnmpOid calculateEnterpriseOid() {
        int n = this.pduTrapList.indexOfOid(snmpTrapOid);
        if (n == -1) {
            return null;
        }
        SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(n);
        SnmpOid snmpOid = (SnmpOid)snmpVarBind.getSnmpValue();
        if (SnmpTrap.isStandardTrap(snmpOid)) {
            int n2 = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid);
            if (n2 != -1) {
                SnmpVarBind snmpVarBind2 = this.pduTrapList.getVarBindAt(n2);
                return (SnmpOid)snmpVarBind2.getSnmpValue();
            }
            return snmpTrapsOid;
        }
        long[] lArray = snmpOid.longValue();
        long l = lArray[lArray.length - 2];
        int n3 = 0;
        n3 = l == 0L ? 2 : 1;
        long[] lArray2 = new long[lArray.length - n3];
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = lArray[i];
        }
        return new SnmpOid(lArray2);
    }

    private static boolean isStandardTrap(SnmpOid snmpOid) {
        return snmpOid.equals(coldStartOid) || snmpOid.equals(warmStartOid) || snmpOid.equals(linkUpOid) || snmpOid.equals(linkDownOid) || snmpOid.equals(authenticationFailureOid) || snmpOid.equals(egpNeighborLossOid);
    }

    private SnmpVarBindList calculateV1VarBindList() throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        for (int i = 0; i < this.pduTrapList.size(); ++i) {
            SnmpVarBind snmpVarBind = this.pduTrapList.getVarBindAt(i);
            if (snmpVarBind.getSnmpValue() instanceof SnmpCounter64) {
                throw new SnmpStatusException(2, i);
            }
            snmpVarBindList.addVarBind(snmpVarBind);
        }
        return snmpVarBindList;
    }

    private SnmpVarBindList calculateV2VarBindList() {
        if (this.pduTrap == null) {
            return this.pduTrapList;
        }
        if (this.isOriginatorWay()) {
            return this.pduTrapList;
        }
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList(this.pduTrapList);
        boolean bl = false;
        int n = this.pduTrapList.indexOfOid(snmpTrapAddressOid);
        if (n == -1) {
            bl = true;
        }
        if ((n = this.pduTrapList.indexOfOid(snmpTrapCommunityOid)) == -1) {
            bl = true;
        }
        if ((n = this.pduTrapList.indexOfOid(snmpTrapEnterpriseOid)) == -1) {
            bl = true;
        }
        if (bl) {
            if (logger.finestOn()) {
                logger.finest("calculateV2VarBindList", "Must add varbind");
            }
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapAddressOid, this.pduTrap.agentAddr));
            SnmpString snmpString = new SnmpString(this.pduTrap.community);
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapCommunityOid, snmpString));
            snmpVarBindList.addVarBind(new SnmpVarBind(snmpTrapEnterpriseOid, this.pduTrap.enterprise));
        }
        return snmpVarBindList;
    }

    private void convertPduList(SnmpVarBind[] snmpVarBindArray) {
        this.pduTrapList = new SnmpVarBindList();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            this.pduTrapList.addVarBind(snmpVarBindArray[i]);
        }
    }

    private SnmpVarBind[] toVarBindArray(SnmpVarBindList snmpVarBindList) {
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpVarBindList.size()];
        for (int i = 0; i < snmpVarBindList.size(); ++i) {
            snmpVarBindArray[i] = snmpVarBindList.getVarBindAt(i);
        }
        return snmpVarBindArray;
    }

    private void initialize(InetAddress inetAddress, String string, SnmpVarBindList snmpVarBindList) {
        this.address = inetAddress;
        this.communityString = string;
        this.pduTrapList = snmpVarBindList;
    }
}

