/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.comm.SnmpV3ResponseHandler;
import com.sun.management.comm.SnmpV3Session;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpV3Message;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import java.io.IOException;
import java.net.InetAddress;

public class SnmpV3InformRequest
extends SnmpInformRequest {
    private SnmpV3ResponseHandler respHandler = null;
    private SnmpScopedPduRequest v3pdu = null;
    private SnmpV3AdaptorServer v3adaptor = null;
    private SnmpVarBindList reportVarBindList = null;
    private String dbgTag = "SnmpV3InformRequest";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpV3InformRequest");

    SnmpV3InformRequest(SnmpV3Session snmpV3Session, SnmpV3ResponseHandler snmpV3ResponseHandler, SnmpV3AdaptorServer snmpV3AdaptorServer, InetAddress inetAddress, SnmpScopedPduRequest snmpScopedPduRequest, SnmpInformHandler snmpInformHandler) throws SnmpStatusException {
        super(snmpV3Session, snmpV3AdaptorServer, inetAddress, null, snmpScopedPduRequest.port, snmpInformHandler);
        this.respHandler = snmpV3ResponseHandler;
        this.v3adaptor = snmpV3AdaptorServer;
        this.v3pdu = snmpScopedPduRequest;
        snmpScopedPduRequest.type = 166;
        snmpScopedPduRequest.version = 3;
        snmpScopedPduRequest.address = inetAddress;
    }

    public SnmpVarBindList getReportVarBindList() {
        return this.reportVarBindList;
    }

    synchronized void parsePduPacket(SnmpPduRequestType snmpPduRequestType) {
        if (snmpPduRequestType == null) {
            return;
        }
        if (logger.finerOn()) {
            logger.finer("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
        this.errorStatus = snmpPduRequestType.getErrorStatus();
        this.errorIndex = snmpPduRequestType.getErrorIndex();
        if (this.errorStatus == 0) {
            if (((SnmpPdu)((Object)snmpPduRequestType)).type == 168) {
                if (logger.finerOn()) {
                    logger.finer("parsePduPacket", "received inform report.");
                }
                this.updateReportVarBindList(((SnmpPdu)((Object)snmpPduRequestType)).varBindList);
            } else {
                if (logger.finerOn()) {
                    logger.finer("parsePduPacket", "received inform reponse.");
                }
                this.updateInternalVarBindWithResult(((SnmpPdu)((Object)snmpPduRequestType)).varBindList);
            }
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        if (logger.finerOn()) {
            logger.finer("parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private void updateReportVarBindList(SnmpVarBind[] snmpVarBindArray) {
        this.reportVarBindList = new SnmpVarBindList();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[i];
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.getOid(), snmpVarBind.getSnmpValue());
            this.reportVarBindList.addVarBind(snmpVarBind2);
        }
    }

    synchronized SnmpPdu constructPduPacket() {
        this.v3pdu.varBindList = this.internalVarBind;
        this.v3pdu.requestId = this.getRequestId();
        this.v3pdu.msgFlags = (byte)(this.v3pdu.msgFlags | 4);
        return this.v3pdu;
    }

    public boolean isReport() {
        if (this.responsePdu == null) {
            if (logger.finestOn()) {
                logger.finest("isReport", "responsePdu is null");
            }
            return false;
        }
        if (logger.finestOn()) {
            logger.finest("isReport", "responsePdu not null");
        }
        return ((SnmpPdu)((Object)this.responsePdu)).type == 168;
    }

    public boolean isResponse() {
        if (this.responsePdu == null) {
            if (logger.finestOn()) {
                logger.finest("isResponse", "responsePdu is null");
            }
            return false;
        }
        if (logger.finestOn()) {
            logger.finest("isResponse", "responsePdu not null");
        }
        return ((SnmpPdu)((Object)this.responsePdu)).type == 162;
    }

    boolean sendPdu() {
        try {
            this.responsePdu = null;
            this.reportVarBindList = null;
            SnmpPduFactory snmpPduFactory = this.v3adaptor.getPduFactory();
            SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.v3adaptor.getEngine();
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
            SnmpOutgoingRequest snmpOutgoingRequest = snmpMsgProcessingSubSystem.getOutgoingRequest(3, snmpPduFactory);
            SnmpMsg snmpMsg = snmpOutgoingRequest.encodeSnmpPdu(this.requestPdu, this.v3adaptor.getBufferSize());
            if (snmpMsg == null) {
                if (logger.finestOn()) {
                    logger.finest("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            ((SnmpV3Message)snmpMsg).msgId = this.getRequestId();
            int n = this.v3adaptor.getBufferSize();
            byte[] byArray = new byte[n];
            int n2 = snmpOutgoingRequest.encodeMessage(byArray);
            if (logger.finerOn()) {
                logger.finer("sendPdu", "Dump : \n" + snmpMsg.printMessage());
            }
            this.respHandler.setSecurityCache(snmpOutgoingRequest.getSecurityCache());
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (logger.finestOn()) {
                logger.finest("sendPdu", "Packet Overflow while building inform request");
            }
        }
        catch (IOException iOException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", iOException.toString());
            }
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpSecurityException.toString());
            }
            this.setErrorStatusAndIndex(snmpSecurityException.status, 0);
            this.reason = snmpSecurityException.getMessage();
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpUnknownMsgProcModelException.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = snmpUnknownMsgProcModelException.getMessage();
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", snmpUnknownSecModelException.toString());
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = snmpUnknownSecModelException.getMessage();
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", snmpBadSecurityLevelException.toString());
            }
            this.setErrorStatusAndIndex(249, 0);
            this.reason = snmpBadSecurityLevelException.getMessage();
        }
        catch (SnmpStatusException snmpStatusException) {
            if (logger.finerOn()) {
                logger.finer("sendPdu", snmpStatusException.toString());
            }
            this.setErrorStatusAndIndex(snmpStatusException.getStatus(), 0);
            this.reason = snmpStatusException.getMessage();
        }
        return false;
    }
}

