/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMonitor;
import com.sun.jdmk.discovery.DiscoveryResponderNotification;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.management.remote.JMXServiceURL;

class ActualMonitor
extends DiscoveryCommon
implements Serializable {
    private static final long serialVersionUID = 3370752883861960954L;
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "ActualMonitor");
    private static long sequenceNumber = 0L;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private Thread listeningThread = null;
    private volatile boolean stopRequested = false;
    private transient int state = 1;
    private transient DiscoveryMonitor monitor = null;
    private Vector listeners = new Vector();
    private final int[] lock = new int[0];

    public ActualMonitor(String string, int n, DiscoveryMonitor discoveryMonitor) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualMonitor";
        if (this.logger.finerOn()) {
            this.logger.finer("constructor ", "initialize multicast socket");
        }
        this.multicastGroup = string;
        this.multicastPort = n;
        this.monitor = discoveryMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block11: {
            if (this.logger.finerOn()) {
                this.logger.finer("run ", "start");
            }
            try {
                this.connectToGroup();
            }
            catch (IOException iOException) {
                int[] nArray = this.lock;
                // MONITORENTER : this.lock
                this.stopRequested = true;
                // MONITOREXIT : nArray
            }
            while (!this.stopped()) {
                this.monitor.changeState(0);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run ", "Start Waiting ");
                    }
                    ResponsePDU responsePDU = (ResponsePDU)this.receiveMsg(this);
                    this.processMsg(responsePDU);
                }
                catch (Exception exception) {
                    if (this.stopped()) break;
                    if (!this.logger.finestOn()) continue;
                    this.logger.finest("run ", "Got exception: " + exception.toString(), exception);
                }
            }
            try {
                this.monitor.changeState(1);
                this.disconnectFromGroup();
                this.close();
            }
            catch (IOException iOException) {
                if (this.stopped() || !this.logger.finestOn()) break block11;
                this.logger.finest("run ", iOException);
            }
        }
        if (!this.logger.finestOn()) return;
        this.logger.finest("run ", "stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            block6: {
                if (this.stopRequested) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.stopRequested = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    this.close();
                }
                catch (Exception exception) {
                    if (!this.logger.finestOn()) break block6;
                    this.logger.finest("stopMonitor ", "Got exception during closing.", exception);
                }
            }
            return;
        }
    }

    private void processMsg(ResponsePDU responsePDU) throws IOException {
        if (responsePDU == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "received a nul pdu '");
            }
            return;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "received pdu '" + responsePDU.printState() + "'");
        }
        if (!responsePDU.getEvent()) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "not an event message");
            }
            return;
        }
        DiscoveryResponse discoveryResponse = new DiscoveryResponse();
        discoveryResponse.host = responsePDU.getHost();
        discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
        discoveryResponse.specificationName = responsePDU.getSpecificationName();
        discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
        discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
        discoveryResponse.implementationName = responsePDU.getImplementationName();
        discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
        discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
        discoveryResponse.objectList = responsePDU.getObjectList();
        discoveryResponse.userData = responsePDU.getUserData();
        discoveryResponse.serverAddresses = responsePDU.serverAddresses != null ? responsePDU.serverAddresses : new JMXServiceURL[0];
        DiscoveryResponderNotification discoveryResponderNotification = new DiscoveryResponderNotification(this.monitor, responsePDU.getAgentState(), discoveryResponse, sequenceNumber++);
        this.monitor.sendNotification(discoveryResponderNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopped() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.stopRequested;
        }
    }
}

