/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import javax.management.remote.JMXServiceURL;

class ActualDiscovery
extends DiscoveryCommon {
    private boolean PointToPointResponse = true;
    private int RETURN_PORT_MIN_VAL = 1024;
    private int RETURN_PORT_MAX_VAL = this.RETURN_PORT_MIN_VAL * 10;
    private int ttl = 1;
    private int defaultTtl = 1;
    private int timeOut = 1000;
    private String timeStamp = null;
    public Vector returnValue = new Vector();
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "ActualDiscovery");

    public ActualDiscovery(String string, int n) throws IOException {
        super(string, n);
        this.localClassName = "com.sun.jdmk.discovery.ActualDiscovery";
        if (this.logger.finerOn()) {
            this.logger.finer("constructor", "group = " + string + ", " + "port  = " + n);
        }
    }

    public void setTimeOut(int n) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("setTimeOut", "set to " + n);
        }
        this.setSoTimeout(n);
        this.timeOut = n;
    }

    public int getTimeOut() {
        if (this.logger.finerOn()) {
            this.logger.finer("getTimeOut", "Value = " + this.timeOut);
        }
        return this.timeOut;
    }

    public void setTimeToLive(int n) throws IOException {
        try {
            super.setTimeToLive(n);
        }
        catch (IOException iOException) {
            if (this.logger.finestOn()) {
                this.logger.finest("setTimeToLive", "Unable to set Time-to-live to " + n);
            }
            throw iOException;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("Time-to-live", "Set Time-to-live to " + n);
        }
        this.ttl = n;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean getPointToPointResponse() {
        return this.PointToPointResponse;
    }

    public void setPointToPointResponse(boolean bl) {
        if (this.logger.finerOn()) {
            this.logger.finer("setPointToPointResponse", "setPointToPointResponse to " + bl);
        }
        this.PointToPointResponse = bl;
    }

    public Vector findCommunicators(boolean bl, String string) throws IOException {
        return this.getObject(bl, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getObject(boolean bl, String string) throws IOException {
        Thread thread;
        ReceivedMsgObj receivedMsgObj;
        block23: {
            InetAddress inetAddress;
            this.returnValue = new Vector();
            DatagramSocket datagramSocket = null;
            int n = this.RETURN_PORT_MIN_VAL;
            String string2 = null;
            if (!this.getInterface().getHostAddress().equals("0.0.0.0")) {
                inetAddress = this.getInterface();
                string2 = inetAddress.getHostAddress();
            } else {
                inetAddress = this.getLocalHostAddr();
                string2 = this.getLocalHostName();
            }
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", " returnAddr is set to " + inetAddress);
            }
            if (this.getPointToPointResponse()) {
                if (this.logger.finerOn()) {
                    this.logger.finer("getObject", "Create datagram socket for response");
                }
                while (n < this.RETURN_PORT_MAX_VAL) {
                    try {
                        datagramSocket = new DatagramSocket(n, inetAddress);
                        datagramSocket.setSoTimeout(this.getTimeOut());
                        break;
                    }
                    catch (BindException bindException) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("getObject", " try port " + n);
                        }
                        ++n;
                    }
                }
                if (n == this.RETURN_PORT_MAX_VAL) {
                    throw new IOException("Address already in use");
                }
            } else {
                if (this.logger.finerOn()) {
                    this.logger.finer("getObject", "Use multicast socket for response");
                }
                datagramSocket = this;
            }
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Format msg");
            }
            DiscoveryPDU discoveryPDU = new DiscoveryPDU();
            this.formatPdu(discoveryPDU, bl, string, n, inetAddress, string2);
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Create a thread to get responses");
            }
            receivedMsgObj = new ReceivedMsgObj(datagramSocket, this);
            thread = new Thread(receivedMsgObj);
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Send the multicast query");
            }
            this.sendMsg(discoveryPDU, this.multicastGroup, this.multicastPort);
            thread.start();
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Sleep before receiving");
            }
            try {
                Thread.sleep(this.getTimeOut());
            }
            catch (InterruptedException interruptedException) {
                if (!this.logger.finestOn()) break block23;
                this.logger.finest("getObject", interruptedException);
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("getObject", "Stop receiving");
        }
        receivedMsgObj.stopRequested = true;
        Boolean bl2 = receivedMsgObj.interrupted;
        synchronized (bl2) {
            if (!receivedMsgObj.interrupted.booleanValue()) {
                thread.interrupt();
            }
        }
        return this.returnValue;
    }

    private void formatPdu(DiscoveryPDU discoveryPDU, boolean bl, String string, int n, InetAddress inetAddress, String string2) {
        String string3 = new Long(new Date().getTime()).toString();
        this.timeStamp = string2 + ":" + string3;
        discoveryPDU.setTimeStamp(string2 + ":" + string3);
        discoveryPDU.setEmittedGroup(this.multicastGroup);
        if (this.getPointToPointResponse()) {
            if (this.logger.finerOn()) {
                this.logger.finer("formatPdu", "set return addr to " + inetAddress + ":" + n);
            }
            discoveryPDU.setReturnaddr(inetAddress, n);
        }
        discoveryPDU.setHost(string);
        discoveryPDU.setTimeOut(this.getTimeOut());
        discoveryPDU.setTimeToLive(this.getTimeToLive());
        discoveryPDU.setObjectRequired(bl);
    }

    class ReceivedMsgObj
    implements Runnable {
        public Vector result = new Vector();
        public volatile boolean stopRequested = false;
        public Boolean interrupted = new Boolean(false);
        private ActualDiscovery discovery;
        private DatagramSocket socket;

        ReceivedMsgObj(DatagramSocket datagramSocket, ActualDiscovery actualDiscovery2) {
            this.socket = datagramSocket;
            this.discovery = actualDiscovery2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int n = 0;
            try {
                while (!this.stopRequested) {
                    try {
                        DiscoveryMsg discoveryMsg = ActualDiscovery.this.receiveMsg(this.socket);
                        if (discoveryMsg == null) {
                            if (!ActualDiscovery.this.logger.finerOn()) continue;
                            ActualDiscovery.this.logger.finer("receivedMsg", "Null msg - continue - ");
                            continue;
                        }
                        ResponsePDU responsePDU = (ResponsePDU)discoveryMsg;
                        if (this.discovery.timeStamp.compareTo(responsePDU.getTimeStamp()) != 0) {
                            if (!ActualDiscovery.this.logger.finerOn()) continue;
                            ActualDiscovery.this.logger.finer("receivedMsg", "Msg is not for us : local timeStamp = " + this.discovery.timeStamp + " ; received timeStamp =  " + responsePDU.getTimeStamp());
                            continue;
                        }
                        DiscoveryResponse discoveryResponse = this.TranslatePDU(responsePDU);
                        this.discovery.returnValue.addElement(discoveryResponse);
                        ++n;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.stopRequested = true;
                        if (!ActualDiscovery.this.logger.finerOn()) continue;
                        ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                        ActualDiscovery.this.logger.finer("receivedMsg", "Got " + n + " responses");
                    }
                    catch (InvalidClassException invalidClassException) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", invalidClassException);
                    }
                    catch (ClassCastException classCastException) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", classCastException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", classNotFoundException);
                    }
                    catch (IOException iOException) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", iOException);
                    }
                }
                Object var6_10 = null;
                Boolean bl = this.interrupted;
                // MONITORENTER : bl
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
                // MONITOREXIT : bl
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.logger.finer("receivedMsg", "Got " + n + " responses");
                }
                if (!this.discovery.getPointToPointResponse()) return;
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "Close datagram socket");
                }
                this.socket.close();
                return;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                Boolean bl = this.interrupted;
                // MONITORENTER : bl
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
                // MONITOREXIT : bl
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.logger.finer("receivedMsg", "Got " + n + " responses");
                }
                if (!this.discovery.getPointToPointResponse()) throw throwable;
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "Close datagram socket");
                }
                this.socket.close();
                throw throwable;
            }
        }

        private DiscoveryResponse TranslatePDU(ResponsePDU responsePDU) {
            DiscoveryResponse discoveryResponse = new DiscoveryResponse();
            discoveryResponse.host = responsePDU.getHost();
            discoveryResponse.mbeanServerId = responsePDU.getMbeanServerId();
            discoveryResponse.specificationName = responsePDU.getSpecificationName();
            discoveryResponse.specificationVendor = responsePDU.getSpecificationVendor();
            discoveryResponse.specificationVersion = responsePDU.getSpecificationVersion();
            discoveryResponse.implementationName = responsePDU.getImplementationName();
            discoveryResponse.implementationVendor = responsePDU.getImplementationVendor();
            discoveryResponse.implementationVersion = responsePDU.getImplementationVersion();
            discoveryResponse.userData = responsePDU.getUserData();
            discoveryResponse.objectList = responsePDU.getObjectList();
            discoveryResponse.serverAddresses = responsePDU.serverAddresses != null ? responsePDU.serverAddresses : new JMXServiceURL[0];
            return discoveryResponse;
        }
    }
}

