/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpRequestHandler;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class GenericHttpConnectorServer
extends CommunicatorServer {
    transient GenericHttpSocket sockListen = null;
    InetAddress addrLastClient = null;
    Vector authInfo = new Vector();
    int index = 0;
    final int MAX_CHALLENGES = 100;
    String[] challengeList = new String[100];
    ServerNotificationDispatcher serverNotificationDispatcher = null;
    HeartBeatServerHandler heartbeatServerHandler = null;
    InetAddress bindAddr = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    abstract GenericHttpSocket createSocket();

    abstract GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress var1);

    public GenericHttpConnectorServer(int n) throws IllegalArgumentException {
        super(n);
        this.maxActiveClientCount = 10;
    }

    public GenericHttpConnectorServer(int n, int n2) throws IllegalArgumentException {
        this(n);
        this.port = n2;
    }

    public GenericHttpConnectorServer(int n, int n2, AuthInfo[] authInfoArray) throws IllegalArgumentException {
        this(n, n2);
        if (authInfoArray != null) {
            for (int i = 0; i < authInfoArray.length; ++i) {
                this.addUserAuthenticationInfo(authInfoArray[i]);
            }
        }
    }

    public GenericHttpConnectorServer(int n, int n2, InetAddress inetAddress) throws IllegalArgumentException {
        this(n);
        this.port = n2;
        this.bindAddr = inetAddress;
    }

    public GenericHttpConnectorServer(int n, int n2, AuthInfo[] authInfoArray, InetAddress inetAddress) throws IllegalArgumentException {
        this(n, n2, inetAddress);
        if (authInfoArray != null) {
            for (int i = 0; i < authInfoArray.length; ++i) {
                this.addUserAuthenticationInfo(authInfoArray[i]);
            }
        }
    }

    NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
        if (connectorAddress == null) {
            throw new IllegalArgumentException("ConnectorAddress cannot be null");
        }
        if (!(connectorAddress instanceof GenericHttpConnectorAddress)) {
            throw new IllegalArgumentException("ConnectorAddress must be an instance of GenericHttpConnectorAddress");
        }
        GenericHttpNotificationForwarder genericHttpNotificationForwarder = null;
        try {
            if (this.logger.finestOn()) {
                this.logger.finest("startPush", "Create new NotificationForwarder");
            }
            genericHttpNotificationForwarder = this.getNotificationForwarder((GenericHttpConnectorAddress)connectorAddress);
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("startPush", "Start forwarding events");
        }
        genericHttpNotificationForwarder.connect();
        return genericHttpNotificationForwarder;
    }

    void stopPush(NotificationBackConnector notificationBackConnector) {
        if (!(notificationBackConnector instanceof GenericHttpNotificationForwarder)) {
            throw new IllegalArgumentException("NotificationBackConnector must be an instance of GenericHttpNotificationForwarder");
        }
        ((GenericHttpNotificationForwarder)notificationBackConnector).disconnect();
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return super.preRegister(mBeanServer, objectName);
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
        NotificationHandlerInternal notificationHandlerInternal = new NotificationHandlerInternal(this);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(notificationHandlerInternal, this.topMBS);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.topMBS, this.serverNotificationDispatcher);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doBind() throws InterruptedException, CommunicationException {
        try {
            if (this.bindAddr == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doBind", "about to bind to port " + this.port);
                }
                this.sockListen = this.createSocket().createServerSocket(this.port);
            } else {
                if (this.logger.finerOn()) {
                    this.logger.finer("doBind", "about to bind to address:port " + this.bindAddr + ":" + this.port);
                }
                this.sockListen = this.createSocket().createServerSocket(this.port, this.bindAddr);
            }
            this.sockListen.doBind();
            this.port = this.sockListen.getLocalPort();
            this.dbgTag = this.makeDebugTag();
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", this.sockListen.toString() + " bound to " + this.sockListen.getLocalAddress() + " port " + this.sockListen.getLocalPort());
            }
        }
        catch (SocketException socketException) {
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", "EXCEPTION MSG = '" + socketException.getMessage() + "'");
            }
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    protected void doReceive() throws InterruptedException, CommunicationException {
        try {
            this.sockListen.doReceive();
            this.addrLastClient = this.sockListen.getRemoteAddress();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(iOException.toString());
            }
            throw new CommunicationException(iOException);
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            if (this.logger.finerOn()) {
                this.logger.finer("doReceive", "EXCEPTION MSG = '" + exception.getMessage() + "'");
            }
            throw new InterruptedException();
        }
    }

    protected void doProcess() throws InterruptedException, CommunicationException {
        if (this.logger.finerOn()) {
            this.logger.finer("doProcess", "Address of last connected client [" + this.addrLastClient + "]");
        }
        GenericHttpRequestHandler genericHttpRequestHandler = new GenericHttpRequestHandler(this, this.getServedClientCount(), (GenericHttpSocket)this.sockListen.clone(), this.topMBS, this.objectName);
    }

    protected void doUnbind() throws InterruptedException, CommunicationException {
        try {
            if (this.sockListen != null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doUnbind", "Port [" + this.port + "] has been definitively closed");
                }
                this.sockListen.doUnbind();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            throw new CommunicationException(iOException);
        }
    }

    String makeDebugTag() {
        return "GenericHttpConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    public void stop() {
        if (this.state == 0 || this.state == 3) {
            super.stop();
            this.heartbeatServerHandler.cleanupClientResources();
            try {
                GenericHttpSocket genericHttpSocket = this.sockListen.createClientSocket();
                if (System.getProperty("jdmk.hostname") != null) {
                    genericHttpSocket.doConnect(System.getProperty("jdmk.hostname"), this.port);
                } else {
                    genericHttpSocket.doConnect(InetAddress.getLocalHost().getHostAddress(), this.port);
                }
                genericHttpSocket.doSend("", null);
                genericHttpSocket.doDisconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) throws IllegalArgumentException, IllegalStateException {
        super.setMBeanServer(mBeanServer);
        this.serverNotificationDispatcher.setMBeanServer(mBeanServer);
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return "unknown";
        }
        return this.addrLastClient.toString();
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
            this.authInfo.addElement(authInfo);
        }
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authInfo) {
        if (authInfo != null) {
            String string = authInfo.getLogin();
            Enumeration enumeration = this.authInfo.elements();
            while (enumeration.hasMoreElements()) {
                AuthInfo authInfo2 = (AuthInfo)enumeration.nextElement();
                if (!authInfo2.getLogin().equals(string)) continue;
                this.authInfo.removeElement(authInfo2);
                break;
            }
        }
    }

    public boolean isAuthenticationOn() {
        return !this.authInfo.isEmpty();
    }

    synchronized String generateChallengeResponse() {
        Object object;
        String string = null;
        try {
            if (System.getProperty("jdmk.hostname") != null) {
                string = System.getProperty("jdmk.hostname");
            } else {
                object = InetAddress.getLocalHost();
                string = ((InetAddress)object).getHostName();
            }
            if (this.logger.finerOn()) {
                this.logger.finer("generateChallengeResponse", "hostname=" + string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            string = "UnknownHost";
        }
        object = "<" + System.currentTimeMillis() + "@" + string + ">";
        if (this.index == 100) {
            this.index = 0;
        }
        this.challengeList[this.index] = object;
        ++this.index;
        return object;
    }

    synchronized AuthInfo checkChallengeResponse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.substring(0, string.lastIndexOf(32));
        String string3 = string.substring(string.lastIndexOf(32) + 1);
        AuthInfo authInfo = null;
        boolean bl = false;
        Object object = this.authInfo.elements();
        while (object.hasMoreElements()) {
            authInfo = (AuthInfo)object.nextElement();
            if (!authInfo.getLogin().equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        object = authInfo.getPassword().getBytes();
        for (int i = 0; i < 100; ++i) {
            String string4;
            String string5 = this.challengeList[i];
            if (string5 == null || !string3.equals(string4 = this.HMAC_MD5(string5.getBytes(), (byte[])object))) continue;
            this.challengeList[i] = null;
            return authInfo;
        }
        return null;
    }

    private String HMAC_MD5(byte[] byArray, byte[] byArray2) {
        int n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (byArray2.length > 64) {
            byArray2 = messageDigest.digest(byArray2);
        }
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        for (n = 0; n < 64; ++n) {
            while (n < byArray2.length) {
                byArray3[n] = byArray2[n];
                byArray4[n] = byArray2[n];
                ++n;
            }
            byArray3[n] = 0;
            byArray4[n] = 0;
        }
        n = 0;
        while (n < 64) {
            int n2 = n;
            byArray3[n2] = (byte)(byArray3[n2] ^ 0x36);
            int n3 = n++;
            byArray4[n3] = (byte)(byArray4[n3] ^ 0x5C);
        }
        messageDigest.update(byArray3);
        messageDigest.update(byArray);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < byArray5.length; ++n) {
            if ((byArray5[n] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray5[n] & 0xFF));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray5[n] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private GenericHttpConnectorServer connector;

        public NotificationHandlerInternal(GenericHttpConnectorServer genericHttpConnectorServer2) {
            this.connector = genericHttpConnectorServer2;
        }

        public NotificationBackConnector startPush(ConnectorAddress connectorAddress) {
            return this.connector.startPush(connectorAddress);
        }

        public void stopPush(NotificationBackConnector notificationBackConnector) {
            this.connector.stopPush(notificationBackConnector);
        }
    }
}

