/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

public class ScEncrypt {
    private static final char SC_M_CRYPT_CHAIN_INIT = 'r';
    private static final char[] SC_V_CRYPT_DFT_KEY = new char[]{'\u0083', ':', '\u00fc', '\u00e9', 'G', '\u0095', '!', 'm', '\u00be', '\u007f', '\u00a2', 'T', '\u00c6', '\u00db', '\u0018', '\u0000'};
    private static final short[] SC_V_CRYPT_PIN = new short[]{3, 5, 15, 6, 12, 9, 2, 0, 13, 10, 7, 4, 1, 14, 11, 8};
    private static final short[] SC_V_CRYPT_POU = new short[]{7, 12, 6, 0, 11, 1, 3, 10, 15, 5, 9, 14, 4, 8, 13, 2};

    public static String decrypt(String key, String data) {
        int count;
        char[] code = new char[data.length() / 2];
        ScSCrypt crypt = new ScSCrypt(key);
        int dataPtr = 0;
        char[] lenTmp = new char[]{data.charAt(dataPtr)};
        char[] ctmp = new char[2];
        for (count = 0; count < data.length() / 2; ++count) {
            ctmp[0] = data.charAt(dataPtr);
            ctmp[1] = data.charAt(dataPtr + 1);
            int num = Integer.parseInt(new String(ctmp), 16);
            code[count] = (char)num;
            dataPtr += 2;
        }
        dataPtr = 0;
        int codePtr = 0;
        int length = code[codePtr];
        ++codePtr;
        char[] out = new char[length];
        for (count = 0; count < length; ++count) {
            char abyte = code[codePtr];
            crypt.chain = (char)(crypt.chain << 2 & 0xFF);
            abyte = (char)(abyte ^ crypt.chain);
            crypt.chain = code[codePtr];
            char lbyte = (char)(abyte >> 4);
            char rbyte = (char)(abyte & 0xF);
            lbyte = (char)(lbyte ^ crypt.keySpace[crypt.currKey]);
            crypt.currKey++;
            rbyte = (char)(rbyte ^ crypt.keySpace[crypt.currKey]);
            crypt.currKey++;
            lbyte = (char)SC_V_CRYPT_POU[lbyte];
            rbyte = (char)SC_V_CRYPT_POU[rbyte];
            out[count] = (char)(0xFF & (lbyte << 4 | rbyte));
            ++codePtr;
            ++dataPtr;
            if (crypt.getCurrKey() != crypt.getEndSpace()) continue;
            crypt.extend();
        }
        String decrypt = new String(out);
        return decrypt;
    }

    public static String encrypt(String key, String data) {
        char[] code = new char[data.length() * 2 + 2];
        ScSCrypt crypt = new ScSCrypt(key);
        int length = data.length();
        int dataPtr = 0;
        int codePtr = 0;
        code[codePtr] = (char)length;
        ++codePtr;
        ++length;
        for (int i = 0; i < data.length(); ++i) {
            char lbyte = (char)(data.charAt(dataPtr) >> 4);
            char rbyte = (char)(data.charAt(dataPtr) & 0xF);
            lbyte = (char)SC_V_CRYPT_PIN[lbyte];
            rbyte = (char)SC_V_CRYPT_PIN[rbyte];
            lbyte = (char)(lbyte ^ crypt.keySpace[crypt.currKey]);
            crypt.currKey++;
            rbyte = (char)(rbyte ^ crypt.keySpace[crypt.currKey]);
            crypt.currKey++;
            code[codePtr] = (char)(0xFF & (lbyte << 4 | rbyte));
            crypt.chain = (char)(crypt.chain << 2 & 0xFF);
            int n = codePtr;
            code[n] = (char)(code[n] ^ crypt.chain);
            crypt.chain = code[codePtr];
            ++codePtr;
            ++dataPtr;
            if (crypt.getCurrKey() != crypt.getEndSpace()) continue;
            crypt.extend();
        }
        String out = "";
        for (int count = 0; count < length; ++count) {
            String digits = Integer.toHexString(code[count]).toUpperCase();
            if (digits.length() == 1) {
                digits = "0" + digits;
            }
            out = out + digits;
        }
        return out;
    }

    public static class ScSCrypt {
        private char chain;
        private int currKey;
        private int endSpace;
        private char[] keySpace;

        public ScSCrypt(String key) {
            String keyPtr = key == null || key.length() == 0 ? new String(SC_V_CRYPT_DFT_KEY) : key;
            this.keySpace = new char[keyPtr.length() * 2];
            this.currKey = 0;
            for (int i = 0; i < keyPtr.length(); ++i) {
                int lookupIndex = keyPtr.charAt(i) >> 4;
                this.keySpace[this.currKey] = (char)SC_V_CRYPT_PIN[lookupIndex];
                ++this.currKey;
                lookupIndex = keyPtr.charAt(i) & 0xF;
                this.keySpace[this.currKey] = (char)SC_V_CRYPT_PIN[lookupIndex];
                ++this.currKey;
            }
            this.endSpace = this.currKey;
            this.currKey = 0;
            this.chain = (char)114;
        }

        void extend() {
            for (int i = 0; i < this.keySpace.length; ++i) {
                this.keySpace[i] = (char)SC_V_CRYPT_PIN[this.keySpace[i]];
            }
            this.currKey = 0;
        }

        char getChain() {
            return this.chain;
        }

        int getCurrKey() {
            return this.currKey;
        }

        int getEndSpace() {
            return this.endSpace;
        }

        char[] getKeySpace() {
            return this.keySpace;
        }
    }
}

