/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.jdbc.SQLUtils;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Transformer
extends SimpleTask {
    private static final String LOG_CATEGORY = Transformer.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    private Connection con;

    public void cleanUp() {
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        Logger.print(10000, LOG_CATEGORY, "Handling exception for Transformer....");
        Logger.printThrowable(10000, LOG_CATEGORY, this.DN, ex.getMessage(), ex);
        if (this.con != null) {
            DBConnectionFactory.getInstance().closeConnection(this.con);
            this.con = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException("Transformer task node is null....");
        }
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        String msg = MSG_MGR.getString("MSG_transformer_started");
        node.fireETLEngineLogEvent(msg, 10000);
        SQLPart transformSQLPart = this.getTransformSQLPart(node);
        List connList = node.getParent().getConnectionDefList();
        this.con = null;
        PreparedStatement stmt = null;
        String conName = transformSQLPart.getConnectionPoolName();
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        try {
            Timestamp startTime = super.createExecutionEntryInSummaryTable(node);
            stats.setTableStartTime(node.getTableName(), startTime);
            int executionId = super.getExecutionEntryIdFromSummaryTable(node, startTime);
            stats.setTableExecutionId(node.getTableName(), executionId);
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(3, node.getTableName(), "" + executionId);
            node.fireETLEngineExecutionEvent(evnt);
            this.con = this.getConnection(conName, connList);
            Logger.print(10000, LOG_CATEGORY, "Transformer<" + node.getId() + "> - got connection: " + this.con);
            if (!this.createBeforeProcess(node, this.con)) {
                this.truncateBeforeProcess(node, this.con);
            }
            String startMsg = MSG_MGR.getString("MSG_transformer_insert_attempt");
            node.fireETLEngineLogEvent(startMsg);
            ArrayList paramList = new ArrayList();
            Map attribMap = node.getParent().getInputAttrMap();
            long insertCt = 0L;
            Iterator stmtIter = transformSQLPart.getIterator();
            while (stmtIter.hasNext()) {
                String currStmt = (String)stmtIter.next();
                currStmt = SQLUtils.replaceTableNameFromRuntimeArguments(currStmt, attribMap);
                String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", currStmt);
                node.fireETLEngineLogEvent(showSqlMsg, 10000);
                String ps = SQLUtils.createPreparedStatement(currStmt, attribMap, paramList);
                stmt = this.con.prepareStatement(ps);
                SQLUtils.populatePreparedStatement(stmt, attribMap, paramList);
                int rows = stmt.executeUpdate();
                insertCt += rows > 0 ? (long)rows : 0L;
                if (rows == -3) {
                    String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", currStmt);
                    node.fireETLEngineLogEvent(errMsg, 40000);
                }
                stmt.close();
            }
            this.updateInsertStats(node, insertCt);
            context.commitLater(this.con);
            String successMsg = MSG_MGR.getString("MSG_transformer_insert_success", new Long(insertCt));
            node.fireETLEngineLogEvent(successMsg);
            evnt = new ETLEngineExecEvent(4, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            node.fireETLEngineExecutionEvent(evnt);
            this.closeStatement(stmt);
        }
        catch (Exception ex) {
            ETLEngineExecEvent evnt = new ETLEngineExecEvent(5, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
            evnt.setCause(ex);
            node.fireETLEngineExecutionEvent(evnt);
            this.handleException(node, ex);
        }
        finally {
            this.closeStatement(stmt);
        }
        String doneMsg = MSG_MGR.getString("MSG_transformer_finished");
        node.fireETLEngineLogEvent(doneMsg, 10000);
        return "Success";
    }

    private SQLPart getTransformSQLPart(ETLTaskNode node) throws ETLException {
        SQLPart transformSQLPart = node.getStatement("staticInsertStatement");
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("insertSelectStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("mergeStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("updateStatement");
        }
        if (transformSQLPart == null) {
            transformSQLPart = node.getStatement("deleteStatement");
        }
        if (transformSQLPart == null) {
            throw new ETLException("No SQL statement to execute in this transform node.");
        }
        return transformSQLPart;
    }

    private void handleException(ETLTaskNode node, Throwable t) throws ThreadDeath, ETLException {
        String msg = (t = this.unwrapThrowable(t)).getMessage();
        if (StringUtil.isNullString(msg)) {
            msg = t.toString();
        }
        String failureMsg = MSG_MGR.getString("MSG_transformer_insert_failure", msg);
        node.fireETLEngineLogEvent(failureMsg, 10000);
        if (t instanceof SQLException) {
            this.logSQLException(40000, LOG_CATEGORY, (SQLException)t);
        }
        try {
            if (this.con != null && !this.con.getAutoCommit()) {
                Logger.print(10000, LOG_CATEGORY, "Rolling back transactions");
                this.con.rollback();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.updateInsertStats(node, 0L);
        throw new ETLException(failureMsg, t);
    }

    private void updateInsertStats(ETLTaskNode node, long insertCt) {
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        Timestamp endDate = new Timestamp(System.currentTimeMillis());
        stats.setTableFinishTime(node.getTableName(), endDate);
        context.putValue(node.getTableName(), new Long(insertCt));
        stats.setRowsInsertedCount(node.getTableName(), insertCt);
    }
}

