/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngine;
import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLEngineListener;
import com.sun.etl.engine.ETLPersistableMessage;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.ETLTaskNodeImpl;
import com.sun.etl.engine.impl.ETLTaskThread;
import com.sun.etl.engine.impl.ETLTaskThreadManager;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionParameters;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.RuntimeAttribute;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ETLEngineImpl
implements ETLEngine {
    public static final String TAG_ETLENGINE = "etlengine";
    public static final String TAG_INPUTATTR = "runtimeInputs";
    public static final String TAG_OUTPUTATTR = "runtimeOutputs";
    public static final String TAG_TASK_IMPL_CLASS = "implClass";
    public static final String TAG_TASK_IMPL_CLASS_FQ_NAME = "class";
    public static final String TAG_TASK_IMPL_CLASS_NAME = "name";
    public static final String TAG_TASK_IMPL_CLASSNAME_MAP = "TaskImplClassNameMap";
    private static final String LOG_CATEGORY = ETLEngineImpl.class.getName();
    private static volatile MessageManager messageManager = MessageManager.getManager("com.sun.etl.engine");
    private static final String TASK_DEF_FILE = "com/sun/etl/engine/impl/enginetaskdef.xml";
    private List conDefList = new ArrayList();
    private ETLEngineContext context;
    private String displayName = "";
    private ETLTaskNode endETLTaskNode;
    private Map inputAttrMap = new HashMap();
    private boolean onAppServer = false;
    private Map outputAttrMap = new HashMap();
    private ETLTaskNode startETLTaskNode;
    private String taskDefFile;
    private HashMap taskImplClassNameMap = new HashMap();
    private ETLTaskThreadManager taskManager;
    private HashMap taskNodeMap = new HashMap();

    public static MessageManager getPackageMessageManager() {
        return MessageManager.getManager(ETLEngine.class);
    }

    public ETLEngineImpl() {
        this.start();
    }

    public void addInputAttribute(RuntimeAttribute runtimeAttribute) {
        this.inputAttrMap.put(runtimeAttribute.getAttributeName(), runtimeAttribute);
    }

    public void addOutputAttribute(RuntimeAttribute runtimeAttribute) {
        this.outputAttrMap.put(runtimeAttribute.getAttributeName(), runtimeAttribute);
    }

    public boolean createEndETLTaskNode() {
        if (this.endETLTaskNode == null) {
            this.endETLTaskNode = new ETLTaskNodeImpl();
            this.endETLTaskNode.setId("STOP");
            this.endETLTaskNode.setTaskType("STOP");
            this.endETLTaskNode.setParent(this);
            this.taskNodeMap.put("STOP", this.endETLTaskNode);
            return true;
        }
        return false;
    }

    public ETLTaskNode createETLTaskNode(String taskType) {
        if ("START".equals(taskType) || "STOP".equals(taskType)) {
            throw new IllegalArgumentException("Cannot create a START or END task using this method!");
        }
        ETLTaskNodeImpl taskNode = new ETLTaskNodeImpl();
        taskNode.setTaskType(taskType);
        taskNode.setParent(this);
        String nodeId = this.generateId(taskType);
        taskNode.setId(nodeId);
        this.taskNodeMap.put(nodeId, taskNode);
        return taskNode;
    }

    public boolean createStartETLTaskNode() {
        if (this.startETLTaskNode == null) {
            this.startETLTaskNode = new ETLTaskNodeImpl();
            this.startETLTaskNode.setId("START");
            this.startETLTaskNode.setTaskType("START");
            this.startETLTaskNode.setParent(this);
            this.taskNodeMap.put("START", this.startETLTaskNode);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int exec(ETLEngineListener theExecListener) {
        String managerName = "ETLEngine";
        ETLTaskThread startThread = null;
        if (this.displayName != null) {
            managerName = managerName + this.displayName;
        }
        ETLEngineExecEvent anEvent = new ETLEngineExecEvent(managerName, 0, "Collab Started");
        theExecListener.executionPerformed(anEvent);
        try {
            if (this.getContext() == null) {
                String errContextMessage = messageManager.getString("ERR_NO_CONTEXT");
                throw new RuntimeException(errContextMessage);
            }
            this.taskManager = new ETLTaskThreadManager(managerName);
            ETLEngineImpl errContextMessage = this;
            synchronized (errContextMessage) {
                this.taskManager.addEngineListener(theExecListener);
            }
            if (this.startETLTaskNode == null) {
                String errMsg = messageManager.getString("ERR_ROOT_NODE");
                throw new ETLException(LOG_CATEGORY, errMsg);
            }
            Logger.print(Logger.infoLevel(), LOG_CATEGORY, "Starting ETLEngine Thread");
            startThread = new ETLTaskThread(this.taskManager, this.startETLTaskNode);
            if (startThread == null) {
                throw new RuntimeException("Can't instantiate eTL engine...");
            }
            return 0;
        }
        catch (Exception t) {
            Logger.printThrowable(Logger.errorLevel(), LOG_CATEGORY, "ETLEngine", t.getMessage(), t);
            ETLEngineExecEvent errEvent = new ETLEngineExecEvent(managerName, 2, t);
            theExecListener.executionPerformed(errEvent);
            this.taskManager.setEngineListener(null);
            return -1;
        }
    }

    public synchronized String generateId(String prefix) {
        int cnt = 0;
        String id = prefix + "_" + cnt;
        while (this.taskNodeMap.containsKey(id)) {
            id = prefix + "_" + ++cnt;
        }
        return id;
    }

    public List getConnectionDefList() {
        return this.conDefList;
    }

    public ETLEngineContext getContext() {
        return this.context;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final ETLTaskNode getEndETLTaskNode() {
        return this.endETLTaskNode;
    }

    public synchronized ETLEngineListener getETLEngineListener() {
        return this.taskManager.getEngineListener();
    }

    public final ETLTaskNode getETLTaskNode(String taskId) {
        return (ETLTaskNode)this.taskNodeMap.get(taskId);
    }

    public String getFullQualifiedImplClassName(String taskType) {
        String classRef = (String)this.taskImplClassNameMap.get(taskType);
        if (classRef != null && classRef.trim().length() != 0) {
            return classRef;
        }
        return null;
    }

    public Map getInputAttributes() {
        HashMap<String, String> runtimeAttributes = new HashMap<String, String>();
        for (RuntimeAttribute runAttr : this.inputAttrMap.values()) {
            runtimeAttributes.put(runAttr.getAttributeName(), runAttr.getAttributeValue());
        }
        return runtimeAttributes;
    }

    public Map getInputAttrMap() {
        return this.inputAttrMap;
    }

    public Map getRuntimeOutputArguments() {
        return this.outputAttrMap;
    }

    public final ETLTaskNode getStartETLTaskNode() {
        return this.startETLTaskNode;
    }

    public boolean isRunningOnAppServer() {
        return this.onAppServer;
    }

    public void parseXML(Element element) throws BaseException {
        Element attrElement;
        RuntimeAttribute attr;
        int j;
        NodeList attrList;
        Element runtimeElem;
        int i;
        if (element == null) {
            throw new BaseException("Must supply non-null Element ref for parameter 'element'.");
        }
        this.setDisplayName(element.getAttribute(TAG_TASK_IMPL_CLASS_NAME));
        NodeList list = element.getElementsByTagName("task");
        for (i = 0; i < list.getLength(); ++i) {
            Element taskElement = (Element)list.item(i);
            ETLTaskNodeImpl taskNode = new ETLTaskNodeImpl();
            taskNode.parseXML(taskElement);
            taskNode.setParent(this);
            if (taskNode.getId() != null) {
                if (taskNode.getId().equals("START")) {
                    this.startETLTaskNode = taskNode;
                    this.startETLTaskNode.setId("START");
                    this.startETLTaskNode.setTaskType("START");
                } else if (taskNode.getId().equals("STOP")) {
                    this.endETLTaskNode = taskNode;
                    this.endETLTaskNode.setId("STOP");
                    this.endETLTaskNode.setTaskType("STOP");
                }
            }
            this.taskNodeMap.put(taskNode.getId(), taskNode);
        }
        list = element.getElementsByTagName("connectiondef");
        this.conDefList.clear();
        try {
            for (i = 0; i < list.getLength(); ++i) {
                Element conDefElement = (Element)list.item(i);
                DBConnectionParameters conDef = new DBConnectionParameters();
                conDef.parseXML(conDefElement);
                this.conDefList.add(conDef);
            }
        }
        catch (BaseException e) {
            Logger.print(40000, LOG_CATEGORY, (Object)"Failed to parse ConnectionDefinition in Engine", e);
            throw new BaseException("Failed to parse ConnectionDefinition in Engine", e);
        }
        this.inputAttrMap.clear();
        list = element.getElementsByTagName(TAG_INPUTATTR);
        for (i = 0; i < list.getLength(); ++i) {
            runtimeElem = (Element)list.item(i);
            attrList = runtimeElem.getElementsByTagName("runtimeAttr");
            for (j = 0; j < attrList.getLength(); ++j) {
                attr = new RuntimeAttribute();
                attrElement = (Element)attrList.item(j);
                attr.parseXMLString(attrElement);
                this.inputAttrMap.put(attr.getAttributeName(), attr);
            }
        }
        this.outputAttrMap.clear();
        list = element.getElementsByTagName(TAG_OUTPUTATTR);
        for (i = 0; i < list.getLength(); ++i) {
            runtimeElem = (Element)list.item(i);
            attrList = runtimeElem.getElementsByTagName("runtimeAttr");
            for (j = 0; j < attrList.getLength(); ++j) {
                attr = new RuntimeAttribute();
                attrElement = (Element)attrList.item(j);
                attr.parseXMLString(attrElement);
                this.outputAttrMap.put(attr.getAttributeName(), attr);
            }
        }
    }

    public void setConnectionDefList(List conDefs) {
        this.conDefList = conDefs;
    }

    public synchronized void setContext(ETLEngineContext engineContext) {
        this.context = engineContext;
    }

    public void setDisplayName(String theDisplayName) {
        this.displayName = theDisplayName;
    }

    public void setInputAttrMap(Map newAttrs) {
        this.inputAttrMap.clear();
        if (newAttrs != null) {
            this.inputAttrMap.putAll(newAttrs);
        }
    }

    public void setOutputAttrMap(Map newAttrs) {
        this.outputAttrMap.clear();
        if (newAttrs != null) {
            this.outputAttrMap.putAll(newAttrs);
        }
    }

    public void setOverrideMap(ETLPersistableMessage persistMsg) {
        Iterator it = this.inputAttrMap.keySet().iterator();
        Logger.print(10000, LOG_CATEGORY, "InputAttrMap is " + this.inputAttrMap);
        try {
            Logger.print(10000, LOG_CATEGORY, "persistMsg: " + persistMsg);
            while (it.hasNext()) {
                String key = (String)it.next();
                if (persistMsg != null) {
                    Object objRef = persistMsg.getPart(key);
                    RuntimeAttribute attr = (RuntimeAttribute)this.inputAttrMap.get(key);
                    if (objRef == null) continue;
                    if (objRef instanceof String) {
                        objRef = StringUtil.removeIllegalRuntimeValueChars((String)objRef);
                    }
                    attr.setAttributeValue(objRef);
                    continue;
                }
                Logger.print(30000, LOG_CATEGORY, "Object is not of ETLPersistent Message; setting default value.");
            }
        }
        catch (Exception e) {
            Logger.print(40000, LOG_CATEGORY, (Object)"Error caught while getting the value from runtime inputs in ETLEngineImpl", e);
        }
    }

    public void setRunningOnAppServer(boolean runningOnAppServer) {
        this.onAppServer = runningOnAppServer;
    }

    public void start() {
        try {
            this.loadTaskRef();
        }
        catch (ETLException e) {
            String exMsg = messageManager.getString("EX_LOADING_TASK_REFS", TASK_DEF_FILE, e);
            Logger.printThrowable(40000, LOG_CATEGORY, this, exMsg, e);
        }
    }

    public void stopETLEngine() {
        if (this.taskManager != null) {
            this.taskManager.stopETLEngine();
        }
        String infoMsg = messageManager.getString("INFO_ETL_ENGINE_STOP");
        Logger.print(20000, LOG_CATEGORY, infoMsg);
    }

    public String toXMLString() {
        RuntimeAttribute attr;
        StringBuffer xml = new StringBuffer(500);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<etlengine name=\"" + this.getDisplayName() + "\">\n");
        for (String key : this.taskNodeMap.keySet()) {
            ETLTaskNode taskNode = (ETLTaskNode)this.taskNodeMap.get(key);
            xml.append(taskNode.toXMLString("\t"));
        }
        for (DBConnectionParameters conDef : this.conDefList) {
            xml.append(conDef.toXMLString("\t"));
        }
        Iterator<Object> it = this.inputAttrMap.values().iterator();
        if (it.hasNext()) {
            xml.append("\t").append("<").append(TAG_INPUTATTR).append(">\n");
            while (it.hasNext()) {
                attr = (RuntimeAttribute)it.next();
                xml.append(attr.toXMLString("\t\t"));
            }
            xml.append("\t").append("</").append(TAG_INPUTATTR).append(">\n");
        }
        if ((it = this.outputAttrMap.values().iterator()).hasNext()) {
            xml.append("\t").append("<").append(TAG_OUTPUTATTR).append(">\n");
            while (it.hasNext()) {
                attr = (RuntimeAttribute)it.next();
                xml.append(attr.toXMLString("\t\t"));
            }
            xml.append("\t").append("</").append(TAG_OUTPUTATTR).append(">\n");
        }
        xml.append("</etlengine>\n");
        XmlUtil.dumpXMLString("Engine_" + this.getDisplayName() + ".xml", xml.toString());
        return xml.toString();
    }

    private boolean loadTaskRef() throws ETLException {
        if (StringUtil.isNullString(this.taskDefFile)) {
            this.taskDefFile = TASK_DEF_FILE;
        }
        Element etlEngineTaskRootElement = XmlUtil.loadXMLFile(this.taskDefFile, this.getClass().getClassLoader());
        String errMsg = messageManager.getString("ERR_ROOT_NODE");
        if (etlEngineTaskRootElement == null) {
            throw new ETLException(errMsg);
        }
        if (!etlEngineTaskRootElement.getTagName().equals(TAG_TASK_IMPL_CLASSNAME_MAP)) {
            String err = messageManager.getString("ERR_UNKNOWN_TASK", TASK_DEF_FILE, etlEngineTaskRootElement.getTagName());
            throw new ETLException(LOG_CATEGORY, err);
        }
        NodeList taskDefList = etlEngineTaskRootElement.getElementsByTagName(TAG_TASK_IMPL_CLASS);
        if (this.taskImplClassNameMap != null) {
            this.taskImplClassNameMap = this.parseTaskDefList(taskDefList);
        }
        return true;
    }

    private HashMap parseTaskDefList(NodeList taskNodeList) {
        HashMap<String, String> tasks = new HashMap<String, String>(100);
        for (int i = 0; i < taskNodeList.getLength(); ++i) {
            Element taskElement = (Element)taskNodeList.item(i);
            String taskId = taskElement.getAttribute(TAG_TASK_IMPL_CLASS_NAME);
            String taskClass = taskElement.getAttribute(TAG_TASK_IMPL_CLASS_FQ_NAME);
            if (taskId == null || taskClass == null) continue;
            tasks.put(taskId, taskClass);
        }
        return tasks;
    }
}

