/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;

public class CustomTypeMapping
implements TypeMapping {
    private Map class2Type = new HashMap();
    private Map xml2Type;
    private Map class2xml = new HashMap();
    private TypeMapping defaultTM;
    private String encodingStyleURI;
    private TypeCreator typeCreator;

    public CustomTypeMapping(TypeMapping defaultTM) {
        this();
        this.defaultTM = defaultTM;
    }

    public CustomTypeMapping() {
        this.xml2Type = new HashMap();
    }

    public boolean isRegistered(Class javaType) {
        boolean registered = this.class2Type.containsKey(javaType);
        if (!registered && this.defaultTM != null) {
            registered = this.defaultTM.isRegistered(javaType);
        }
        return registered;
    }

    public boolean isRegistered(QName xmlType) {
        boolean registered = this.xml2Type.containsKey(xmlType);
        if (!registered && this.defaultTM != null) {
            registered = this.defaultTM.isRegistered(xmlType);
        }
        return registered;
    }

    public void register(Class javaType, QName xmlType, Type type) {
        type.setSchemaType(xmlType);
        type.setTypeClass(javaType);
        this.register(type);
    }

    public void register(Type type) {
        if (type.getTypeClass() == null) {
            throw new NullPointerException("Type class cannot be null.");
        }
        if (type.getSchemaType() == null) {
            throw new NullPointerException("Schema type cannot be null.");
        }
        type.setTypeMapping(this);
        this.class2Type.put(type.getTypeClass(), type);
        this.xml2Type.put(type.getSchemaType(), type);
        this.class2xml.put(type.getTypeClass(), type.getSchemaType());
    }

    public void removeType(Type type) {
        if (!this.xml2Type.containsKey(type.getSchemaType())) {
            this.defaultTM.removeType(type);
        } else {
            this.xml2Type.remove(type.getSchemaType());
            this.class2Type.remove(type.getTypeClass());
            this.class2xml.remove(type.getTypeClass());
        }
    }

    public Type getType(Class javaType) {
        Type type = (Type)this.class2Type.get(javaType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(javaType);
        }
        return type;
    }

    public Type getType(QName xmlType) {
        Type type = (Type)this.xml2Type.get(xmlType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(xmlType);
        }
        return type;
    }

    public QName getTypeQName(Class clazz) {
        QName qname = (QName)this.class2xml.get(clazz);
        if (qname == null && this.defaultTM != null) {
            qname = this.defaultTM.getTypeQName(clazz);
        }
        return qname;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public void setEncodingStyleURI(String encodingStyleURI) {
        this.encodingStyleURI = encodingStyleURI;
    }

    public TypeCreator getTypeCreator() {
        return this.typeCreator;
    }

    public void setTypeCreator(TypeCreator typeCreator) {
        this.typeCreator = typeCreator;
        typeCreator.setTypeMapping(this);
    }

    public TypeMapping getParent() {
        return this.defaultTM;
    }
}

