/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "notes.pas" */


#include "cfuncs.h"


#define NOTES_G
#include "notes.h"


short count64['9' + 1 - '0'] = {
  64, 4, 32, 2, 16, 0, 1, 0, 8, 128
};

#ifndef STRINGS_H

#endif

#ifndef GLOBALS_H
#include "globals.h"
#endif


void translateSolfa(char *nt)
{
  short k;

  if (!tonic_solfa)
    return;
  k = pos1(*nt, solfa_names);
  if (k > 0)
    *nt = has_duration[k-1];
}


char durationCode(char *note)
{
  char Result = unspecified;
  char code;

  if (strlen(note) <= 1)
    return Result;
  code = note[1];
  if (pos1(code, durations) > 0)
    return code;
  return Result;
}


static char half(char dur)
{
  char Result;
  short k;
  char STR1[20];
  char STR2[24];

  k = pos1(dur, durations);
  Result = dur;
  if (k == 0) {
    sprintf(STR1, "Invalid duration %c", dur);
    error(STR1, print);
    return Result;
  }
  if (k <= ndurs)
    return (durations[k]);
  sprintf(STR2, "%c is too short to halve", dur);
  error(STR2, print);
  return Result;
}


static void addDuration(char *note, char dur)
{
  insertchar(dur, note, 2);
}


static void extractFirst(char *note, char *first)
{
  *first = note[0];
  predelete(note, 1);
}


static void extractOneOf(char *note, char *hits, char *hit)
{
  short i, l;

  l = strlen(note);
  *hit = '\0';
  for (i = 1; i <= l; i++) {
    if (pos1(note[i-1], hits) > 0) {
      sprintf(hit, "%c", note[i-1]);
      delete1(note, i);
      return;
    }
  }
}


static void extractContiguous(char *note, char *hits, char *hit)
{
  short i, l, len;

  l = strlen(note);
  len = l;
  *hit = '\0';
  for (i = 1; i <= l; i++) {
    if (pos1(note[i-1], hits) > 0) {
      do {
	if (pos1(note[i-1], hits) == 0)
	  return;
	sprintf(hit + strlen(hit), "%c", note[i-1]);
	delete1(note, i);
	len--;
      } while (len >= i);
      return;
    }
  }
}


static void extractAfter(char *note, char delim, char *tail)
{
  short newlen;

  newlen = pos1(delim, note);
  *tail = '\0';
  if (newlen == 0)
    return;
  newlen--;
  strcpy(tail, note);
  predelete(tail, newlen);
  note[(long)((int)newlen)] = '\0';
/* p2c: notes.pas, line 76:
 * Note: Modification of string length may translate incorrectly [146] */
}


static void extractDotShortcut(char *note, char *tail, short *l)
{
  char names[256], tail2[256];
  short lt;
  char ch;

  extractAfter(note, '.', tail);
  *l = 1;
  lt = strlen(tail);
  if (*l < lt && tail[1] == '.')
    *l = 2;
  if (tonic_solfa)
    strcpy(names, solfa_names);
  else
    strcpy(names, has_duration);
  if (*l < lt && pos1(tail[*l], names) > 0) {
    translateSolfa(&tail[*l]);
    return;
  }
  if (*l == 2)
    error("\"..\" followed by non-note", print);
  if (*l >= lt) {
    strcat(note, tail);
    *tail = '\0';
    return;
  }
  ch = tail[0];
  predelete(tail, 1);
  extractDotShortcut(tail, tail2, l);
  sprintf(note + strlen(note), "%c%s", ch, tail);
  strcpy(tail, tail2);
}


static void extractSignedNumber(char *note, char *number)
{
  short k;
  char note0[256];

  k = pos1('+', note);
  if (k == 0)
    k = pos1('-', note);
  *number = '\0';
  if (k == 0)
    return;
  strcpy(note0, note);
  do {
    sprintf(number + strlen(number), "%c", note[k-1]);
    delete1(note, k);
  } while (k <= strlen(note) && pos1(note[k-1], digits) != 0);
  if (strlen(number) == 1) {
    strcpy(note, note0);
    *number = '\0';
  }
}


/* static variables for extractGroup: */
struct LOC_extractGroup {
  char *group;
  short gl, k;
  boolean probe, nonumber;
} ;

static void tryMore(struct LOC_extractGroup *LINK)
{
  while (LINK->k <= LINK->gl && LINK->group[LINK->k-1] == LINK->group[0])
    LINK->k++;
}

static void try_(char *s, struct LOC_extractGroup *LINK)
{
  LINK->probe = (LINK->k < LINK->gl && pos1(LINK->group[LINK->k-1], s) > 0);
  if (LINK->probe)
    LINK->k++;
}

static void tryNumber(struct LOC_extractGroup *LINK)
{
  boolean dot_ = false;

  LINK->nonumber = true;
  while (LINK->k <= LINK->gl && pos1(LINK->group[LINK->k-1], digitsdot) > 0) {
    LINK->k++;
    if (LINK->group[LINK->k-1] == '.') {
      if (dot_)
	error("Extra dot in number", print);
      else
	dot_ = true;
    } else
      LINK->nonumber = false;
  }
}


static void extractGroup(char *note, char delim, char *group_)
{
  struct LOC_extractGroup V;
  short k0;
  char tail[256];

  V.group = group_;
  extractAfter(note, delim, V.group);
  if (*V.group == '\0')
    return;
  V.gl = strlen(V.group);
  V.k = 2;
  if (V.gl > 1 && V.group[1] == ':')
    V.k = 3;
  else {
    tryMore(&V);
    k0 = V.k;
    try_("+-<>", &V);
    if (V.probe)
      tryNumber(&V);
    if (V.nonumber)
      V.k = k0;
    k0 = V.k;
    try_("+-<>", &V);
    if (V.probe)
      tryNumber(&V);
    if (V.nonumber)
      V.k = k0;
  }
  strcpy(tail, V.group);
  V.k--;
  V.group[(long)((int)V.k)] = '\0';
/* p2c: notes.pas, line 131:
 * Note: Modification of string length may translate incorrectly [146] */
  predelete(tail, V.k);
  strcat(note, tail);
}


/* Not perfect for rests, e.g. wrongly r+6 -> r6+ */
void parseNote(char *note, char *xnote, char dur1, char *dur, short *count)
{
  char shortcut[256], xtuplet[256], accidental[256], dotgroup[256],
       adjustment[256], duration[256], octave[256];
  char name, sc;
  short l, multiplicity;
  char STR1[256], STR2[256];

  *xnote = '\0';
  *shortcut = '\0';
  *xtuplet = '\0';
  *accidental = '\0';
  *dotgroup = '\0';
  *adjustment = '\0';
  *duration = '\0';
  *octave = '\0';
  if (*note == '\0' || !isNoteOrRest(note) || isPause(note))
    return;
  extractFirst(note, &name);
  extractAfter(note, 'x', xtuplet);
  extractAfter(note, ',', shortcut);
  if (*shortcut == '\0')
    extractDotShortcut(note, shortcut, &multiplicity);
  if (name != rest) {
    extractGroup(note, 's', accidental);
    if (*accidental == '\0')
      extractGroup(note, 'f', accidental);
    if (*accidental == '\0')
      extractGroup(note, 'n', accidental);
  }
  extractGroup(note, 'd', dotgroup);
  if (name == rest)
    extractSignedNumber(note, accidental);
  extractOneOf(note, durations, duration);
  if (*duration == '\0')
    *dur = dur1;
  else
    *dur = duration[0];
  *count = count64[*dur - '0'];
  if (*dotgroup != '\0') {
    *count += *count / 2;
    if (startsWith(dotgroup, "dd"))
      *count += *count / 6;
  }
  sprintf(STR1, "%c", rest);
  if (strcmp(note, STR1))
    extractContiguous(note, "=+-", octave);
  sprintf(duration, "%c", *dur);
  if (*shortcut != '\0') {
    if (*dotgroup != '\0')
      error("You may not explicitly dot a note with a shortcut", print);
    sc = shortcut[0];
    predelete(shortcut, 1);
    if (sc == '.') {
      if (multiplicity == 2)
	predelete(shortcut, 1);
      if (split_dots)
	duration[0] = half(duration[0]);
      else
	*count += *count;
      dur1 = duration[0];
      for (l = 1; l <= multiplicity; l++) {
	sprintf(duration + strlen(duration), "%c", dotcode);
	dur1 = half(dur1);
      }
      addDuration(shortcut, dur1);
    } else {
      addDuration(shortcut, half(duration[0]));
      *count += *count / 2;
    }
  }
  sprintf(note, "%c%s%s%s%s%s%s",
	  name, duration, octave, strcpy(STR2, note), accidental, dotgroup,
	  xtuplet);
  strcpy(xnote, shortcut);
}




/* End. */
