/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.processors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Processor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class Xalan2Processor
extends AbstractComponent
implements Processor {
    private String getStyleSheet(Document document) {
        String string = null;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            ProcessingInstruction processingInstruction;
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 7 && (processingInstruction = (ProcessingInstruction)node).getNodeName().equals("xml-stylesheet")) {
                boolean bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(processingInstruction.getNodeValue(), " \t=");
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().equals("type")) continue;
                    String string2 = stringTokenizer.nextToken();
                    if ((string2 = string2.substring(1, string2.length() - 1)).equals("text/xsl")) continue;
                    bl = false;
                }
                if (bl) {
                    stringTokenizer = new StringTokenizer(processingInstruction.getNodeValue(), " \t=");
                    while (stringTokenizer.hasMoreTokens()) {
                        if (!stringTokenizer.nextToken().equals("href")) continue;
                        string = stringTokenizer.nextToken();
                        string = string.substring(1, string.length() - 1);
                    }
                    break;
                }
            }
            ++n2;
        }
        return string;
    }

    public Document process(Document document, CreationContext creationContext, Parameters parameters) throws CreationException, IOException {
        try {
            Object object;
            String string = parameters.getParameter("stylesheet");
            if (string == null) {
                string = this.getStyleSheet(document);
            }
            if (string == null) {
                return document;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(string));
            Enumeration enumeration = parameters.getParameterNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                transformer.setParameter((String)object, parameters.getParameter((String)object));
            }
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            Document document2 = documentBuilder.newDocument();
            this.log("Applying XSL sheet \"" + string + "\"");
            transformer.transform(new DOMSource(document), new DOMResult(document2));
            return document2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new CreationException(exception.getMessage(), exception, document);
        }
    }
}

