/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.*;

import com.sap.dbtech.util.*;
import com.sap.dbtech.vsp00.*;
import com.sap.dbtech.vsp001.*;

import com.sap.dbtech.jdbc.exceptions.*;

/**
 *
 */
public class DataPart
    extends com.sap.dbtech.util.MemIndirection
{
    final private static int maxArgCount = Short.MAX_VALUE;
    private int argCount = 0;
    private int extent = 0;
    private int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;
    /**
     * DataPart constructor comment.
     * @param rawMem com.sap.dbtech.util.StructuredMem
     */
    DataPart(
        StructuredMem rawMem,
        RequestPacket requestPacket)
    {
        super(rawMem);
        this.originalMem = rawMem.getPointer(0);
        this.requestPacket = requestPacket;
    }
    /**
     *
     * @param pos int
     * @param len int
     */
    public void addArg (
        int pos,
        int len)
    {
        ++this.argCount;
        this.extent = Math.max (this.extent, pos + len);
    }
    /**
     *
     */
    public void close ()
    {
        int argCountOffs = -Part.Data_O + Part.ArgCount_O;
        this.originalMem.putInt2 (this.argCount, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }
    /**
     *
     */
    public void closeArrayPart (
        int rows)
    {
        int argCountOffs = -Part.Data_O + Part.ArgCount_O;
        this.originalMem.putInt2 (rows, argCountOffs);
        this.requestPacket.closePart(this.massExtent + this.extent * rows, rows);
    }
    
    
    public void fillWithOMSReturnCode(int returncode) {
    	putInt4(returncode, this.extent);
    	this.extent += 4;
    	++this.argCount;	
    }
    

    public boolean fillWithOMSStream(InputStream stream, 
    								 boolean     asciiForUnicode)
    	throws SQLException {
		
		// We have to:
		// - read and write only multiples of 'rowSize'
		// - but up to maxReadLength

		boolean streamExhausted = false;
		int maxDataSize = getMaxDataSize();
		int readBufSize	= 4096;	
		byte[] readBuf = new byte[readBufSize];
		byte[] expandbuf =  null;
		if(asciiForUnicode) {
			expandbuf = new byte[readBufSize * 2];
		}
		int bytesRead    = 0;
		int bytesWritten = 0;
		while(!streamExhausted && maxDataSize> (asciiForUnicode?1:0) ) {
			bytesRead = 0;	
			int startPos=0;
			int bytesToRead=Math.min(maxDataSize / (asciiForUnicode?2:1), 
								     readBufSize);
			int currBytesRead=0;
			while(bytesToRead != 0) {
				try {
					currBytesRead = stream.read(readBuf, startPos, bytesToRead);
				} catch(IOException ioex) {
					throw new SQLExceptionSapDB
						(MessageTranslator.translate
							(MessageKey.ERROR_STREAM_IOEXCEPTION,
							 ioex.getMessage()));				
				}
				// if the stream is exhausted, we have to look 
				// whether it is wholly written.
				if(currBytesRead == -1) {
					bytesToRead = 0;
					streamExhausted = true;
				} else {
					bytesRead += currBytesRead;
					bytesToRead = 0;
				}
			}
			if(asciiForUnicode) {
				for(int i=0; i<bytesRead; ++i) {
					expandbuf[i*2] = 0;
					expandbuf[i*2+1] = readBuf[i];				
				}
				putBytes(expandbuf, this.extent, bytesRead * 2);
				this.extent += bytesRead * 2;
				maxDataSize -= bytesRead * 2;
				bytesWritten += bytesRead * 2;
			} else {
				putBytes(readBuf, this.extent, bytesRead);
				this.extent +=  bytesRead;
				maxDataSize -=  bytesRead;
				bytesWritten += bytesRead;
			}
		}
		// The number of arguments is the number of rows
		this.argCount = bytesWritten / (asciiForUnicode?2:1);
		// the data must be marked as 'last part' in case it is a last
		// part.
		if(streamExhausted) {
			setLastPart();
		}
		return streamExhausted;
    }
    
    /**
     *
     * @param stream java.io.InputStream
     * @param descriptor byte[]
     * @param descriptorMark StructuredMem
     */
    public boolean fillWithStream(
        java.io.InputStream stream,
        StructuredMem descriptorMark,
        com.sap.dbtech.jdbc.translators.Putval putval)
        throws SQLException
    {

        // not exact, but enough to prevent an overflow - adding this
        // part to the packet may at most eat up 8 bytes more, if
        // the size is weird.
        int maxDataSize = getMaxDataSize();

        if (maxDataSize <= 1) {
            descriptorMark.putInt1 (LongDesc.NoData_C, LongDesc.Valmode_O);
            return false;
        }
        int dataStart = this.extent;
        int bytesRead;
        byte[] readBuf = new byte[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && (maxDataSize > 0)) {
                bytesRead = stream.read(readBuf, 0, java.lang.Math.min (maxDataSize, 4096));
                if (bytesRead == -1) {
                    streamExhausted = true;
                }
                else {
                    this.putBytes(readBuf, this.extent, bytesRead);
                    this.extent += bytesRead;
                    maxDataSize -= bytesRead;
                }
            }
        }
        catch (java.io.IOException exc) {
            throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
                                                                    exc.getMessage()));
            // streamExhausted = true;
        }
        /*
         * patch pos, length and kind
         */
        if (streamExhausted) {
            descriptorMark.putInt1 (LongDesc.LastData_C, LongDesc.Valmode_O);
        }
        else {
            descriptorMark.putInt1 (LongDesc.DataPart_C, LongDesc.Valmode_O);
        }
        descriptorMark.putInt4 (this.massExtent + dataStart + 1, LongDesc.Valpos_O);
        descriptorMark.putInt4 (this.extent - dataStart, LongDesc.Vallen_O);
        putval.markRequestedChunk(this.getPointer (dataStart),
            this.extent - dataStart);
        return streamExhausted;
    }
	private int getMaxDataSize() {
		return this.size() - this.extent  -8;
	}
    /**
     *
     */
    public void
    markEmptyStream (
        StructuredMem descriptorMark)
    {
        descriptorMark.putInt1 (LongDesc.LastData_C, LongDesc.Valmode_O);
        descriptorMark.putInt4 (this.massExtent + this.extent + 1, LongDesc.Valpos_O);
        descriptorMark.putInt4 (0, LongDesc.Vallen_O);

    }

	/**
	 * Fills a data part with <code>java.io.Reader</code> content.
	 * @param stream The java.io.Reader instance.
	 * @param rowSize The size of a single row. 
	 * @return <code>true</code> on EOF condition.
	 * @throws SQLException when an <code>java.io.IOException</code>
	 *   happens while reading from the reader.
	 */
	public boolean fillWithOMSReader(Reader stream, int rowSize) 
		throws SQLException {
		// We have to:
		// - read and write only multiples of 'rowSize' (which should be 2)
		// - but up to maxReadLength
        
		boolean streamExhausted = false;
		int maxDataSize = (getMaxDataSize() / rowSize) * rowSize;
		
		int readBufSize = (4096 / rowSize) * rowSize;
		if(readBufSize == 0) {
			readBufSize = rowSize;
		}
		char[] readBuf = new char[readBufSize];
		int charsRead    = 0;
		int bytesWritten = 0;
		while(!streamExhausted && maxDataSize>0) {
			charsRead = 0;	
			int startPos=0;
			int charsToRead=Math.min(maxDataSize/2, readBufSize);
			int currCharsRead=0;
			while(charsToRead != 0) {
				try {
					currCharsRead = stream.read(readBuf, startPos, charsToRead);
				} catch(IOException ioex) {
					throw new SQLExceptionSapDB
						(MessageTranslator.translate
							(MessageKey.ERROR_STREAM_IOEXCEPTION,
							 ioex.getMessage()));				
				}
				// if the stream is exhausted, we have to look 
				// whether it is wholly written.
				if(currCharsRead == -1) {
					if((charsRead * 2) % rowSize != 0) {
						throw new SQLExceptionSapDB
							(MessageTranslator.translate
								(MessageKey.ERROR_STREAM_ODDSIZE));
					} else {
						charsToRead = 0;
						streamExhausted = true;
					}
				} else {
					charsRead += currCharsRead;
					// does it fit, then it is ok.
					if(charsRead>0 && (charsRead * 2) % rowSize == 0) {
						charsToRead = 0;
					} else {
						// else advance in the buffer
						charsToRead -= currCharsRead;
						startPos += currCharsRead;
					}
				}
			}

            putBigUnicode(readBuf, this.extent, charsRead * 2);
            this.extent +=  charsRead * 2;
            maxDataSize -=  charsRead * 2;
            bytesWritten += charsRead * 2;
		}
		// The number of arguments is the number of rows
		this.argCount = bytesWritten / rowSize;
		// the data must be marked as 'last part' in case it is a last
		// part.
		if(streamExhausted) {
			setLastPart();
		}
		return streamExhausted;
	}

    /**
     *
     * @param stream java.io.Reader
     * @param descriptor byte[]
     * @param descriptorMark StructuredMem
     */
    public boolean fillWithReader(
        java.io.Reader reader,
        StructuredMem descriptorMark,
        com.sap.dbtech.jdbc.translators.Putval putval)
        throws SQLException
    {
        final int unicodeWidthC = 2;
        // not exact, but enough to prevent an overflow - adding this
        // part to the packet may at most eat up 8 bytes more, if
        // the size is weird.
        int maxDataSize = ((this.size() - this.extent -8) / unicodeWidthC);
        if (maxDataSize <= 1) {
            descriptorMark.putInt1 (LongDesc.NoData_C, LongDesc.Valmode_O);
            return false;
        }
        int dataStart = this.extent;
        int charsRead;
        char[] readBuf = new char[4096];
        boolean streamExhausted = false;
        try {
            while (!streamExhausted && (maxDataSize > 0)) {
                charsRead = reader.read(readBuf, 0, java.lang.Math.min (maxDataSize, 4096));
                if (charsRead == -1) {
                    streamExhausted = true;
                }
                else {
                    this.putBigUnicode(readBuf, this.extent,
                        charsRead * unicodeWidthC);
                    this.extent += charsRead * unicodeWidthC;
                    maxDataSize -= charsRead;
                }
            }
        }
        catch (java.io.IOException exc) {
            throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
                                                                    exc.getMessage()));

                                        }
        /*
         * patch pos, length and kind
         */
        if (streamExhausted) {
            descriptorMark.putInt1 (LongDesc.LastData_C, LongDesc.Valmode_O);
        }
        else {
            descriptorMark.putInt1 (LongDesc.DataPart_C, LongDesc.Valmode_O);
        }
        descriptorMark.putInt4 (this.massExtent + dataStart + 1, LongDesc.Valpos_O);
        descriptorMark.putInt4 (this.extent - dataStart, LongDesc.Vallen_O);
        putval.markRequestedChunk(this.getPointer (dataStart),
            this.extent - dataStart);
        return streamExhausted;
    }
    /**
     *
     * @return boolean
     * @param recordSize int
     */
    public boolean hasRoomFor (
        int recordSize,
        int reserve)
    {
        return ( this.argCount < maxArgCount
                 && (this.size () - this.extent) > (recordSize + reserve)
                );
    }
    /**
     *
     * @return boolean
     * @param recordSize int
     */
    public boolean hasRoomFor (
        int recordSize)
    {
        return ( this.argCount < maxArgCount
                 && (this.size () - this.extent) > recordSize
                );
    }
    /**
     *
     * @param pos int
     * @param len int
     */
    public void putNull (
        int pos,
        int len)
    {
        this.putInt1 (-1, pos -1);
        this.putBytes (new byte [len], pos);
        this.addArg (pos, len);
    }
    /**
     *
     */
    public int getExtent ()
    {
        return this.extent;
    }
    /**
     *
     *
     */
    public void setFirstPart () {
        this.requestPacket.addPartAttribute (PartAttributes.FirstPacket_E);
        if (false) {
            int attrOffs = -Part.Data_O + Part.Attributes_O;
            int partAttributes;

            partAttributes = this.originalMem.getInt1 (attrOffs);
            partAttributes |= PartAttributes.FirstPacket_E;
            this.originalMem.putInt1 (attrOffs, partAttributes);
        }
    }
    /**
     *
     *
     */
    public void setLastPart () {
        this.requestPacket.addPartAttribute (PartAttributes.LastPacket_E);
        if (false) {
            int attrOffs = -Part.Data_O + Part.Attributes_O;
            int partAttributes;

            partAttributes = this.originalMem.getInt1 (attrOffs);
            partAttributes |= PartAttributes.LastPacket_E;
            this.originalMem.putInt1 (attrOffs, partAttributes);
        }
    }
    /**
     *
     */
    public void
    moveRecordBase ()
    {
        this.moveBase (this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }
}
