/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPart
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    private int argCount = 0;
    private int extent = 0;
    private int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPart(StructuredMem structuredMem, RequestPacket requestPacket) {
        super(structuredMem);
        this.originalMem = structuredMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public void addArg(int n, int n2) {
        ++this.argCount;
        this.extent = Math.max(this.extent, n + n2);
    }

    public void close() {
        int n = -14;
        this.originalMem.putInt2(this.argCount, n);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int n) {
        int n2 = -14;
        this.originalMem.putInt2(n, n2);
        this.requestPacket.closePart(this.massExtent + this.extent * n, n);
    }

    public void fillWithOMSReturnCode(int n) {
        this.putInt4(n, this.extent);
        this.extent += 4;
        ++this.argCount;
    }

    public boolean fillWithOMSStream(InputStream inputStream, boolean bl) throws SQLException {
        boolean bl2 = false;
        int n = this.getMaxDataSize();
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        if (bl) {
            byArray2 = new byte[n2 * 2];
        }
        int n3 = 0;
        int n4 = 0;
        while (!bl2 && n > (bl ? 1 : 0)) {
            n3 = 0;
            int n5 = 0;
            int n6 = Math.min(n / (bl ? 2 : 1), n2);
            int n7 = 0;
            while (n6 != 0) {
                try {
                    n7 = inputStream.read(byArray, n5, n6);
                }
                catch (IOException iOException) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
                }
                if (n7 == -1) {
                    n6 = 0;
                    bl2 = true;
                    continue;
                }
                n3 += n7;
                n6 = 0;
            }
            if (bl) {
                int n8 = 0;
                while (n8 < n3) {
                    byArray2[n8 * 2] = 0;
                    byArray2[n8 * 2 + 1] = byArray[n8];
                    ++n8;
                }
                this.putBytes(byArray2, this.extent, n3 * 2);
                this.extent += n3 * 2;
                n -= n3 * 2;
                n4 += n3 * 2;
                continue;
            }
            this.putBytes(byArray, this.extent, n3);
            this.extent += n3;
            n -= n3;
            n4 += n3;
        }
        this.argCount = n4 / (bl ? 2 : 1);
        if (bl2) {
            this.setLastPart();
        }
        return bl2;
    }

    public boolean fillWithStream(InputStream inputStream, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = this.getMaxDataSize();
        if (n <= 1) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        byte[] byArray = new byte[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = inputStream.read(byArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.putBytes(byArray, this.extent, n3);
                this.extent += n3;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }

    private int getMaxDataSize() {
        return this.size() - this.extent - 8;
    }

    public void markEmptyStream(StructuredMem structuredMem) {
        structuredMem.putInt1(2, 27);
        structuredMem.putInt4(this.massExtent + this.extent + 1, 32);
        structuredMem.putInt4(0, 36);
    }

    public boolean fillWithOMSReader(Reader reader, int n) throws SQLException {
        boolean bl = false;
        int n2 = this.getMaxDataSize() / n * n;
        int n3 = 4096 / n * n;
        if (n3 == 0) {
            n3 = n;
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (!bl && n2 > 0) {
            n4 = 0;
            int n6 = 0;
            int n7 = Math.min(n2 / 2, n3);
            int n8 = 0;
            while (n7 != 0) {
                try {
                    n8 = reader.read(cArray, n6, n7);
                }
                catch (IOException iOException) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
                }
                if (n8 == -1) {
                    if (n4 * 2 % n != 0) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.oddsize"));
                    }
                    n7 = 0;
                    bl = true;
                    continue;
                }
                if ((n4 += n8) > 0 && n4 * 2 % n == 0) {
                    n7 = 0;
                    continue;
                }
                n7 -= n8;
                n6 += n8;
            }
            this.putBigUnicode(cArray, this.extent, n4 * 2);
            this.extent += n4 * 2;
            n2 -= n4 * 2;
            n5 += n4 * 2;
        }
        this.argCount = n5 / n;
        if (bl) {
            this.setLastPart();
        }
        return bl;
    }

    public boolean fillWithReader(Reader reader, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = (this.size() - this.extent - 8) / 2;
        if (n <= 1) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        char[] cArray = new char[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = reader.read(cArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.putBigUnicode(cArray, this.extent, n3 * 2);
                this.extent += n3 * 2;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }

    public boolean hasRoomFor(int n, int n2) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n + n2;
    }

    public boolean hasRoomFor(int n) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n;
    }

    public void putNull(int n, int n2) {
        this.putInt1(-1, n - 1);
        this.putBytes(new byte[n2], n);
        this.addArg(n, n2);
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }
}

