/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Dec 17, 2005
 */

package org.jboss.test.remoting.transport.multiplex.utility;

import java.lang.reflect.Method;

import org.jboss.logging.Logger;

import junit.framework.TestCase;


/**
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 668 $
 *          <p/>
 *          Copyright (c) 2005
 *          </p>
 */

public class SuccessCountingTestCase extends TestCase
{
   protected static final Logger log = Logger.getLogger(SuccessCountingTestCase.class);
   protected static int OKCounter;
   private static int testCounter;
   private static int numberOfTests;
   
   public SuccessCountingTestCase()
   {
   }
   
   
   public SuccessCountingTestCase(String name)
   {
      super(name);
   }
   
   
   public void setUp() throws Exception
   {
      if (numberOfTests == 0)
      {
         Method[] methods = this.getClass().getMethods();
         
         for (int i = 0; i < methods.length; i++)
            if (methods[i].getName().startsWith("test"))
               numberOfTests++;
      }
      
      testCounter++;
   }
 
   public void tearDown() throws Exception
   {  
      if (testCounter == numberOfTests)
      {
         if (OKCounter == numberOfTests)
         {
            log.info("OK: " + OKCounter + " tests passed");
            System.out.println("OK: " + OKCounter + " tests passed");
         }
         else
         {
            log.info("FAILURE: " + OKCounter + " tests passed");
            System.out.println("FAILURE: " + OKCounter + " tests passed");
         }
      }
   }
   
   public void testDummy()
   {
      OKCounter++;
   }
}

