/* LoggingWindowWrapper_1_0.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.workspace.compat;

import java.io.IOException;

import org.grinvin.io.SectionLoader;
import org.grinvin.io.SectionSaver;
import org.grinvin.logging.LoggingWindow;
import org.grinvin.workspace.DefaultWindowWrapper;
import org.grinvin.workspace.LoggingWindowWrapper;

import org.jdom.Element;

/**
 *
 */
public class LoggingWindowWrapper_1_0 extends DefaultWindowWrapper<LoggingWindow> {

    @Override
    public LoggingWindow create() {
        throw new UnsupportedOperationException("This wrapper cannot be used to create new logging windows");
    }

    public String getElementName() {
        return "loggingWindow";
    }
    
    @Override
    public LoggingWindow load(Element element, SectionLoader sloader) throws IOException {
        LoggingWindow window = new LoggingWindowWrapper().create();
        loadWindowProperties(element, window);
        return window;
    }

    @Override
    public void save(LoggingWindow window, Element parent, SectionSaver ssaver) throws IOException {
        throw new UnsupportedOperationException("This wrapper cannot be used to save logging windows");
    }
    
}
