/* DirectorySectionLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

/**
 * Loads sections as files from a directory.
 */
public class DirectorySectionLoader implements SectionLoader {
    
    //
    private File directory;
    
    /**
     * Default constructor.
     */
    public DirectorySectionLoader(File directory) {
        if (! directory.isDirectory())
            throw new IllegalArgumentException ("Argument must be a directory");
        this.directory = directory;
    }
    
    public InputStream openSection(String name) throws IOException {
        
        //check for a zipped graph bundle from a 1.0 workspace
        int index = name.indexOf('/', 0);
        if (index != -1) {
            String path = name.substring(0, index);
            File pathFile = new File(directory, path);
            if (pathFile.isFile()) {
                return new ZipFileSectionLoader(new ZipFile(pathFile)).openSection(name.substring(index+1));
            }
        }
        
        File file = new File (directory, name);
        if (! file.exists())
            return null;
        else
            return new FileInputStream (file);
    }
    
}
