/* ExportGraphList.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import be.ugent.caagt.swirl.actions.FileSaveAction;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

import org.grinvin.gui.FileFilters;
import org.grinvin.io.list.GraphListSaver;
import org.grinvin.list.graphs.GraphList;

/**
 * Action to export a list of graphs.
 */
public class ExportGraphList extends FileSaveAction {

    //
    private final GraphList graphList;

    //
    public ExportGraphList(Window parent, GraphList graphList) {
        super(parent, FileFilters.GRAPHLIST_FILTER);
        this.graphList = graphList;
    }

    /**
     * Alert the user that a file with the chosen name already exists.
     * @return true if the user allows the file to be overwritten.
     */
    protected boolean showFileExistsDialog(File file) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.grinvin.list.actions.resources");

        return JOptionPane.showConfirmDialog(
                parent,
                MessageFormat.format(bundle.getString("File.overwrite.message"), file.getName()),
                bundle.getString("File.overwrite.title"),
                JOptionPane.YES_NO_CANCEL_OPTION) == JOptionPane.YES_OPTION;
    }

    protected void saveFile(File file) {
        try {
            GraphListSaver.save(graphList, new FileOutputStream(file));
        } catch (IOException e) {
            throw new RuntimeException("Saving graph list failed", e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (graphList.containsSessionElements()) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.grinvin.list.actions.resources");
            JOptionPane.showMessageDialog(null, bundle.getString("GraphList.SessionElements"),
                    bundle.getString("GraphListSave.title"), JOptionPane.DEFAULT_OPTION);
        } else {
            super.actionPerformed(e);
        }
    }
}

