/* LaTeXViewer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import be.ugent.caagt.jmathtex.TeXConstants;
import be.ugent.caagt.jmathtex.TeXFormula;
import be.ugent.caagt.jmathtex.TeXIcon;

import com.sun.java.help.impl.ViewAwareComponent;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.text.ComponentView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

/**
 *
 */
public class LaTeXViewer extends JLabel implements ViewAwareComponent {
    
    private TeXFormula formula = new TeXFormula();
    private float fontSize;
    
    /** Creates a new instance of LaTeXViewer */
    public LaTeXViewer() {
    }
    
    /** Creates a new instance of LaTeXViewer */
    public LaTeXViewer(String text, View view) {
        formula = new TeXFormula(text);
        setViewData(view);
    }
    
    public void setLaTeX(String text) {
        formula = new TeXFormula(text);
        setIcon();
    }
    
    private void setIcon() {
        TeXIcon icon = formula.createTeXIcon(TeXConstants.STYLE_DISPLAY, fontSize);
        icon.setInsets(new Insets(1,1,1,1));
        setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        setAlignmentY(icon.getBaseLine());
        setIcon(icon);
    }

    public void setViewData(View view) {
        //ComponentView always returns the default font size 12
        //so we first escape the ComponentView
        while(view instanceof ComponentView)
            view = view.getParent();
        fontSize = StyleConstants.getFontSize(view.getAttributes()) + 2;
        //we take the font just a bit bigger for clearity.
        setIcon();
    }
}
