/***************************************************************************
 *   Copyright (C) 2003-2004 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kfoldingconfigdata.h"

#include <kconfig.h>
#include <kglobal.h>
#include <kstandarddirs.h>


kfoldingConfigData::kfoldingConfigData( KConfig* config ) : _cfg( config )
{
	return;
} // kfoldingConfigData ctor


kfoldingConfigData::kfoldingConfigData( const kfoldingConfigData& other )
{
	*this = other;
	return;
} // kfoldingConfigData copy ctor



kfoldingConfigData::~kfoldingConfigData()
{
	return;
} // kfoldingConfigData dtor


kfoldingConfigData const &kfoldingConfigData::operator=( kfoldingConfigData const &other )
{
	if ( this != &other ) {
		_executable 	= other._executable;
		_workingDir 	= other._workingDir;
		_appletImage	= other._appletImage;
		_state		= other._state;
		_lastPid	= other._lastPid;
		
		_userName 	= other._userName;
		_teamNumber	= other._teamNumber;
		_clientType	= other._clientType;
		_model		= other._model;
		_display	= other._display;
		_ballSize	= other._ballSize;
		_quality	= other._quality;
		_stereoDepth	= other._stereoDepth;
		_machineId	= other._machineId;
		
		_firstRun	= other._firstRun;
		_startOnLaunch	= other._startOnLaunch;
		_restoreState	= other._restoreState;
		_forceasm	= other._forceasm;
		_bigPackets	= other._bigPackets;
		_useadvmethods 	= other._useadvmethods;
		_showH2O	= other._showH2O;
		_showH2		= other._showH2;
		_nonBackbone	= other._nonBackbone;
	} // if
	return *this;
} // operator=


bool kfoldingConfigData::load()
{
	if ( !_cfg )
		return false;
		
	_cfg->setGroup( "General" );
	
	_executable	= _cfg->readEntry( "Executable", "" );
	_appletImage	= _cfg->readEntry( "Applet Image", locate( "data", "kfolding/pics/foldinglogo.png" ) );
	_state		= _cfg->readNumEntry( "Current State", 0 );
	_firstRun	= _cfg->readBoolEntry( "First Run", true );
	_startOnLaunch	= _cfg->readBoolEntry( "Start on Launch", false );
	_restoreState	= _cfg->readBoolEntry( "Restore State", true );

	_cfg->setGroup( "Folding Core" );

	_workingDir	= _cfg->readPathEntry( "Working Directory", KGlobal::dirs()->saveLocation( "data", "kfolding/", true ) );
	_userName	= _cfg->readEntry( "User Name", "Anonymous" );
	_teamNumber	= _cfg->readNumEntry( "Team Number", 0 );
	_clientType	= _cfg->readNumEntry( "Client Type", 0 );
	_forceasm 	= _cfg->readBoolEntry( "Force ASM", false );
	_bigPackets	= _cfg->readBoolEntry( "Big Packets", false );
	_useadvmethods	= _cfg->readBoolEntry( "Use Advanced Methods", false );
	_machineId	= _cfg->readNumEntry( "Machine Id", 1 );
	_lastPid	= _cfg->readNumEntry( "Last PID", 0 );

	_cfg->setGroup( "Model" );

	_model		= ( ModelType )_cfg->readNumEntry( "Model", SpaceFilling );
	_display	= ( DisplayType )_cfg->readNumEntry( "Display", Normal );
	_quality	= _cfg->readNumEntry( "Quality", 0 );
	_ballSize	= _cfg->readNumEntry( "Ball Size", 20 );
	_stereoDepth	= _cfg->readNumEntry( "Stereo Depth", 0 );
	_showH2O	= _cfg->readBoolEntry( "Show Water", true );
	_showH2		= _cfg->readBoolEntry( "Show Hydrogen", true );
	_nonBackbone	= _cfg->readBoolEntry( "Non Backbone", true );

	return true;
} // load


bool kfoldingConfigData::save()
{
	if ( !_cfg )
		return false;

	_cfg->setGroup( "General" );

	_cfg->writeEntry( "Executable", _executable );
	_cfg->writeEntry( "Applet Image", _appletImage );
	_cfg->writeEntry( "Current State", _state );
	_cfg->writeEntry( "First Run", false );
	_cfg->writeEntry( "Start on Launch", _startOnLaunch );
	_cfg->writeEntry( "Restore State", _restoreState );

	_cfg->setGroup( "Folding Core" );

	_cfg->writeEntry( "Working Directory", _workingDir );
	_cfg->writeEntry( "User Name", _userName );
	_cfg->writeEntry( "Team Number", _teamNumber );
	_cfg->writeEntry( "Client Type", _clientType );
	_cfg->writeEntry( "Force ASM", _forceasm );
	_cfg->writeEntry( "Big Packets", _bigPackets );
	_cfg->writeEntry( "Use Advanced Methods", _useadvmethods );
	_cfg->writeEntry( "Machine Id", _machineId );
	_cfg->writeEntry( "Last PID", _lastPid );

	_cfg->setGroup( "Model" );

	_cfg->writeEntry( "Model", _model );
	_cfg->writeEntry( "Display", _display );
	_cfg->writeEntry( "Quality", _quality );
	_cfg->writeEntry( "Ball Size", _ballSize );
	_cfg->writeEntry( "Stereo Depth", _stereoDepth );
	_cfg->writeEntry( "Show Water", _showH2O );
	_cfg->writeEntry( "Show Hydrogen", _showH2 );
	_cfg->writeEntry( "Non Backbone", _nonBackbone );

	return true;
} // save



