import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * The <code>ExamplePerfTestSuite</code> is a <code>TestCase</code> 
 * that demonstrates how to assemble a test suite containing 
 * performance-related tests.
 * 
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see junit.framework.TestCase
 */

public class ExamplePerfTestSuite extends TestCase {

	/**
	 * Constructs an <code>ExamplePerfTestSuite</code>
	 * with the specified name.
	 *
	 * @param name Test name.
	 */
	public ExamplePerfTestSuite(String name) {
		super(name);
	}

	/**
	 * Assembles and returns a test suite 
	 * containing all performance-related tests.
	 * <p>
	 * New performance tests should be added here.
	 *
	 * @return A non-null <code>Test</code> instance.
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();

		suite.addTest(ExampleTimedTest.suite());
		suite.addTest(ExampleLoadTest.suite());

		return suite;
	}
		
	/**
	 * Main.
	 */
	public static void main(String args[]) {
		junit.textui.TestRunner.run(suite());
	}
}
