/*********************************************************************
 *
 *	Copyright (C) 1999-2001 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:	Utilities
 * MODULE:	Assert
 * FILE:	Assert.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	nf	04/10/99	Initial version
 *      nf      09/16/01        Updated for JDK 1.4
 *
 * DESCRIPTION:
 *      This file defines the Assert class for providing
 *      assertion capabilities to Java programs.
 *
 * $Id: Assert.java,v 1.2 2001/09/17 01:07:21 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util;

/**
 * Provides C-style assertion capability for Java programs.
 * To turn the assert feature off, set the <code>enabled</code>
 * field to false.
 *
 * @author  Nathan Fiedler
 */
public class Assert {
    /** If true, assertions are enabled. */
    public static boolean enabled = true;

    /**
     * Test the object reference and throws a runtime exception if null.
     *
     * @param  o  Object reference to compare to null.
     * @exception  AssertionException
     *             Thrown if the assertion fails.
     */
    public static void assertNotNull(Object o) throws AssertionException {
	if (enabled && (o == null)) {
	    throw new AssertionException();
	}
    } // assertNotNull

    /**
     * Test the expression and throw a runtime exception if false.
     *
     * @param  expr  boolean expression to test.
     * @exception  AssertionException
     *             Thrown if the assertion fails.
     */
    public static void assertTrue(boolean expr) throws AssertionException {
	if (enabled && !expr) {
	    throw new AssertionException();
	}
    } // assertTrue

    /**
     * Test the expression and throw a runtime exception if false.
     * The message given in s will be displayed with the exception.
     *
     * @param  expr  boolean expression to test.
     * @param  s  string to display if assertion fails.
     * @exception  AssertionException
     *             Thrown if the assertion fails.
     */
    public static void asserts(boolean expr, String s)
        throws AssertionException {
	if (enabled && !expr) {
	    throw new AssertionException(s);
	}
    } // asserts
} // Assert
