/*********************************************************************
 *
 *      Copyright (C) 2001 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      JSwat Utils
 * FILE:        AppVersion.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      07/07/01        Initial version
 *      nf      09/11/01        Do not exit on error
 *
 * DESCRIPTION:
 *      This file defines the application version support.
 *
 * $Id: AppVersion.java,v 1.4 2002/04/09 00:45:23 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.jswat.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Implements the program version support.
 *
 * @author  Nathan Fiedler
 */
public class AppVersion {
    /** Resource bundle. */
    protected static ResourceBundle resources;
    /** Application version string. */
    protected static String version;

    static {
        // Load our version resource bundle.
        try {
            resources = ResourceBundle.getBundle
                ("com.bluemarsh.jswat.resources.version");
        } catch (MissingResourceException mre) {
            System.err.println("resources/version.properties not found");
        }
    }

    /**
     * Retrieves the version number for the application.
     *
     * @return  application version number string.
     */
    public static String getVersion() {
        if (version == null) {
            try {
//                  StringBuffer buf = new StringBuffer();
//                  buf.append(resources.getString("versionMajor"));
//                  buf.append('.');
//                  buf.append(resources.getString("versionMinor"));
//                  buf.append('.');
//                  buf.append(resources.getString("versionRelease"));
//                  String build = resources.getString("versionBuild");
//                  if (!build.equals("0")) {
//                      // Add the build part if it is non-zero.
//                      buf.append('.');
//                      buf.append(build);
//                  }
//                  version = buf.toString();
                version = resources.getString("versionString");
            } catch (MissingResourceException mre) {
                System.err.println("Missing 'version' property.");
            }
        }
        return version;
    } // getVersion
} // AppVersion
