/* This file was generated by SableCC (http://www.sablecc.org/). */

package com.bluemarsh.jswat.parser.java.lexer;

import java.io.*;
import java.util.*;
import com.bluemarsh.jswat.parser.java.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                            Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                            Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                            Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                            Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                            Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                            Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                            Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                            Token token = new69(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                            Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                            Token token = new71(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                            Token token = new72(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                            Token token = new73(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                            Token token = new74(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                            Token token = new75(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                            Token token = new76(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                            Token token = new77(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                            Token token = new78(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                            Token token = new79(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                            Token token = new80(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 81:
                        {
                            Token token = new81(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 82:
                        {
                            Token token = new82(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 83:
                        {
                            Token token = new83(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 84:
                        {
                            Token token = new84(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 85:
                        {
                            Token token = new85(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 86:
                        {
                            Token token = new86(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 87:
                        {
                            Token token = new87(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 88:
                        {
                            Token token = new88(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 89:
                        {
                            Token token = new89(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 90:
                        {
                            Token token = new90(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 91:
                        {
                            Token token = new91(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 92:
                        {
                            Token token = new92(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 93:
                        {
                            Token token = new93(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 94:
                        {
                            Token token = new94(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 95:
                        {
                            Token token = new95(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 96:
                        {
                            Token token = new96(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 97:
                        {
                            Token token = new97(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 98:
                        {
                            Token token = new98(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 99:
                        {
                            Token token = new99(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 100:
                        {
                            Token token = new100(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 101:
                        {
                            Token token = new101(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 102:
                        {
                            Token token = new102(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 103:
                        {
                            Token token = new103(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 104:
                        {
                            Token token = new104(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 105:
                        {
                            Token token = new105(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 106:
                        {
                            Token token = new106(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 107:
                        {
                            Token token = new107(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(String text, int line, int pos) { return new TWhiteSpace(text, line, pos); }
    Token new1(String text, int line, int pos) { return new TTraditionalComment(text, line, pos); }
    Token new2(String text, int line, int pos) { return new TDocumentationComment(text, line, pos); }
    Token new3(String text, int line, int pos) { return new TEndOfLineComment(text, line, pos); }
    Token new4(int line, int pos) { return new TAbstract(line, pos); }
    Token new5(int line, int pos) { return new TBoolean(line, pos); }
    Token new6(int line, int pos) { return new TBreak(line, pos); }
    Token new7(int line, int pos) { return new TByte(line, pos); }
    Token new8(int line, int pos) { return new TCase(line, pos); }
    Token new9(int line, int pos) { return new TCatch(line, pos); }
    Token new10(int line, int pos) { return new TChar(line, pos); }
    Token new11(int line, int pos) { return new TClass(line, pos); }
    Token new12(int line, int pos) { return new TConst(line, pos); }
    Token new13(int line, int pos) { return new TContinue(line, pos); }
    Token new14(int line, int pos) { return new TDefault(line, pos); }
    Token new15(int line, int pos) { return new TDo(line, pos); }
    Token new16(int line, int pos) { return new TDouble(line, pos); }
    Token new17(int line, int pos) { return new TElse(line, pos); }
    Token new18(int line, int pos) { return new TExtends(line, pos); }
    Token new19(int line, int pos) { return new TFinal(line, pos); }
    Token new20(int line, int pos) { return new TFinally(line, pos); }
    Token new21(int line, int pos) { return new TFloat(line, pos); }
    Token new22(int line, int pos) { return new TFor(line, pos); }
    Token new23(int line, int pos) { return new TGoto(line, pos); }
    Token new24(int line, int pos) { return new TIf(line, pos); }
    Token new25(int line, int pos) { return new TImplements(line, pos); }
    Token new26(int line, int pos) { return new TImport(line, pos); }
    Token new27(int line, int pos) { return new TInstanceof(line, pos); }
    Token new28(int line, int pos) { return new TInt(line, pos); }
    Token new29(int line, int pos) { return new TInterface(line, pos); }
    Token new30(int line, int pos) { return new TLong(line, pos); }
    Token new31(int line, int pos) { return new TNative(line, pos); }
    Token new32(int line, int pos) { return new TNew(line, pos); }
    Token new33(int line, int pos) { return new TPackage(line, pos); }
    Token new34(int line, int pos) { return new TPrivate(line, pos); }
    Token new35(int line, int pos) { return new TProtected(line, pos); }
    Token new36(int line, int pos) { return new TPublic(line, pos); }
    Token new37(int line, int pos) { return new TReturn(line, pos); }
    Token new38(int line, int pos) { return new TShort(line, pos); }
    Token new39(int line, int pos) { return new TStatic(line, pos); }
    Token new40(int line, int pos) { return new TStrictfp(line, pos); }
    Token new41(int line, int pos) { return new TSuper(line, pos); }
    Token new42(int line, int pos) { return new TSwitch(line, pos); }
    Token new43(int line, int pos) { return new TSynchronized(line, pos); }
    Token new44(int line, int pos) { return new TThis(line, pos); }
    Token new45(int line, int pos) { return new TThrow(line, pos); }
    Token new46(int line, int pos) { return new TThrows(line, pos); }
    Token new47(int line, int pos) { return new TTransient(line, pos); }
    Token new48(int line, int pos) { return new TTry(line, pos); }
    Token new49(int line, int pos) { return new TVoid(line, pos); }
    Token new50(int line, int pos) { return new TVolatile(line, pos); }
    Token new51(int line, int pos) { return new TWhile(line, pos); }
    Token new52(int line, int pos) { return new TTrue(line, pos); }
    Token new53(int line, int pos) { return new TFalse(line, pos); }
    Token new54(int line, int pos) { return new TNull(line, pos); }
    Token new55(int line, int pos) { return new TLParenthese(line, pos); }
    Token new56(int line, int pos) { return new TRParenthese(line, pos); }
    Token new57(int line, int pos) { return new TLBrace(line, pos); }
    Token new58(int line, int pos) { return new TRBrace(line, pos); }
    Token new59(int line, int pos) { return new TLBracket(line, pos); }
    Token new60(int line, int pos) { return new TRBracket(line, pos); }
    Token new61(int line, int pos) { return new TSemicolon(line, pos); }
    Token new62(int line, int pos) { return new TComma(line, pos); }
    Token new63(int line, int pos) { return new TDot(line, pos); }
    Token new64(int line, int pos) { return new TAssign(line, pos); }
    Token new65(int line, int pos) { return new TLt(line, pos); }
    Token new66(int line, int pos) { return new TGt(line, pos); }
    Token new67(int line, int pos) { return new TComplement(line, pos); }
    Token new68(int line, int pos) { return new TBitComplement(line, pos); }
    Token new69(int line, int pos) { return new TQuestion(line, pos); }
    Token new70(int line, int pos) { return new TColon(line, pos); }
    Token new71(int line, int pos) { return new TEq(line, pos); }
    Token new72(int line, int pos) { return new TLteq(line, pos); }
    Token new73(int line, int pos) { return new TGteq(line, pos); }
    Token new74(int line, int pos) { return new TNeq(line, pos); }
    Token new75(int line, int pos) { return new TAnd(line, pos); }
    Token new76(int line, int pos) { return new TOr(line, pos); }
    Token new77(int line, int pos) { return new TPlusPlus(line, pos); }
    Token new78(int line, int pos) { return new TMinusMinus(line, pos); }
    Token new79(int line, int pos) { return new TPlus(line, pos); }
    Token new80(int line, int pos) { return new TMinus(line, pos); }
    Token new81(int line, int pos) { return new TStar(line, pos); }
    Token new82(int line, int pos) { return new TDiv(line, pos); }
    Token new83(int line, int pos) { return new TBitAnd(line, pos); }
    Token new84(int line, int pos) { return new TBitOr(line, pos); }
    Token new85(int line, int pos) { return new TBitXor(line, pos); }
    Token new86(int line, int pos) { return new TMod(line, pos); }
    Token new87(int line, int pos) { return new TShiftLeft(line, pos); }
    Token new88(int line, int pos) { return new TSignedShiftRight(line, pos); }
    Token new89(int line, int pos) { return new TUnsignedShiftRight(line, pos); }
    Token new90(int line, int pos) { return new TPlusAssign(line, pos); }
    Token new91(int line, int pos) { return new TMinusAssign(line, pos); }
    Token new92(int line, int pos) { return new TStarAssign(line, pos); }
    Token new93(int line, int pos) { return new TDivAssign(line, pos); }
    Token new94(int line, int pos) { return new TBitAndAssign(line, pos); }
    Token new95(int line, int pos) { return new TBitOrAssign(line, pos); }
    Token new96(int line, int pos) { return new TBitXorAssign(line, pos); }
    Token new97(int line, int pos) { return new TModAssign(line, pos); }
    Token new98(int line, int pos) { return new TShiftLeftAssign(line, pos); }
    Token new99(int line, int pos) { return new TSignedShiftRightAssign(line, pos); }
    Token new100(int line, int pos) { return new TUnsignedShiftRightAssign(line, pos); }
    Token new101(String text, int line, int pos) { return new TDecimalIntegerLiteral(text, line, pos); }
    Token new102(String text, int line, int pos) { return new THexIntegerLiteral(text, line, pos); }
    Token new103(String text, int line, int pos) { return new TOctalIntegerLiteral(text, line, pos); }
    Token new104(String text, int line, int pos) { return new TFloatingPointLiteral(text, line, pos); }
    Token new105(String text, int line, int pos) { return new TCharacterLiteral(text, line, pos); }
    Token new106(String text, int line, int pos) { return new TStringLiteral(text, line, pos); }
    Token new107(String text, int line, int pos) { return new TIdentifier(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {12, 12, 3}, {13, 13, 4}, {32, 32, 5}, {33, 33, 6}, {34, 34, 7}, {36, 36, 8}, {37, 37, 9}, {38, 38, 10}, {39, 39, 11}, {40, 40, 12}, {41, 41, 13}, {42, 42, 14}, {43, 43, 15}, {44, 44, 16}, {45, 45, 17}, {46, 46, 18}, {47, 47, 19}, {48, 48, 20}, {49, 57, 21}, {58, 58, 22}, {59, 59, 23}, {60, 60, 24}, {61, 61, 25}, {62, 62, 26}, {63, 63, 27}, {65, 90, 28}, {91, 91, 29}, {93, 93, 30}, {94, 94, 31}, {95, 95, 32}, {97, 97, 33}, {98, 98, 34}, {99, 99, 35}, {100, 100, 36}, {101, 101, 37}, {102, 102, 38}, {103, 103, 39}, {104, 104, 40}, {105, 105, 41}, {106, 107, 40}, {108, 108, 42}, {109, 109, 40}, {110, 110, 43}, {111, 111, 40}, {112, 112, 44}, {113, 113, 40}, {114, 114, 45}, {115, 115, 46}, {116, 116, 47}, {117, 117, 40}, {118, 118, 48}, {119, 119, 49}, {120, 122, 40}, {123, 123, 50}, {124, 124, 51}, {125, 125, 52}, {126, 126, 53}, {170, 170, 54}, {181, 181, 55}, {186, 186, 56}, {192, 214, 57}, {216, 246, 58}, {248, 501, 59}, {506, 535, 60}, {592, 680, 61}, {688, 696, 62}, {699, 705, 63}, {720, 721, 64}, {736, 740, 65}, {890, 890, 66}, {902, 902, 67}, {904, 906, 68}, {908, 908, 69}, {910, 929, 70}, {931, 974, 71}, {976, 982, 72}, {986, 986, 73}, {988, 988, 74}, {990, 990, 75}, {992, 992, 76}, {994, 1011, 77}, {1025, 1036, 78}, {1038, 1103, 79}, {1105, 1116, 80}, {1118, 1153, 81}, {1168, 1220, 82}, {1223, 1224, 83}, {1227, 1228, 84}, {1232, 1259, 85}, {1262, 1269, 86}, {1272, 1273, 87}, {1329, 1366, 88}, {1369, 1369, 89}, {1377, 1415, 90}, {1488, 1514, 91}, {1520, 1522, 92}, {1569, 1594, 93}, {1600, 1610, 94}, {1649, 1719, 95}, {1722, 1726, 96}, {1728, 1742, 97}, {1744, 1747, 98}, {1749, 1749, 99}, {1765, 1766, 100}, {2309, 2361, 101}, {2365, 2365, 102}, {2392, 2401, 103}, {2437, 2444, 104}, {2447, 2448, 105}, {2451, 2472, 106}, {2474, 2480, 107}, {2482, 2482, 108}, {2486, 2489, 109}, {2524, 2525, 110}, {2527, 2529, 111}, {2544, 2545, 112}, {2565, 2570, 113}, {2575, 2576, 114}, {2579, 2600, 115}, {2602, 2608, 116}, {2610, 2611, 117}, {2613, 2614, 118}, {2616, 2617, 119}, {2649, 2652, 120}, {2654, 2654, 121}, {2674, 2676, 122}, {2693, 2699, 123}, {2701, 2701, 124}, {2703, 2705, 125}, {2707, 2728, 126}, {2730, 2736, 127}, {2738, 2739, 128}, {2741, 2745, 129}, {2749, 2749, 130}, {2784, 2784, 131}, {2821, 2828, 132}, {2831, 2832, 133}, {2835, 2856, 134}, {2858, 2864, 135}, {2866, 2867, 136}, {2870, 2873, 137}, {2877, 2877, 138}, {2908, 2909, 139}, {2911, 2913, 140}, {2949, 2954, 141}, {2958, 2960, 142}, {2962, 2965, 143}, {2969, 2970, 144}, {2972, 2972, 145}, {2974, 2975, 146}, {2979, 2980, 147}, {2984, 2986, 148}, {2990, 2997, 149}, {2999, 3001, 150}, {3077, 3084, 151}, {3086, 3088, 152}, {3090, 3112, 153}, {3114, 3123, 154}, {3125, 3129, 155}, {3168, 3169, 156}, {3205, 3212, 157}, {3214, 3216, 158}, {3218, 3240, 159}, {3242, 3251, 160}, {3253, 3257, 161}, {3294, 3294, 162}, {3296, 3297, 163}, {3333, 3340, 164}, {3342, 3344, 165}, {3346, 3368, 166}, {3370, 3385, 167}, {3424, 3425, 168}, {3585, 3630, 169}, {3632, 3632, 170}, {3634, 3635, 171}, {3648, 3654, 172}, {3713, 3714, 173}, {3716, 3716, 174}, {3719, 3720, 175}, {3722, 3722, 176}, {3725, 3725, 177}, {3732, 3735, 178}, {3737, 3743, 179}, {3745, 3747, 180}, {3749, 3749, 181}, {3751, 3751, 182}, {3754, 3755, 183}, {3757, 3758, 184}, {3760, 3760, 185}, {3762, 3763, 186}, {3773, 3773, 187}, {3776, 3780, 188}, {3782, 3782, 189}, {3804, 3805, 190}, {3904, 3911, 191}, {3913, 3945, 192}, {4256, 4293, 193}, {4304, 4342, 194}, {4352, 4441, 195}, {4447, 4514, 196}, {4520, 4601, 197}, {7680, 7835, 198}, {7840, 7929, 199}, {7936, 7957, 200}, {7960, 7965, 201}, {7968, 8005, 202}, {8008, 8013, 203}, {8016, 8023, 204}, {8025, 8025, 205}, {8027, 8027, 206}, {8029, 8029, 207}, {8031, 8061, 208}, {8064, 8116, 209}, {8118, 8124, 210}, {8126, 8126, 211}, {8130, 8132, 212}, {8134, 8140, 213}, {8144, 8147, 214}, {8150, 8155, 215}, {8160, 8172, 216}, {8178, 8180, 217}, {8182, 8188, 218}, {8319, 8319, 219}, {8450, 8450, 220}, {8455, 8455, 221}, {8458, 8467, 222}, {8469, 8469, 223}, {8472, 8477, 224}, {8484, 8484, 225}, {8486, 8486, 226}, {8488, 8488, 227}, {8490, 8497, 228}, {8499, 8504, 229}, {12293, 12293, 230}, {12337, 12341, 231}, {12353, 12436, 232}, {12443, 12446, 233}, {12449, 12538, 234}, {12540, 12542, 235}, {12549, 12588, 236}, {12593, 12686, 237}, {19968, 40869, 238}, {44032, 55203, 239}, {63744, 64045, 240}, {64256, 64262, 241}, {64275, 64279, 242}, {64287, 64296, 243}, {64298, 64310, 244}, {64312, 64316, 245}, {64318, 64318, 246}, {64320, 64321, 247}, {64323, 64324, 248}, {64326, 64433, 249}, {64467, 64829, 250}, {64848, 64911, 251}, {64914, 64967, 252}, {65008, 65019, 253}, {65136, 65138, 254}, {65140, 65140, 255}, {65142, 65276, 256}, {65313, 65338, 257}, {65345, 65370, 258}, {65382, 65470, 259}, {65474, 65479, 260}, {65482, 65487, 261}, {65490, 65495, 262}, {65498, 65500, 263}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 9, 1}, {10, 10, 264}, {12, 32, -2}, },
            {{9, 32, -2}, },
            {{61, 61, 265}, },
            {{0, 9, 266}, {11, 12, 266}, {14, 33, 266}, {34, 34, 267}, {35, 91, 266}, {92, 92, 268}, {93, 65535, 266}, },
            {{36, 36, 269}, {48, 57, 270}, {65, 90, 271}, {95, 95, 272}, {97, 122, 273}, {170, 170, 274}, {181, 181, 275}, {186, 186, 276}, {192, 214, 277}, {216, 246, 278}, {248, 501, 279}, {506, 535, 280}, {592, 680, 281}, {688, 696, 282}, {699, 705, 283}, {720, 721, 284}, {736, 740, 285}, {890, 890, 286}, {902, 902, 287}, {904, 906, 288}, {908, 908, 289}, {910, 929, 290}, {931, 974, 291}, {976, 982, 292}, {986, 986, 293}, {988, 988, 294}, {990, 990, 295}, {992, 992, 296}, {994, 1011, 297}, {1025, 1036, 298}, {1038, 1103, 299}, {1105, 1116, 300}, {1118, 1153, 301}, {1168, 1220, 302}, {1223, 1224, 303}, {1227, 1228, 304}, {1232, 1259, 305}, {1262, 1269, 306}, {1272, 1273, 307}, {1329, 1366, 308}, {1369, 1369, 309}, {1377, 1415, 310}, {1488, 1514, 311}, {1520, 1522, 312}, {1569, 1594, 313}, {1600, 1610, 314}, {1632, 1641, 315}, {1649, 1719, 316}, {1722, 1726, 317}, {1728, 1742, 318}, {1744, 1747, 319}, {1749, 1749, 320}, {1765, 1766, 321}, {1776, 1785, 322}, {2309, 2361, 323}, {2365, 2365, 324}, {2392, 2401, 325}, {2406, 2415, 326}, {2437, 2444, 327}, {2447, 2448, 328}, {2451, 2472, 329}, {2474, 2480, 330}, {2482, 2482, 331}, {2486, 2489, 332}, {2524, 2525, 333}, {2527, 2529, 334}, {2534, 2543, 335}, {2544, 2545, 336}, {2565, 2570, 337}, {2575, 2576, 338}, {2579, 2600, 339}, {2602, 2608, 340}, {2610, 2611, 341}, {2613, 2614, 342}, {2616, 2617, 343}, {2649, 2652, 344}, {2654, 2654, 345}, {2662, 2671, 346}, {2674, 2676, 347}, {2693, 2699, 348}, {2701, 2701, 349}, {2703, 2705, 350}, {2707, 2728, 351}, {2730, 2736, 352}, {2738, 2739, 353}, {2741, 2745, 354}, {2749, 2749, 355}, {2784, 2784, 356}, {2790, 2799, 357}, {2821, 2828, 358}, {2831, 2832, 359}, {2835, 2856, 360}, {2858, 2864, 361}, {2866, 2867, 362}, {2870, 2873, 363}, {2877, 2877, 364}, {2908, 2909, 365}, {2911, 2913, 366}, {2918, 2927, 367}, {2949, 2954, 368}, {2958, 2960, 369}, {2962, 2965, 370}, {2969, 2970, 371}, {2972, 2972, 372}, {2974, 2975, 373}, {2979, 2980, 374}, {2984, 2986, 375}, {2990, 2997, 376}, {2999, 3001, 377}, {3047, 3055, 378}, {3077, 3084, 379}, {3086, 3088, 380}, {3090, 3112, 381}, {3114, 3123, 382}, {3125, 3129, 383}, {3168, 3169, 384}, {3174, 3183, 385}, {3205, 3212, 386}, {3214, 3216, 387}, {3218, 3240, 388}, {3242, 3251, 389}, {3253, 3257, 390}, {3294, 3294, 391}, {3296, 3297, 392}, {3302, 3311, 393}, {3333, 3340, 394}, {3342, 3344, 395}, {3346, 3368, 396}, {3370, 3385, 397}, {3424, 3425, 398}, {3430, 3439, 399}, {3585, 3630, 400}, {3632, 3632, 401}, {3634, 3635, 402}, {3648, 3654, 403}, {3664, 3673, 404}, {3713, 3714, 405}, {3716, 3716, 406}, {3719, 3720, 407}, {3722, 3722, 408}, {3725, 3725, 409}, {3732, 3735, 410}, {3737, 3743, 411}, {3745, 3747, 412}, {3749, 3749, 413}, {3751, 3751, 414}, {3754, 3755, 415}, {3757, 3758, 416}, {3760, 3760, 417}, {3762, 3763, 418}, {3773, 3773, 419}, {3776, 3780, 420}, {3782, 3782, 421}, {3792, 3801, 422}, {3804, 3805, 423}, {3872, 3881, 424}, {3904, 3911, 425}, {3913, 3945, 426}, {4256, 4293, 427}, {4304, 4342, 428}, {4352, 4441, 429}, {4447, 4514, 430}, {4520, 4601, 431}, {7680, 7835, 432}, {7840, 7929, 433}, {7936, 7957, 434}, {7960, 7965, 435}, {7968, 8005, 436}, {8008, 8013, 437}, {8016, 8023, 438}, {8025, 8025, 439}, {8027, 8027, 440}, {8029, 8029, 441}, {8031, 8061, 442}, {8064, 8116, 443}, {8118, 8124, 444}, {8126, 8126, 445}, {8130, 8132, 446}, {8134, 8140, 447}, {8144, 8147, 448}, {8150, 8155, 449}, {8160, 8172, 450}, {8178, 8180, 451}, {8182, 8188, 452}, {8319, 8319, 453}, {8450, 8450, 454}, {8455, 8455, 455}, {8458, 8467, 456}, {8469, 8469, 457}, {8472, 8477, 458}, {8484, 8484, 459}, {8486, 8486, 460}, {8488, 8488, 461}, {8490, 8497, 462}, {8499, 8504, 463}, {12293, 12293, 464}, {12337, 12341, 465}, {12353, 12436, 466}, {12443, 12446, 467}, {12449, 12538, 468}, {12540, 12542, 469}, {12549, 12588, 470}, {12593, 12686, 471}, {19968, 40869, 472}, {44032, 55203, 473}, {63744, 64045, 474}, {64256, 64262, 475}, {64275, 64279, 476}, {64287, 64296, 477}, {64298, 64310, 478}, {64312, 64316, 479}, {64318, 64318, 480}, {64320, 64321, 481}, {64323, 64324, 482}, {64326, 64433, 483}, {64467, 64829, 484}, {64848, 64911, 485}, {64914, 64967, 486}, {65008, 65019, 487}, {65136, 65138, 488}, {65140, 65140, 489}, {65142, 65276, 490}, {65296, 65305, 491}, {65313, 65338, 492}, {65345, 65370, 493}, {65382, 65470, 494}, {65474, 65479, 495}, {65482, 65487, 496}, {65490, 65495, 497}, {65498, 65500, 498}, },
            {{61, 61, 499}, },
            {{38, 38, 500}, {61, 61, 501}, },
            {{0, 9, 502}, {11, 12, 502}, {14, 38, 502}, {40, 91, 502}, {92, 92, 503}, {93, 65535, 502}, },
            {},
            {},
            {{61, 61, 504}, },
            {{43, 43, 505}, {61, 61, 506}, },
            {},
            {{45, 45, 507}, {61, 61, 508}, },
            {{48, 57, 509}, },
            {{42, 42, 510}, {47, 47, 511}, {61, 61, 512}, },
            {{46, 46, 513}, {48, 55, 514}, {56, 57, 515}, {68, 68, 516}, {69, 69, 517}, {70, 70, 518}, {76, 76, 519}, {88, 88, 520}, {100, 100, 521}, {101, 101, 522}, {102, 102, 523}, {108, 108, 524}, {120, 120, 525}, },
            {{46, 46, 513}, {48, 57, 526}, {68, 76, -22}, {100, 108, -22}, },
            {},
            {},
            {{60, 60, 527}, {61, 61, 528}, },
            {{61, 61, 529}, },
            {{61, 61, 530}, {62, 62, 531}, },
            {},
            {{36, 65500, -10}, },
            {},
            {},
            {{61, 61, 532}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 273}, {98, 98, 533}, {99, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 110, 273}, {111, 111, 534}, {112, 113, 273}, {114, 114, 535}, {115, 120, 273}, {121, 121, 536}, {122, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 537}, {98, 103, 273}, {104, 104, 538}, {105, 107, 273}, {108, 108, 539}, {109, 110, 273}, {111, 111, 540}, {112, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 100, 273}, {101, 101, 541}, {102, 110, 273}, {111, 111, 542}, {112, 65500, -37}, },
            {{36, 95, -10}, {97, 107, 273}, {108, 108, 543}, {109, 119, 273}, {120, 120, 544}, {121, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 545}, {98, 104, 273}, {105, 105, 546}, {106, 107, 273}, {108, 108, 547}, {109, 110, 273}, {111, 111, 548}, {112, 65500, -37}, },
            {{36, 110, -36}, {111, 111, 549}, {112, 65500, -37}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 101, 273}, {102, 102, 550}, {103, 108, 273}, {109, 109, 551}, {110, 110, 552}, {111, 122, 273}, {170, 65500, -10}, },
            {{36, 110, -36}, {111, 111, 553}, {112, 65500, -37}, },
            {{36, 95, -10}, {97, 97, 554}, {98, 100, 273}, {101, 101, 555}, {102, 116, 273}, {117, 117, 556}, {118, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 557}, {98, 113, 273}, {114, 114, 558}, {115, 116, 273}, {117, 117, 559}, {118, 65500, -45}, },
            {{36, 100, -38}, {101, 101, 560}, {102, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 103, 273}, {104, 104, 561}, {105, 115, 273}, {116, 116, 562}, {117, 117, 563}, {118, 118, 273}, {119, 119, 564}, {120, 120, 273}, {121, 121, 565}, {122, 65500, -36}, },
            {{36, 103, -48}, {104, 104, 566}, {105, 113, 273}, {114, 114, 567}, {115, 122, 273}, {170, 65500, -10}, },
            {{36, 110, -36}, {111, 111, 568}, {112, 65500, -37}, },
            {{36, 103, -48}, {104, 104, 569}, {105, 122, 273}, {170, 65500, -10}, },
            {},
            {{61, 61, 570}, {124, 124, 571}, },
            {},
            {},
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{9, 32, -2}, },
            {},
            {{0, 65535, -9}, },
            {},
            {{34, 34, 572}, {39, 39, 573}, {48, 51, 574}, {52, 55, 575}, {92, 92, 576}, {98, 98, 577}, {102, 102, 578}, {110, 110, 579}, {114, 114, 580}, {116, 116, 581}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {},
            {},
            {},
            {{39, 39, 582}, },
            {{34, 34, 583}, {39, 39, 584}, {48, 51, 585}, {52, 55, 586}, {92, 92, 587}, {98, 98, 588}, {102, 102, 589}, {110, 110, 590}, {114, 114, 591}, {116, 116, 592}, },
            {},
            {},
            {},
            {},
            {},
            {{48, 57, 509}, {68, 68, 593}, {69, 69, 594}, {70, 70, 595}, {100, 100, 596}, {101, 101, 597}, {102, 102, 598}, },
            {{0, 9, 599}, {10, 10, 600}, {11, 12, 599}, {13, 13, 601}, {14, 41, 599}, {42, 42, 602}, {43, 65535, 599}, },
            {{0, 9, 603}, {10, 10, 604}, {11, 12, 603}, {13, 13, 605}, {14, 65535, 603}, },
            {},
            {{48, 57, 606}, {68, 68, 607}, {69, 69, 608}, {70, 70, 609}, {100, 100, 610}, {101, 101, 611}, {102, 102, 612}, },
            {{46, 70, -22}, {76, 76, 613}, {100, 102, -22}, {108, 108, 614}, },
            {{46, 46, 513}, {48, 57, 515}, {68, 70, -22}, {100, 102, -22}, },
            {},
            {{43, 43, 615}, {45, 45, 616}, {48, 57, 617}, },
            {},
            {},
            {{48, 57, 618}, {65, 70, 619}, {97, 102, 620}, },
            {},
            {{43, 57, -519}, },
            {},
            {},
            {{48, 102, -522}, },
            {{46, 108, -23}, },
            {{61, 61, 621}, },
            {},
            {},
            {},
            {{61, 61, 622}, {62, 62, 623}, },
            {},
            {{36, 95, -10}, {97, 114, 273}, {115, 115, 624}, {116, 122, 273}, {170, 65500, -10}, },
            {{36, 110, -36}, {111, 111, 625}, {112, 65500, -37}, },
            {{36, 100, -38}, {101, 101, 626}, {102, 65500, -47}, },
            {{36, 95, -10}, {97, 115, 273}, {116, 116, 627}, {117, 122, 273}, {170, 65500, -10}, },
            {{36, 114, -535}, {115, 115, 628}, {116, 116, 629}, {117, 65500, -538}, },
            {{36, 95, -10}, {97, 97, 630}, {98, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 631}, {98, 65500, -540}, },
            {{36, 95, -10}, {97, 109, 273}, {110, 110, 632}, {111, 65500, -43}, },
            {{36, 101, -43}, {102, 102, 633}, {103, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 116, 273}, {117, 117, 634}, {118, 65500, -45}, },
            {{36, 114, -535}, {115, 115, 635}, {116, 65500, -535}, },
            {{36, 115, -538}, {116, 116, 636}, {117, 65500, -538}, },
            {{36, 107, -39}, {108, 108, 637}, {109, 122, 273}, {170, 65500, -10}, },
            {{36, 109, -542}, {110, 110, 638}, {111, 65500, -43}, },
            {{36, 110, -36}, {111, 111, 639}, {112, 65500, -37}, },
            {{36, 95, -10}, {97, 113, 273}, {114, 114, 640}, {115, 65500, -49}, },
            {{36, 115, -538}, {116, 116, 641}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 111, 273}, {112, 112, 642}, {113, 122, 273}, {170, 65500, -10}, },
            {{36, 114, -535}, {115, 115, 643}, {116, 116, 644}, {117, 65500, -538}, },
            {{36, 109, -542}, {110, 110, 645}, {111, 65500, -43}, },
            {{36, 115, -538}, {116, 116, 646}, {117, 65500, -538}, },
            {{36, 95, -10}, {97, 118, 273}, {119, 119, 647}, {120, 122, 273}, {170, 65500, -10}, },
            {{36, 107, -39}, {108, 108, 648}, {109, 65500, -547}, },
            {{36, 95, -10}, {97, 98, 273}, {99, 99, 649}, {100, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 104, 273}, {105, 105, 650}, {106, 110, 273}, {111, 111, 651}, {112, 65500, -37}, },
            {{36, 97, -35}, {98, 98, 652}, {99, 65500, -35}, },
            {{36, 115, -538}, {116, 116, 653}, {117, 65500, -538}, },
            {{36, 110, -36}, {111, 111, 654}, {112, 65500, -37}, },
            {{36, 95, -10}, {97, 97, 655}, {98, 113, 273}, {114, 114, 656}, {115, 65500, -49}, },
            {{36, 111, -553}, {112, 112, 657}, {113, 65500, -553}, },
            {{36, 104, -560}, {105, 105, 658}, {106, 122, 273}, {170, 65500, -10}, },
            {{36, 109, -542}, {110, 110, 659}, {111, 65500, -43}, },
            {{36, 104, -560}, {105, 105, 660}, {106, 113, 273}, {114, 114, 661}, {115, 65500, -49}, },
            {{36, 95, -10}, {97, 97, 662}, {98, 116, 273}, {117, 117, 663}, {118, 120, 273}, {121, 121, 664}, {122, 65500, -36}, },
            {{36, 104, -560}, {105, 105, 665}, {106, 107, 273}, {108, 108, 666}, {109, 65500, -547}, },
            {{36, 104, -560}, {105, 105, 667}, {106, 65500, -566}, },
            {},
            {},
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 34, -9}, {35, 47, 266}, {48, 55, 668}, {56, 91, 266}, {92, 65535, -9}, },
            {{0, 47, -576}, {48, 55, 669}, {56, 65535, -576}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {},
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, {48, 55, 670}, },
            {{39, 39, 582}, {48, 55, 671}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {{39, 39, 582}, },
            {},
            {{43, 43, 672}, {45, 45, 673}, {48, 57, 674}, },
            {},
            {},
            {{43, 57, -596}, },
            {},
            {{0, 41, -512}, {42, 42, 675}, {43, 65535, 599}, },
            {{0, 65535, -601}, },
            {{0, 9, 599}, {10, 10, 676}, {11, 65535, -601}, },
            {{0, 9, 677}, {10, 10, 678}, {11, 12, 677}, {13, 13, 679}, {14, 41, 677}, {42, 42, 680}, {43, 46, 677}, {47, 47, 681}, {48, 65535, 677}, },
            {{0, 65535, -513}, },
            {},
            {{10, 10, 682}, },
            {{48, 102, -515}, },
            {},
            {{43, 43, 683}, {45, 45, 684}, {48, 57, 685}, },
            {},
            {},
            {{43, 57, -610}, },
            {},
            {},
            {},
            {{48, 57, 617}, },
            {{48, 57, 617}, },
            {{48, 57, 617}, {68, 68, 686}, {70, 70, 687}, {100, 100, 688}, {102, 102, 689}, },
            {{48, 70, -522}, {76, 76, 690}, {97, 102, 620}, {108, 108, 691}, },
            {{48, 108, -620}, },
            {{48, 108, -620}, },
            {},
            {},
            {{61, 61, 692}, },
            {{36, 115, -538}, {116, 116, 693}, {117, 65500, -538}, },
            {{36, 107, -39}, {108, 108, 694}, {109, 65500, -547}, },
            {{36, 95, -10}, {97, 97, 695}, {98, 65500, -540}, },
            {{36, 100, -38}, {101, 101, 696}, {102, 65500, -47}, },
            {{36, 100, -38}, {101, 101, 697}, {102, 65500, -47}, },
            {{36, 98, -559}, {99, 99, 698}, {100, 65500, -559}, },
            {{36, 113, -550}, {114, 114, 699}, {115, 65500, -49}, },
            {{36, 114, -535}, {115, 115, 700}, {116, 65500, -535}, },
            {{36, 114, -535}, {115, 115, 701}, {116, 116, 702}, {117, 65500, -538}, },
            {{36, 95, -10}, {97, 97, 703}, {98, 65500, -540}, },
            {{36, 97, -35}, {98, 98, 704}, {99, 65500, -35}, },
            {{36, 100, -38}, {101, 101, 705}, {102, 65500, -47}, },
            {{36, 100, -38}, {101, 101, 706}, {102, 65500, -47}, },
            {{36, 114, -535}, {115, 115, 707}, {116, 65500, -535}, },
            {{36, 95, -10}, {97, 97, 708}, {98, 65500, -540}, },
            {{36, 95, -10}, {97, 97, 709}, {98, 65500, -540}, },
            {{36, 65500, -10}, },
            {{36, 110, -36}, {111, 111, 710}, {112, 65500, -37}, },
            {{36, 107, -39}, {108, 108, 711}, {109, 110, 273}, {111, 111, 712}, {112, 65500, -37}, },
            {{36, 115, -538}, {116, 116, 713}, {117, 65500, -538}, },
            {{36, 100, -38}, {101, 101, 714}, {102, 65500, -47}, },
            {{36, 95, -10}, {97, 102, 273}, {103, 103, 715}, {104, 122, 273}, {170, 65500, -10}, },
            {{36, 104, -560}, {105, 105, 716}, {106, 65500, -566}, },
            {{36, 65500, -10}, },
            {{36, 107, -39}, {108, 108, 717}, {109, 65500, -547}, },
            {{36, 95, -10}, {97, 106, 273}, {107, 107, 718}, {108, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 117, 273}, {118, 118, 719}, {119, 122, 273}, {170, 65500, -10}, },
            {{36, 115, -538}, {116, 116, 720}, {117, 65500, -538}, },
            {{36, 107, -39}, {108, 108, 721}, {109, 65500, -547}, },
            {{36, 116, -544}, {117, 117, 722}, {118, 65500, -45}, },
            {{36, 113, -550}, {114, 114, 723}, {115, 65500, -49}, },
            {{36, 115, -538}, {116, 116, 724}, {117, 65500, -538}, },
            {{36, 104, -560}, {105, 105, 725}, {106, 65500, -566}, },
            {{36, 100, -38}, {101, 101, 726}, {102, 65500, -47}, },
            {{36, 115, -538}, {116, 116, 727}, {117, 65500, -538}, },
            {{36, 98, -559}, {99, 99, 728}, {100, 65500, -559}, },
            {{36, 114, -535}, {115, 115, 729}, {116, 65500, -535}, },
            {{36, 110, -36}, {111, 111, 730}, {112, 65500, -37}, },
            {{36, 109, -542}, {110, 110, 731}, {111, 65500, -43}, },
            {{36, 100, -38}, {101, 101, 732}, {102, 65500, -47}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 99, 273}, {100, 100, 733}, {101, 122, 273}, {170, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 734}, {98, 65500, -540}, },
            {{36, 107, -39}, {108, 108, 735}, {109, 65500, -547}, },
            {{0, 47, -576}, {48, 55, 736}, {56, 65535, -576}, },
            {{0, 65535, -9}, },
            {{39, 39, 582}, {48, 55, 737}, },
            {{39, 39, 582}, },
            {{48, 57, 674}, },
            {{48, 57, 674}, },
            {{48, 57, 674}, {68, 68, 593}, {70, 100, -511}, {102, 102, 598}, },
            {{0, 9, 738}, {10, 10, 739}, {11, 12, 738}, {13, 13, 740}, {14, 41, 738}, {42, 42, 675}, {43, 46, 738}, {47, 47, 741}, {48, 65535, 738}, },
            {{0, 65535, -601}, },
            {{0, 9, 742}, {10, 10, 743}, {11, 12, 742}, {13, 13, 744}, {14, 41, 742}, {42, 42, 745}, {43, 65535, 742}, },
            {{0, 65535, -679}, },
            {{0, 9, 742}, {10, 10, 746}, {11, 65535, -679}, },
            {{0, 65535, -604}, },
            {},
            {},
            {{48, 57, 685}, },
            {{48, 57, 685}, },
            {{48, 57, 685}, {68, 68, 607}, {70, 100, -515}, {102, 102, 612}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{36, 113, -550}, {114, 114, 747}, {115, 65500, -49}, },
            {{36, 100, -38}, {101, 101, 748}, {102, 65500, -47}, },
            {{36, 106, -651}, {107, 107, 749}, {108, 65500, -651}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 103, -48}, {104, 104, 750}, {105, 65500, -51}, },
            {{36, 65500, -10}, },
            {{36, 114, -535}, {115, 115, 751}, {116, 65500, -535}, },
            {{36, 115, -538}, {116, 116, 752}, {117, 65500, -538}, },
            {{36, 104, -560}, {105, 105, 753}, {106, 65500, -566}, },
            {{36, 116, -544}, {117, 117, 754}, {118, 65500, -45}, },
            {{36, 107, -39}, {108, 108, 755}, {109, 65500, -547}, },
            {{36, 65500, -10}, },
            {{36, 109, -542}, {110, 110, 756}, {111, 65500, -43}, },
            {{36, 100, -38}, {101, 101, 757}, {102, 65500, -47}, },
            {{36, 107, -39}, {108, 108, 758}, {109, 65500, -547}, },
            {{36, 115, -538}, {116, 116, 759}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 760}, {102, 65500, -47}, },
            {{36, 113, -550}, {114, 114, 761}, {115, 65500, -49}, },
            {{36, 95, -10}, {97, 97, 762}, {98, 65500, -540}, },
            {{36, 113, -550}, {114, 114, 763}, {115, 65500, -49}, },
            {{36, 65500, -10}, },
            {{36, 117, -652}, {118, 118, 764}, {119, 65500, -652}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 97, 765}, {98, 65500, -540}, },
            {{36, 95, -10}, {97, 97, 766}, {98, 65500, -540}, },
            {{36, 100, -38}, {101, 101, 767}, {102, 65500, -47}, },
            {{36, 104, -560}, {105, 105, 768}, {106, 65500, -566}, },
            {{36, 113, -550}, {114, 114, 769}, {115, 65500, -49}, },
            {{36, 115, -538}, {116, 116, 770}, {117, 65500, -538}, },
            {{36, 104, -560}, {105, 105, 771}, {106, 65500, -566}, },
            {{36, 98, -559}, {99, 99, 772}, {100, 65500, -559}, },
            {{36, 113, -550}, {114, 114, 773}, {115, 65500, -49}, },
            {{36, 98, -559}, {99, 99, 774}, {100, 65500, -559}, },
            {{36, 103, -48}, {104, 104, 775}, {105, 65500, -51}, },
            {{36, 65500, -10}, },
            {{36, 118, -557}, {119, 119, 776}, {120, 65500, -557}, },
            {{36, 114, -535}, {115, 115, 777}, {116, 65500, -535}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 115, -538}, {116, 116, 778}, {117, 65500, -538}, },
            {{36, 100, -38}, {101, 101, 779}, {102, 65500, -47}, },
            {{0, 65535, -9}, },
            {{39, 39, 582}, },
            {{0, 9, 780}, {10, 10, 781}, {11, 12, 780}, {13, 13, 782}, {14, 41, 780}, {42, 42, 783}, {43, 65535, 780}, },
            {{0, 65535, -740}, },
            {{0, 9, 780}, {10, 10, 784}, {11, 65535, -740}, },
            {},
            {{0, 65535, -679}, },
            {{0, 65535, -679}, },
            {{0, 9, 742}, {10, 10, 785}, {11, 65535, -679}, },
            {{0, 41, -604}, {42, 42, 745}, {43, 65535, -604}, },
            {{0, 65535, -679}, },
            {{36, 95, -10}, {97, 97, 786}, {98, 65500, -540}, },
            {{36, 95, -10}, {97, 97, 787}, {98, 65500, -540}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 109, -542}, {110, 110, 788}, {111, 65500, -43}, },
            {{36, 107, -39}, {108, 108, 789}, {109, 65500, -547}, },
            {{36, 100, -38}, {101, 101, 790}, {102, 65500, -47}, },
            {{36, 99, -667}, {100, 100, 791}, {101, 65500, -667}, },
            {{36, 65500, -10}, },
            {{36, 107, -39}, {108, 108, 792}, {109, 65500, -547}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 108, 273}, {109, 109, 793}, {110, 122, 273}, {170, 65500, -10}, },
            {{36, 115, -538}, {116, 116, 794}, {117, 65500, -538}, },
            {{36, 109, -542}, {110, 110, 795}, {111, 65500, -43}, },
            {{36, 101, -43}, {102, 102, 796}, {103, 65500, -543}, },
            {{36, 100, -38}, {101, 101, 797}, {102, 65500, -47}, },
            {{36, 102, -647}, {103, 103, 798}, {104, 65500, -647}, },
            {{36, 115, -538}, {116, 116, 799}, {117, 65500, -538}, },
            {{36, 98, -559}, {99, 99, 800}, {100, 65500, -559}, },
            {{36, 98, -559}, {99, 99, 801}, {100, 65500, -559}, },
            {{36, 109, -542}, {110, 110, 802}, {111, 65500, -43}, },
            {{36, 65500, -10}, },
            {{36, 98, -559}, {99, 99, 803}, {100, 65500, -559}, },
            {{36, 115, -538}, {116, 116, 804}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 103, -48}, {104, 104, 805}, {105, 65500, -51}, },
            {{36, 113, -550}, {114, 114, 806}, {115, 65500, -49}, },
            {{36, 114, -535}, {115, 115, 807}, {116, 65500, -535}, },
            {{36, 104, -560}, {105, 105, 808}, {106, 65500, -566}, },
            {{36, 104, -560}, {105, 105, 809}, {106, 65500, -566}, },
            {{36, 65500, -10}, },
            {{0, 65535, -740}, },
            {{0, 65535, -740}, },
            {{0, 9, 780}, {10, 10, 810}, {11, 65535, -740}, },
            {{0, 41, -677}, {42, 42, 783}, {43, 65535, -677}, },
            {{0, 65535, -740}, },
            {{0, 65535, -679}, },
            {{36, 98, -559}, {99, 99, 811}, {100, 65500, -559}, },
            {{36, 109, -542}, {110, 110, 812}, {111, 65500, -43}, },
            {{36, 116, -544}, {117, 117, 813}, {118, 65500, -45}, },
            {{36, 115, -538}, {116, 116, 814}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 114, -535}, {115, 115, 815}, {116, 65500, -535}, },
            {{36, 95, -10}, {97, 120, 273}, {121, 121, 816}, {122, 65500, -36}, },
            {{36, 100, -38}, {101, 101, 817}, {102, 65500, -47}, },
            {{36, 65500, -10}, },
            {{36, 98, -559}, {99, 99, 818}, {100, 65500, -559}, },
            {{36, 95, -10}, {97, 97, 819}, {98, 65500, -540}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 820}, {102, 65500, -47}, },
            {{36, 100, -38}, {101, 101, 821}, {102, 65500, -47}, },
            {{36, 115, -538}, {116, 116, 822}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 101, -43}, {102, 102, 823}, {103, 65500, -543}, },
            {{36, 65500, -10}, },
            {{36, 110, -36}, {111, 111, 824}, {112, 65500, -37}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 825}, {102, 65500, -47}, },
            {{36, 107, -39}, {108, 108, 826}, {109, 65500, -547}, },
            {{0, 65535, -740}, },
            {{36, 115, -538}, {116, 116, 827}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 828}, {102, 65500, -47}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 109, -542}, {110, 110, 829}, {111, 65500, -43}, },
            {{36, 100, -38}, {101, 101, 830}, {102, 65500, -47}, },
            {{36, 98, -559}, {99, 99, 831}, {100, 65500, -559}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 832}, {102, 65500, -47}, },
            {{36, 111, -553}, {112, 112, 833}, {113, 65500, -553}, },
            {{36, 109, -542}, {110, 110, 834}, {111, 65500, -43}, },
            {{36, 109, -542}, {110, 110, 835}, {111, 65500, -43}, },
            {{36, 100, -38}, {101, 101, 836}, {102, 65500, -47}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 115, -538}, {116, 116, 837}, {117, 65500, -538}, },
            {{36, 110, -36}, {111, 111, 838}, {112, 65500, -37}, },
            {{36, 100, -38}, {101, 101, 839}, {102, 65500, -47}, },
            {{36, 99, -667}, {100, 100, 840}, {101, 65500, -667}, },
            {{36, 65500, -10}, },
            {{36, 104, -560}, {105, 105, 841}, {106, 65500, -566}, },
            {{36, 115, -538}, {116, 116, 842}, {117, 65500, -538}, },
            {{36, 65500, -10}, },
            {{36, 114, -535}, {115, 115, 843}, {116, 65500, -535}, },
            {{36, 101, -43}, {102, 102, 844}, {103, 65500, -543}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 95, -10}, {97, 121, 273}, {122, 122, 845}, {170, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 65500, -10}, },
            {{36, 100, -38}, {101, 101, 846}, {102, 65500, -47}, },
            {{36, 99, -667}, {100, 100, 847}, {101, 65500, -667}, },
            {{36, 65500, -10}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {0, 0, 0, 0, 0, 0, 67, -1, 107, 86, 83, -1, 55, 56, 81, 79, 62, 80, 63, 82, 101, 101, 70, 61, 65, 64, 66, 69, 107, 59, 60, 85, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 57, 84, 58, 68, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 0, 74, -1, 106, -1, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 97, 75, 94, -1, -1, 92, 77, 90, 78, 91, 104, -1, 3, 93, 104, 103, -1, 104, -1, 104, 101, -1, 104, -1, 104, 101, -1, 101, 87, 72, 71, 73, 88, 96, 107, 107, 107, 107, 107, 107, 107, 107, 107, 15, 107, 107, 107, 107, 107, 107, 107, 24, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 95, 76, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 104, -1, 104, 104, -1, 104, -1, -1, -1, -1, 3, 3, 3, 104, 104, -1, 104, 104, -1, 104, 103, 103, -1, -1, 104, 102, 102, 102, 98, 99, 89, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 22, 107, 107, 107, 28, 107, 107, 32, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 48, 107, 107, 107, -1, -1, -1, -1, -1, -1, 104, -1, -1, -1, -1, -1, -1, 2, 3, -1, -1, 104, 104, 104, 104, 104, 102, 102, 100, 107, 107, 107, 7, 8, 107, 10, 107, 107, 107, 107, 107, 17, 107, 107, 107, 107, 23, 107, 107, 107, 107, 30, 107, 54, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 44, 107, 107, 52, 49, 107, 107, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, 107, 107, 6, 9, 11, 12, 107, 107, 107, 107, 53, 19, 21, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 38, 107, 107, 41, 107, 107, 45, 107, 107, 51, -1, -1, -1, -1, -1, -1, 107, 107, 107, 107, 16, 107, 107, 107, 26, 107, 107, 31, 107, 107, 107, 36, 37, 39, 107, 42, 107, 46, 107, 107, -1, 107, 5, 107, 14, 18, 20, 107, 107, 107, 33, 34, 107, 107, 107, 107, 107, 4, 13, 107, 107, 107, 107, 40, 107, 107, 50, 107, 107, 29, 35, 107, 47, 25, 27, 107, 107, 43, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
